/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DefaultSQLHandler;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.database.DatabaseUnitils;
import org.unitils.database.config.DataSourceFactory;
import org.unitils.database.config.DatabaseConfiguration;
import org.unitils.database.transaction.UnitilsTransactionManager;
import org.unitils.dbmaintainer.DBMaintainer;
import org.unitils.dbmaintainer.clean.DBCleaner;
import org.unitils.dbmaintainer.clean.DBClearer;
import org.unitils.dbmaintainer.structure.ConstraintsDisabler;
import org.unitils.dbmaintainer.structure.DataSetStructureGenerator;
import org.unitils.dbmaintainer.structure.SequenceUpdater;
import org.unitils.dbmaintainer.util.DatabaseAccessing;
import org.unitils.dbmaintainer.util.DatabaseModuleConfigUtils;
import org.unitils.util.PropertyUtils;

public class DataSourceWrapper {
    private static final Log LOGGER = LogFactory.getLog(DataSourceWrapper.class);
    private DataSource wrappedDataSource;
    protected DatabaseConfiguration databaseConfiguration;
    private DataSourceFactory dataSourceFactory;
    private boolean updateDatabaseSchemaEnabled;
    private Properties configuration;
    private String databaseName;
    protected Connection connection;
    private UnitilsTransactionManager transactionManager;
    private boolean wrapDataSourceInTransactionalProxy;

    public DataSourceWrapper(DatabaseConfiguration databaseConfiguration, UnitilsTransactionManager transactionManager) {
        this(databaseConfiguration, Unitils.getInstance().getConfiguration(), transactionManager);
    }

    public DataSourceWrapper(DatabaseConfiguration databaseConfiguration, Properties unitilsConfig, UnitilsTransactionManager transactionmanager) {
        this.configuration = unitilsConfig;
        this.dataSourceFactory = (DataSourceFactory)ConfigUtils.getConfiguredInstanceOf(DataSourceFactory.class, (Properties)this.configuration, (String[])new String[0]);
        this.dataSourceFactory.init(databaseConfiguration);
        this.updateDatabaseSchemaEnabled = PropertyUtils.getBoolean((String)"updateDataBaseSchema.enabled", (Properties)this.configuration);
        this.wrapDataSourceInTransactionalProxy = PropertyUtils.getBoolean((String)"dataSource.wrapInTransactionalProxy", (Properties)this.configuration);
        this.databaseName = databaseConfiguration.getDatabaseName();
        this.databaseConfiguration = databaseConfiguration;
        this.transactionManager = transactionmanager;
    }

    public Connection getConnection() {
        try {
            this.connection = DataSourceUtils.getConnection((DataSource)this.wrappedDataSource);
            return DatabaseUnitils.getGoodConnection(this.connection, this.wrappedDataSource);
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to connect to database for " + this.databaseConfiguration + ".", (Throwable)e);
        }
    }

    public DataSource getTransactionalDataSourceAndActivateTransactionIfNeeded(Object testObject) {
        if (this.wrapDataSourceInTransactionalProxy) {
            return this.transactionManager.getTransactionalDataSource(this.getDataSourceAndActivateTransactionIfNeeded());
        }
        return this.getDataSourceAndActivateTransactionIfNeeded();
    }

    public DataSource createDataSource() {
        DataSourceFactory dataSourceFactory = (DataSourceFactory)ConfigUtils.getConfiguredInstanceOf(DataSourceFactory.class, (Properties)this.configuration, (String[])new String[0]);
        dataSourceFactory.init(this.configuration, this.databaseName);
        DataSource dataSource = dataSourceFactory.createDataSource();
        if (this.updateDatabaseSchemaEnabled) {
            this.updateDatabase((SQLHandler)new DefaultSQLHandler(dataSource));
        }
        return dataSource;
    }

    public void updateDatabase() {
        this.updateDatabase(this.getDefaultSqlHandler());
    }

    public void updateDatabase(SQLHandler sqlHandler) {
        LOGGER.info((Object)"Checking if database has to be updated.");
        DBMaintainer dbMaintainer = new DBMaintainer(this.configuration, sqlHandler, this.databaseConfiguration.getDialect(), this.databaseConfiguration.getSchemaNames());
        dbMaintainer.updateDatabase(this.databaseConfiguration.getDatabaseName(), this.databaseConfiguration.isDefaultDatabase());
    }

    protected SQLHandler getDefaultSqlHandler() {
        return new DefaultSQLHandler(this.getDataSourceAndActivateTransactionIfNeeded());
    }

    public DataSource getDataSourceAndActivateTransactionIfNeeded() {
        if (this.wrappedDataSource == null) {
            this.wrappedDataSource = this.createDataSource();
            this.activateTransactionIfNeeded();
        }
        return this.wrappedDataSource;
    }

    public void activateTransactionIfNeeded() {
        if (this.transactionManager != null) {
            this.transactionManager.activateTransactionIfNeeded(this.getTestObject());
        }
    }

    protected Object getTestObject() {
        return Unitils.getInstance().getTestContext().getTestObject();
    }

    public DataSource getDataSource() {
        if (this.wrappedDataSource == null) {
            this.wrappedDataSource = this.createDataSource();
        }
        return this.wrappedDataSource;
    }

    public void clearSchemas() {
        this.getConfiguredDatabaseTaskInstance(DBClearer.class).clearSchemas();
    }

    public void cleanSchemas() {
        this.getConfiguredDatabaseTaskInstance(DBCleaner.class).cleanSchemas();
    }

    public void disableConstraints() {
        this.getConfiguredDatabaseTaskInstance(ConstraintsDisabler.class).disableConstraints();
    }

    public void updateSequences() {
        this.getConfiguredDatabaseTaskInstance(SequenceUpdater.class).updateSequences();
    }

    protected <T extends DatabaseAccessing> T getConfiguredDatabaseTaskInstance(Class<T> databaseTaskType) {
        return (T)DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(databaseTaskType, (Properties)this.configuration, (SQLHandler)this.getDefaultSqlHandler(), (String)this.databaseConfiguration.getDialect(), this.databaseConfiguration.getSchemaNames());
    }

    public void generateDatasetDefinition() {
        this.getConfiguredDatabaseTaskInstance(DataSetStructureGenerator.class).generateDataSetStructure();
    }

    public boolean isDataSourceLoaded() {
        return this.wrappedDataSource != null;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.databaseConfiguration;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setTransactionManager(UnitilsTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

