/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.webres.dom.ComponentNode;
import org.unidal.webres.dom.ITagNode;
import org.unidal.webres.dom.TagNode;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TagXmlParser
extends DefaultHandler {
    private TagNode m_current;
    private SAXParser m_parser;
    private static ThreadLocal<SAXParser> s_local = new ThreadLocal<SAXParser>(){

        @Override
        protected SAXParser initialValue() {
            try {
                return SAXParserFactory.newInstance().newSAXParser();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isAllWhiteSpace(ch, start, length)) {
            return;
        }
        String text = new String(ch, start, length);
        this.m_current.appendText(text);
    }

    private boolean isAllWhiteSpace(char[] chars, int start, int length) {
        int i = 0;
        while (i < length) {
            if (chars[start + i] > ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private TagNode createElement(String tagName, Attributes attributes, ITagNode parent) {
        TagNode element = null;
        element = "esf_tag_component".equals(tagName) ? new ComponentNode(parent) : new TagNode(tagName, parent);
        int length = attributes == null ? 0 : attributes.getLength();
        int i = 0;
        while (i < length) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            element.setAttribute(name, value);
            ++i;
        }
        return element;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.m_current = (TagNode)this.m_current.getParent();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public ITagNode parse(String snippet) throws SAXException, IOException {
        try {
            if (this.m_parser == null) {
                this.m_parser = s_local.get();
            }
            XMLReader reader = this.m_parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            if (this.m_parser.getClass().getName().equals("org.apache.xerces.jaxp.SAXParserImpl")) {
                String feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
                reader.setFeature(feature, false);
            }
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            reader.parse(new InputSource(new StringReader("<tag>" + snippet + "</tag>")));
            ITagNode iTagNode = (ITagNode)this.m_current.getFirstChild();
            return iTagNode;
        }
        finally {
            this.m_parser.reset();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.m_current == null) {
            this.m_current = new TagNode("tag", null);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.m_current = this.createElement(localName, attributes, this.m_current);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e.toString());
    }
}

