/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import org.unidal.webres.tag.core.ITagEnv;
import org.unidal.webres.tag.core.ITagModel;

public interface ITag<T, M extends ITagModel> {
    public T build();

    public void end();

    public ITagEnv getEnv();

    public M getModel();

    public State getState();

    public void render(T var1);

    public void setEnv(ITagEnv var1);

    public void setState(State var1);

    public void start();

    public static enum State {
        CREATED(0, 1),
        STARTED(1, 2),
        BUILT(2, 3, 9),
        RENDERED(3, 9),
        ENDED(9, 1);

        private int m_id;
        private int[] m_nextStateIds;

        private State(int id, int ... nextStates) {
            this.m_id = id;
            this.m_nextStateIds = nextStates;
        }

        public boolean canTransit(State nextState) {
            int[] nArray = this.m_nextStateIds;
            int n = this.m_nextStateIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                if (id == nextState.getId()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int getId() {
            return this.m_id;
        }

        public boolean isBuilt() {
            return this == BUILT;
        }

        public boolean isCreated() {
            return this == CREATED;
        }

        public boolean isEnded() {
            return this == ENDED;
        }

        public boolean isRendered() {
            return this == RENDERED;
        }

        public boolean isStarted() {
            return this == STARTED;
        }
    }
}

