/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import org.unidal.webres.logging.ILogger;
import org.unidal.webres.logging.LoggerFactory;
import org.unidal.webres.tag.core.ITag;
import org.unidal.webres.tag.core.ITagEnv;
import org.unidal.webres.tag.core.ITagModel;

public abstract class BaseTag<T, M extends ITagModel>
implements ITag<T, M> {
    private ITag.State m_state;
    private M m_model;
    private ITagEnv m_env;

    public BaseTag(M model) {
        this.m_model = model;
        this.m_state = ITag.State.CREATED;
    }

    @Override
    public final ITag.State getState() {
        return this.m_state;
    }

    @Override
    public final void setState(ITag.State newState) {
        if (!this.m_state.canTransit(newState)) {
            throw new RuntimeException(String.format("Can't transit state from(%s) to (%s) in tag(%s)!", new Object[]{this.m_state, newState, this}));
        }
        this.m_state = newState;
    }

    protected String asString(Object ... attributes) {
        return this.asString(false, attributes);
    }

    protected void error(String message, Object ... args) {
        String error;
        ITagEnv env = this.getEnv();
        Object showErrorContext = env.getProperty("jsp.showErrorContext");
        if (Boolean.TRUE.equals(showErrorContext)) {
            int len = args.length;
            Object[] params = new Object[len + 1];
            System.arraycopy(args, 0, params, 0, len);
            params[len] = this.toString();
            error = String.format("<!-- " + message + " Tag: %s -->", params);
        } else {
            error = String.format("<!-- " + message + " -->", args);
        }
        env.err(error);
        ILogger logger = LoggerFactory.getLogger(this.getClass());
        if (logger.isErrorEnabled()) {
            logger.error(error);
        }
    }

    protected void out(Object obj) {
        ITagEnv env = this.getEnv();
        env.out(obj);
    }

    protected String asString(boolean allowNullValue, Object ... attributes) {
        int len = attributes.length;
        if (len % 2 != 0) {
            throw new RuntimeException("attributes value should be paired!");
        }
        StringBuilder sb = new StringBuilder(64);
        boolean first = true;
        sb.append(this.getClass().getSimpleName()).append("[");
        int i = 0;
        while (i < len) {
            Object name = attributes[i];
            Object value = attributes[i + 1];
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (allowNullValue || value != null) {
                sb.append(name).append('=').append(value);
            }
            i += 2;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void end() {
    }

    @Override
    public ITagEnv getEnv() {
        return this.m_env;
    }

    @Override
    public M getModel() {
        return this.m_model;
    }

    @Override
    public void setEnv(ITagEnv env) {
        this.m_env = env;
    }

    @Override
    public void start() {
    }
}

