/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unidal.webres.logging.LogLevel;

class LogFormatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    static final FastDateFormat DATE_FORMAT = new FastDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), 1000);

    LogFormatter() {
    }

    public static StringBuilder format(StringBuilder sb, long time) {
        return DATE_FORMAT.format(sb, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder format(StringBuilder sb, Throwable throwable) {
        if (throwable != null) {
            StringBuilder stringBuilder = sb;
            synchronized (stringBuilder) {
                StringBuilderWriter writer = new StringBuilderWriter(sb);
                PrintWriter pw = new PrintWriter(writer);
                try {
                    throwable.printStackTrace(pw);
                }
                catch (Exception e) {
                    System.err.println("Print stack trace exception");
                    e.printStackTrace();
                }
            }
        }
        return sb;
    }

    public static StringBuilder appendLevel(StringBuilder sb, LogLevel p) {
        if (p != null) {
            String levelName = p.name();
            sb.append(levelName);
            if (levelName.length() == 4) {
                sb.append(' ');
            }
        } else {
            sb.append((Object)LogLevel.INFO);
        }
        return sb;
    }

    public static StringBuilder format(StringBuilder sb, String name, String threadName, LogLevel level, long time, String message, Throwable throwable) {
        LogFormatter.format(sb, time).append(' ');
        LogFormatter.appendLevel(sb, level);
        sb.append(": ");
        if (message != null) {
            sb.append(message);
        }
        if (throwable != null) {
            sb.append(LINE_SEPARATOR);
            LogFormatter.format(sb, throwable);
        }
        return sb;
    }

    private static class FastDateFormat {
        private final DateFormat m_format;
        private long m_lastTime = -1L;
        private String m_lastResult = null;
        private int m_timeout = 1000;
        private Date m_date = new Date();

        public FastDateFormat(DateFormat format, int timeout) {
            this.m_format = format;
            this.m_timeout = timeout == -1 ? 1000 : timeout;
        }

        private String format0(Date date, long time) {
            this.m_lastResult = this.m_format.format(date);
            this.m_lastTime = time;
            return this.m_lastResult;
        }

        public StringBuilder format(StringBuilder sb, long time) {
            return sb.append(this.format(time));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String format(long time) {
            if (Math.abs(time - this.m_lastTime) > (long)this.m_timeout) {
                DateFormat dateFormat = this.m_format;
                synchronized (dateFormat) {
                    this.m_date.setTime(time);
                    this.format0(this.m_date, time);
                }
            }
            return this.m_lastResult;
        }
    }

    protected static class StringBuilderWriter
    extends Writer {
        private StringBuilder m_buf;

        public StringBuilderWriter(StringBuilder sb) {
            this.m_buf = sb;
            this.lock = sb;
        }

        @Override
        public void write(int c) {
            this.m_buf.append((char)c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.m_buf.append(cbuf, off, len);
        }

        @Override
        public void write(String str) {
            this.m_buf.append(str);
        }

        @Override
        public void write(String str, int off, int len) {
            this.m_buf.append(str.substring(off, off + len));
        }

        public String toString() {
            return this.m_buf.toString();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    }
}

