/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.logging;

import org.unidal.webres.logging.ILogger;
import org.unidal.webres.logging.LogLevel;

public abstract class BaseLogger
implements ILogger {
    private String m_name;
    private LogLevel m_level = LogLevel.INFO;

    public BaseLogger() {
    }

    public BaseLogger(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public LogLevel getLevel() {
        return this.m_level;
    }

    public void setLevel(LogLevel level) {
        this.m_level = level;
    }

    protected abstract void doLog(LogLevel var1, String var2, Throwable var3);

    @Override
    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(LogLevel level, String message, Throwable cause) {
        if (this.isLogEnabled(level)) {
            this.doLog(level, message, cause);
        }
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.log(LogLevel.ERROR, message, cause);
    }

    @Override
    public void info(String message) {
        this.info(message, null);
    }

    @Override
    public void info(String message, Throwable cause) {
        this.log(LogLevel.INFO, message, cause);
    }

    @Override
    public boolean isLogEnabled(LogLevel level) {
        return this.m_level.ordinal() <= level.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLogEnabled(LogLevel.ERROR);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLogEnabled(LogLevel.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLogEnabled(LogLevel.WARN);
    }

    @Override
    public void warn(String message) {
        this.warn(message, null);
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.log(LogLevel.WARN, message, cause);
    }
}

