/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.json.serializer;

import org.unidal.webres.json.SerializationException;
import org.unidal.webres.json.serializer.AbstractSerializer;
import org.unidal.webres.json.serializer.ObjectMatch;
import org.unidal.webres.json.serializer.SerializerState;

public class BooleanSerializer
extends AbstractSerializer {
    private static Class<?>[] s_serializableClasses = new Class[]{Boolean.TYPE, Boolean.class};
    private static Class<?>[] s_JSONClasses = new Class[]{Boolean.class, String.class};

    @Override
    public Class<?>[] getSerializableClasses() {
        return s_serializableClasses;
    }

    @Override
    public Class<?>[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class<?> clazz, Object jso) throws SerializationException {
        return ObjectMatch.OKAY;
    }

    @Override
    public Object unmarshall(SerializerState state, Class<?> clazz, Object jso) throws SerializationException {
        Object result = jso;
        if (jso instanceof String) {
            try {
                result = Boolean.valueOf((String)jso);
            }
            catch (Exception e) {
                throw new SerializationException("Cannot convert " + jso + " to Boolean");
            }
        }
        if (clazz == Boolean.TYPE) {
            result = (Boolean)jso;
        }
        return result;
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        return o;
    }
}

