/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.unidal.webres.converter.ConverterRuntime;

public class Reflects {
    private Reflects() {
    }

    public static ClassReflector forClass() {
        return ClassReflector.INSTANCE;
    }

    public static ConstructorReflector forConstructor() {
        return ConstructorReflector.INSTANCE;
    }

    public static FieldReflector forField() {
        return FieldReflector.INSTANCE;
    }

    public static MethodReflector forMethod() {
        return new MethodReflector();
    }

    public static ModifierReflector forModifier() {
        return ModifierReflector.INSTANCE;
    }

    public static enum ClassReflector {
        INSTANCE;


        public Class<?> getClass(String className) {
            return this.getClass(className, null);
        }

        public Class<?> getClass(String className, ClassLoader classloader) {
            Class<?> clazz;
            block7: {
                clazz = null;
                if (classloader != null) {
                    try {
                        clazz = classloader.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        if (clazz == null) {
                            clazz = this.getClass(className, Thread.currentThread().getContextClassLoader());
                        }
                        if (clazz != null) break block7;
                        clazz = this.getClass(className, Reflects.class.getClassLoader());
                    }
                }
            }
            return clazz;
        }

        public Class<?> getClass2(String className) {
            return this.getClass2(className, null);
        }

        public Class<?> getClass2(String className, ClassLoader classloader) {
            int pos;
            Class<?> clazz = null;
            String name = className;
            while ((clazz = this.getClass(name, classloader)) == null && (pos = name.lastIndexOf(46)) >= 0) {
                name = String.valueOf(name.substring(0, pos)) + '$' + name.substring(pos + 1);
            }
            return clazz;
        }

        public Class<?> getNestedClass(Class<?> clazz, String simpleName) {
            Class<?>[] subClasses;
            if (clazz != null && (subClasses = clazz.getDeclaredClasses()) != null) {
                Class<?>[] classArray = subClasses;
                int n = subClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> subClass = classArray[n2];
                    if (subClass.getSimpleName().equals(simpleName)) {
                        return subClass;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public Class<?> getNestedClass(String className, String simpleName) {
            return this.getNestedClass(this.getClass(className), simpleName);
        }

        public Class<?> getNestedClass(String className, String simpleName, ClassLoader classloader) {
            return this.getNestedClass(this.getClass(className, classloader), simpleName);
        }
    }

    public static enum ConstructorReflector {
        INSTANCE;


        public Object createInstance(Class<?> clazz, Object ... typesAndParameters) {
            try {
                TypeArguments typeArgs = new TypeArguments(typesAndParameters);
                Constructor<?> constructor = clazz.getConstructor(typeArgs.getTypes());
                return constructor.newInstance(typeArgs.getArguments());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static enum FieldFilter implements IMemberFilter<Field>
    {
        PUBLIC{

            @Override
            public boolean filter(Field field) {
                return ModifierReflector.INSTANCE.isPublic(field);
            }
        }
        ,
        STATIC{

            @Override
            public boolean filter(Field field) {
                return ModifierReflector.INSTANCE.isStatic(field);
            }
        }
        ,
        PUBLIC_STATIC{

            @Override
            public boolean filter(Field field) {
                return ModifierReflector.INSTANCE.isPublic(field) && ModifierReflector.INSTANCE.isStatic(field);
            }
        };

    }

    public static enum FieldReflector {
        INSTANCE;


        public List<Field> getDeclaredFields(Class<?> clazz, IMemberFilter<Field> filter) {
            Field[] fields;
            ArrayList<Field> list = new ArrayList<Field>();
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (filter == null || filter.filter(field)) {
                    list.add(field);
                }
                ++n2;
            }
            return list;
        }

        public <T> T getDeclaredFieldValue(Class<?> clazz, String fieldName, Object instance) {
            if (clazz != null) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return (T)field.get(instance);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public List<Field> getFields(Class<?> clazz, IMemberFilter<Field> filter) {
            Field[] fields;
            ArrayList<Field> list = new ArrayList<Field>();
            Field[] fieldArray = fields = clazz.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (filter == null || filter.filter(field)) {
                    list.add(field);
                }
                ++n2;
            }
            return list;
        }

        public <T> T getFieldValue(Object instance, String fieldName) {
            if (instance != null) {
                try {
                    Field field = instance.getClass().getField(fieldName);
                    return (T)field.get(instance);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T getStaticFieldValue(Class<?> clazz, String fieldName) {
            if (clazz != null) {
                try {
                    Field field = clazz.getField(fieldName);
                    return (T)field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T getStaticFieldValue(String className, String fieldName) {
            try {
                Class<?> clazz = Reflects.forClass().getClass(className);
                if (clazz != null) {
                    return this.getStaticFieldValue(clazz, fieldName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static interface IMemberFilter<T extends Member> {
        public boolean filter(T var1);
    }

    public static enum MethodFilter implements IMemberFilter<Method>
    {
        PUBLIC{

            @Override
            public boolean filter(Method method) {
                return ModifierReflector.INSTANCE.isPublic(method);
            }
        }
        ,
        STATIC{

            @Override
            public boolean filter(Method method) {
                return ModifierReflector.INSTANCE.isStatic(method);
            }
        }
        ,
        PUBLIC_STATIC{

            @Override
            public boolean filter(Method method) {
                return ModifierReflector.INSTANCE.isPublic(method) && ModifierReflector.INSTANCE.isStatic(method);
            }
        };

    }

    public static class MethodReflector {
        public Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public List<Method> getDeclaredMethods(Class<?> clazz, IMemberFilter<Method> filter) {
            ArrayList<Method> list = new ArrayList<Method>();
            try {
                Method[] methods;
                Method[] methodArray = methods = clazz.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (filter == null || filter.filter(method)) {
                        list.add(method);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
        }

        public String getGetMethodName(String propertyName) {
            int len;
            int n = len = propertyName == null ? 0 : propertyName.length();
            if (len == 0) {
                throw new IllegalArgumentException(String.format("Invalid property name: %s!", propertyName));
            }
            StringBuilder sb = new StringBuilder(len + 3);
            sb.append("get");
            sb.append(Character.toUpperCase(propertyName.charAt(0)));
            sb.append(propertyName.substring(1));
            return sb.toString();
        }

        public String getSetMethodName(String propertyName) {
            int len;
            int n = len = propertyName == null ? 0 : propertyName.length();
            if (len == 0) {
                throw new IllegalArgumentException(String.format("Invalid property name: %s!", propertyName));
            }
            StringBuilder sb = new StringBuilder(len + 3);
            sb.append("set");
            sb.append(Character.toUpperCase(propertyName.charAt(0)));
            sb.append(propertyName.substring(1));
            return sb.toString();
        }

        public Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
            try {
                return clazz.getMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public List<Method> getMethods(Class<?> clazz, IMemberFilter<Method> filter) {
            ArrayList<Method> list = new ArrayList<Method>();
            try {
                Method[] methods;
                Method[] methodArray = methods = clazz.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (filter == null || filter.filter(method)) {
                        list.add(method);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
        }

        public <T> T getPropertyValue(Object instance, String propertyName) {
            if (propertyName.length() > 0) {
                String suffix = String.valueOf(Character.toUpperCase(propertyName.charAt(0))) + propertyName.substring(1);
                Method method = this.getMethod(instance.getClass(), "get" + suffix, new Class[0]);
                if (method == null && (method = this.getMethod(instance.getClass(), "is" + suffix, new Class[0])) != null && method.getReturnType() != Boolean.TYPE) {
                    method = null;
                }
                if (method != null) {
                    try {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        return (T)method.invoke(instance, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public void setPropertyValue(Object instance, String propertyName, Object value) throws Exception {
            final String methodName = this.getSetMethodName(propertyName);
            Class<?> clazz = instance.getClass();
            boolean[] invoked = new boolean[1];
            try {
                this.invokeMatchedMethod0(invoked, instance, clazz, methodName, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!invoked[0]) {
                List<Method> methods = this.getMethods(clazz, new IMemberFilter<Method>(){

                    @Override
                    public boolean filter(Method member) {
                        return member.getParameterTypes().length == 1 && methodName.equals(member.getName());
                    }
                });
                if (methods.isEmpty()) {
                    throw new IllegalArgumentException("No such method:" + methodName + " for the value:" + value);
                }
                if (methods.size() > 1) {
                    throw new IllegalStateException("There are " + methods.size() + " methods with name:" + methodName + " for null value. Can't know invoking which one");
                }
                if (value == null) {
                    Method methodMatched = methods.get(0);
                    methodMatched.invoke(instance, new Object[]{null});
                } else {
                    throw new IllegalArgumentException("No such method:" + methodName + " for the value:" + value);
                }
            }
        }

        public Method getMatchedMethod(Class<?> clazz, String methodName, Object ... paramValues) {
            Method[] methods = clazz.getMethods();
            int i = 0;
            int len = methods.length;
            while (i < len) {
                Class<?>[] classes;
                Method method = methods[i];
                if (methodName.equals(method.getName()) && (classes = method.getParameterTypes()).length >= paramValues.length && this.isParamMatch(classes, paramValues, false)) {
                    return method;
                }
                ++i;
            }
            return null;
        }

        public Object invokeMatchedMethod(Object obj, Class<?> clazz, String methodName, Object ... paramValues) throws InvocationTargetException, IllegalAccessException {
            Method[] methods = clazz.getMethods();
            int i = 0;
            int len = methods.length;
            while (i < len) {
                Class<?>[] classes;
                Method method = methods[i];
                if (Modifier.isPublic(method.getModifiers()) && methodName.equals(method.getName()) && (classes = method.getParameterTypes()).length >= paramValues.length && this.isParamMatch(classes, paramValues, true)) {
                    return method.invoke(obj, paramValues);
                }
                ++i;
            }
            return null;
        }

        private Object invokeMatchedMethod0(boolean[] invoked, Object obj, Class<?> clazz, String methodName, Object ... paramValues) throws InvocationTargetException, IllegalAccessException {
            Method[] methods = clazz.getMethods();
            int i = 0;
            int len = methods.length;
            while (i < len) {
                Class<?>[] classes;
                Method method = methods[i];
                if (Modifier.isPublic(method.getModifiers()) && methodName.equals(method.getName()) && (classes = method.getParameterTypes()).length >= paramValues.length && this.isParamMatch(classes, paramValues, true)) {
                    invoked[0] = true;
                    return method.invoke(obj, paramValues);
                }
                ++i;
            }
            return null;
        }

        public boolean isParamMatch(Class<?>[] paramTypes, Object[] paramValues, boolean convertValue) {
            Object[] newParamValues = new Object[paramValues.length];
            int i = 0;
            int len = paramTypes.length;
            while (i < len) {
                if (paramValues[i] != null) {
                    if (paramTypes[i].isAssignableFrom(paramValues[i].getClass())) {
                        newParamValues[i] = paramValues[i];
                    } else {
                        if (Enum.class.isAssignableFrom(paramTypes[i]) && paramValues[i] instanceof String) {
                            try {
                                newParamValues[i] = Enum.valueOf(paramTypes[i], (String)paramValues[i]);
                            }
                            catch (Exception ex) {
                                return false;
                            }
                        }
                        try {
                            newParamValues[i] = ConverterRuntime.INSTANCE.getManager().convert(paramValues[i], paramTypes[i]);
                        }
                        catch (Exception ex) {
                            return false;
                        }
                    }
                }
                ++i;
            }
            if (convertValue) {
                i = 0;
                len = paramValues.length;
                while (i < len) {
                    paramValues[i] = newParamValues[i];
                    ++i;
                }
            }
            return true;
        }

        public <T> T invokeDeclaredMethod(Object instance, String methodName, Object ... typesAndParameters) {
            if (instance == null) {
                return null;
            }
            TypeArguments typeArgs = new TypeArguments(typesAndParameters);
            Method method = this.getDeclaredMethod(instance.getClass(), methodName, typeArgs.getTypes());
            if (method != null) {
                try {
                    method.setAccessible(true);
                    return (T)method.invoke(instance, typeArgs.getArguments());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T invokeMethod(Object instance, String methodName, Object ... typesAndParameters) {
            if (instance == null) {
                return null;
            }
            TypeArguments typeArgs = new TypeArguments(typesAndParameters);
            Method method = this.getMethod(instance.getClass(), methodName, typeArgs.getTypes());
            if (method != null) {
                try {
                    return (T)method.invoke(instance, typeArgs.getArguments());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T invokeStaticMethod(Class<?> clazz, String methodName, Object ... typesAndParameters) {
            if (clazz == null) {
                return null;
            }
            TypeArguments typeArgs = new TypeArguments(typesAndParameters);
            Method method = this.getMethod(clazz, methodName, typeArgs.getTypes());
            if (method != null) {
                try {
                    return (T)method.invoke(null, typeArgs.getArguments());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static enum ModifierReflector {
        INSTANCE;


        public boolean isPublic(Class<?> clazz) {
            return Modifier.isPublic(clazz.getModifiers());
        }

        public boolean isVisible(Class<?> clazz) {
            int modifiers = clazz.getModifiers();
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
        }

        public boolean isPublic(Member member) {
            return Modifier.isPublic(member.getModifiers());
        }

        public boolean isStatic(Class<?> clazz) {
            return Modifier.isStatic(clazz.getModifiers());
        }

        public boolean isStatic(Member member) {
            return Modifier.isStatic(member.getModifiers());
        }
    }

    static class TypeArguments {
        private Class<?>[] m_types;
        private Object[] m_arguments;

        public TypeArguments(Object ... typesAndParameters) {
            int length = typesAndParameters.length;
            if (length % 2 != 0) {
                throw new IllegalArgumentException(String.format("Constrcutor argument types and data should be even, but was odd: %s.", length));
            }
            int half = length / 2;
            Class[] types = new Class[half];
            Object[] arguments = new Object[half];
            int i = 0;
            while (i < half) {
                types[i] = (Class)typesAndParameters[2 * i];
                arguments[i] = typesAndParameters[2 * i + 1];
                ++i;
            }
            this.m_types = types;
            this.m_arguments = arguments;
        }

        public Object[] getArguments() {
            return this.m_arguments;
        }

        public Class<?>[] getTypes() {
            return this.m_types;
        }
    }
}

