/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterRuntime;
import org.unidal.webres.converter.TypeUtil;

public class Proxies {
    public static ObjectProxy forObject() {
        return new ObjectProxy();
    }

    private static Object convertedValue(Object from, Type targetType) {
        Object value = null;
        try {
            value = ConverterRuntime.INSTANCE.getManager().convert(from, targetType);
        }
        catch (ConverterException converterException) {
            // empty catch block
        }
        return value;
    }

    public static interface IAccessor<T> {
        public Object getValue(T var1, Method var2, Object[] var3) throws Throwable;

        public boolean isEligible(T var1, Method var2, Object[] var3);
    }

    public static class ListAccessor
    implements IAccessor<List<Object>> {
        private Map<String, Integer> m_mapping;

        public ListAccessor(Map<String, Integer> mapping) {
            this.m_mapping = mapping;
            if (this.m_mapping == null) {
                throw new RuntimeException("Mapping info cannot be null.");
            }
        }

        @Override
        public Object getValue(List<Object> instance, Method method, Object[] args) throws Throwable {
            Integer locIndex = this.m_mapping.get(method.getName());
            return Proxies.convertedValue(instance.get(locIndex - 1), method.getReturnType());
        }

        @Override
        public boolean isEligible(List<Object> instance, Method method, Object[] args) {
            Integer locIndex = this.m_mapping.get(method.getName());
            Class<?> methodReturnType = method.getReturnType();
            return locIndex != null && instance.size() >= locIndex && Proxies.convertedValue(instance.get(locIndex - 1), methodReturnType) != null;
        }
    }

    public static class MapAccessor
    implements IAccessor<Map<String, Object>> {
        private Map<String, String> m_mapping;

        public MapAccessor() {
            this(Collections.emptyMap());
        }

        public MapAccessor(Map<String, String> mapping) {
            this.m_mapping = mapping;
            if (this.m_mapping == null) {
                throw new RuntimeException("Mapping info cannot be null.");
            }
        }

        @Override
        public Object getValue(Map<String, Object> map, Method method, Object[] args) {
            String key = this.m_mapping.get(method.getName());
            if (key == null) {
                key = method.getName();
            }
            return Proxies.convertedValue(map.get(key), method.getReturnType());
        }

        @Override
        public boolean isEligible(Map<String, Object> map, Method method, Object[] args) {
            String key = this.m_mapping.get(method.getName());
            if (key == null) {
                key = method.getName();
            }
            return map.containsKey(key) && Proxies.convertedValue(map.get(key), method.getReturnType()) != null;
        }
    }

    public static class ObjectProxy {
        public <T> T newInstance(ClassLoader classLoader, Object implementation, Class<T> firstInterface, Class<?> ... otherInterfaces) {
            return this.newInstance(classLoader, implementation, new PojoAccessor(), firstInterface, otherInterfaces);
        }

        public <T> T newInstance(ClassLoader classLoader, Object implementation, IAccessor<?> accessor, Class<T> firstInterface, Class<?> ... otherInterfaces) {
            if (implementation == null) {
                throw new RuntimeException("Implementation object should not be null!");
            }
            if (accessor == null) {
                throw new RuntimeException("Accessor should not be null!");
            }
            int len = otherInterfaces.length + 1;
            Class[] interfaces = new Class[len];
            interfaces[0] = firstInterface;
            if (len > 1) {
                System.arraycopy(otherInterfaces, 0, interfaces, 1, len - 1);
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Object instance = null;
            try {
                instance = Proxy.newProxyInstance(contextClassLoader, interfaces, (InvocationHandler)new ProxyInvocationHandler(implementation, accessor));
            }
            catch (IllegalArgumentException e) {
                instance = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ProxyInvocationHandler(implementation, accessor));
            }
            return (T)instance;
        }

        public <T> T newInstance(Object implementation, Class<T> firstInterface, Class<?> ... otherInterfaces) {
            return this.newInstance(Thread.currentThread().getContextClassLoader(), implementation, new PojoAccessor(), firstInterface, otherInterfaces);
        }

        public <T> T newInstance(Object implementation, IAccessor<?> accessor, Class<T> firstInterface, Class<?> ... otherInterfaces) {
            return this.newInstance(Thread.currentThread().getContextClassLoader(), implementation, accessor, firstInterface, otherInterfaces);
        }
    }

    public static class PojoAccessor
    implements IAccessor<Object> {
        private Map<String, String> m_mapping;

        public PojoAccessor() {
            this(Collections.emptyMap());
        }

        public PojoAccessor(Map<String, String> mapping) {
            this.m_mapping = mapping;
            if (this.m_mapping == null) {
                throw new RuntimeException("Mapping info cannot be null.");
            }
        }

        private boolean checkParamTypes(Object[] args, Class<?>[] paramTypes) {
            int len2;
            int len1 = args == null ? 0 : paramTypes.length;
            int n = len2 = args == null ? 0 : args.length;
            if (len1 == len2) {
                int i = 0;
                while (i < len1) {
                    Class<?> argsType = args[i].getClass();
                    if (TypeUtil.isPrimaryClass(argsType)) {
                        argsType = TypeUtil.getPrimitiveClass(argsType);
                    }
                    if (!paramTypes[i].isAssignableFrom(argsType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        private Method getMethod(Object pojo, Method method, String targetMethodName, Object[] args) {
            Method[] methods;
            Method[] methodArray = methods = pojo.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals(targetMethodName)) {
                    boolean paramTypesMatch = this.checkParamTypes(args, method.getParameterTypes());
                    boolean returnTypeMatch = false;
                    try {
                        Object invokeResult = m.invoke(pojo, args);
                        returnTypeMatch = Proxies.convertedValue(invokeResult, method.getReturnType()) != null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (paramTypesMatch && returnTypeMatch) {
                        return m;
                    }
                }
                ++n2;
            }
            return null;
        }

        private Method getMethodWithMapping(Object pojo, Method method, Object[] args) {
            String targetMethodName = method.getName();
            if (this.m_mapping.containsKey(targetMethodName)) {
                targetMethodName = this.m_mapping.get(targetMethodName);
            }
            return this.getMethod(pojo, method, targetMethodName, args);
        }

        @Override
        public Object getValue(Object pojo, Method method, Object[] args) throws Throwable {
            Method targetMethod = this.getMethodWithMapping(pojo, method, args);
            if (targetMethod == null) {
                throw new RuntimeException("Internal error, isEligible() should be called first!");
            }
            if (!targetMethod.isAccessible()) {
                targetMethod.setAccessible(true);
            }
            return Proxies.convertedValue(targetMethod.invoke(pojo, args), method.getReturnType());
        }

        @Override
        public boolean isEligible(Object pojo, Method method, Object[] args) {
            return this.getMethodWithMapping(pojo, method, args) != null;
        }
    }

    public static class PrimitiveAccessor
    implements IAccessor<Object> {
        @Override
        public Object getValue(Object instance, Method method, Object[] args) throws Throwable {
            return Proxies.convertedValue(instance, method.getReturnType());
        }

        @Override
        public boolean isEligible(Object instance, Method method, Object[] args) {
            return Proxies.convertedValue(instance, method.getReturnType()) != null;
        }
    }

    static class ProxyInvocationHandler
    implements InvocationHandler {
        private IAccessor<Object> m_accessor;
        private Object m_instance;

        public ProxyInvocationHandler(Object instance, IAccessor<Object> accessor) {
            this.m_instance = instance;
            this.m_accessor = accessor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (this.m_accessor.isEligible(this.m_instance, method, args)) {
                return this.m_accessor.getValue(this.m_instance, method, args);
            }
            throw new UnsupportedOperationException(String.format("No method(%s) defined in %s", name, this.m_instance.getClass()));
        }
    }

    public static class RouterAccessor
    implements IAccessor<Object> {
        private IAccessor<Object> m_accessor;
        private Object m_value;

        public RouterAccessor(Object value, Map<String, String> mapping) {
            IAccessor<Object> accessor;
            this.m_value = value;
            if (value == null) {
                throw new RuntimeException("Value should not be null!");
            }
            if (this.isPrimitiveValue(value)) {
                accessor = new PrimitiveAccessor();
            } else if (value instanceof Map) {
                this.m_value = this.convertToGetPrefixByMap((Map)value);
                accessor = new MapAccessor(this.convertToGetPrefix(mapping));
            } else {
                accessor = value instanceof List ? new ListAccessor(this.convertToGetPrefixByLoc(mapping)) : new PojoAccessor(this.convertToGetPrefix(mapping));
            }
            this.m_accessor = accessor;
        }

        private Map<String, String> convertToGetPrefix(Map<String, String> mapping) {
            HashMap<String, String> newMapping = new HashMap<String, String>();
            if (mapping != null) {
                for (Map.Entry<String, String> e : mapping.entrySet()) {
                    newMapping.put(this.convertAttrToMethodName(e.getValue()), this.convertAttrToMethodName(e.getKey()));
                }
            }
            return newMapping;
        }

        private Map<String, Object> convertToGetPrefixByMap(Map<String, Object> map) {
            HashMap<String, Object> newMapping = new HashMap<String, Object>();
            if (map != null) {
                for (Map.Entry<String, Object> e : map.entrySet()) {
                    newMapping.put(this.convertAttrToMethodName(e.getKey()), e.getValue());
                }
            }
            return newMapping;
        }

        private Map<String, Integer> convertToGetPrefixByLoc(Map<String, String> mapping) {
            HashMap<String, Integer> newMapping = new HashMap<String, Integer>();
            if (mapping != null) {
                for (Map.Entry<String, String> e : mapping.entrySet()) {
                    newMapping.put(this.convertAttrToMethodName(e.getValue()), Integer.valueOf(e.getKey()));
                }
            }
            return newMapping;
        }

        private String convertAttrToMethodName(String attr) {
            return "get" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
        }

        public IAccessor<Object> getAccessor() {
            return this.m_accessor;
        }

        @Override
        public Object getValue(Object instance, Method method, Object[] args) throws Throwable {
            return this.m_accessor.getValue(this.m_value, method, args);
        }

        @Override
        public boolean isEligible(Object instance, Method method, Object[] args) {
            return this.m_accessor.isEligible(this.m_value, method, args);
        }

        protected boolean isPrimitiveValue(Object value) {
            Class<?> clazz = TypeUtil.getPrimitiveClass(value.getClass());
            return clazz.isPrimitive() || value instanceof String || value instanceof Date;
        }
    }
}

