/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.dom;

import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.ITagNode;

public abstract class BaseNode
implements INode {
    private INode m_parentNode;

    public BaseNode(ITagNode parent) {
        this.m_parentNode = parent;
        if (parent != null) {
            parent.add(this);
        }
    }

    protected abstract void asString(StringBuilder var1);

    protected String encode(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public INode getParent() {
        return this.m_parentNode;
    }

    void setParent(INode node) {
        this.m_parentNode = node;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        this.asString(sb);
        return sb.toString();
    }
}

