/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.node;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterUtil;
import org.unidal.webres.converter.TypeUtil;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.ITagNode;
import org.unidal.webres.dom.TagNode;

public class TagNodeConverter
implements Converter<Object> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return INode.class.isAssignableFrom(ctx.getSourceClass());
    }

    @Override
    public Object convert(ConverterContext ctx) throws ConverterException {
        TagNode node = (TagNode)ctx.getSource();
        Class<?> targetClass = ctx.getTargetClass();
        Type targetType = ctx.getTargetType();
        if (targetClass.isPrimitive() || TypeUtil.getPrimitiveClass(targetClass).isPrimitive()) {
            String text = (String)ctx.getManager().convert(node, (Type)((Object)String.class));
            return ctx.getManager().convert(text, targetType);
        }
        Class<?> concreteClass = ctx.getManager().getRegistry().findType(targetClass);
        try {
            Object instance = concreteClass.newInstance();
            if (node.hasAttributes()) {
                this.convertAttributes(ctx, instance, targetType, node.getAttributes());
            }
            this.convertNodeList(ctx, instance, targetType, node.getChildNodes());
            return instance;
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private void convertAttributes(ConverterContext ctx, Object instance, Type instanceType, Map<String, String> map) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = instance.getClass();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String text = entry.getValue();
            if (ConverterContext.isOverride() && this.isELAttribute(key, text)) continue;
            String methodName = ConverterUtil.getSetMethodName(key);
            Method method = ConverterUtil.getSetMethod(clazz, methodName);
            Type parameterType = method.getGenericParameterTypes()[0];
            Object value = ctx.getManager().convert(text, parameterType);
            method.invoke(instance, value);
        }
    }

    private boolean isELAttribute(String attrName, String attrValue) {
        if (attrName == null || attrValue == null) {
            return false;
        }
        return attrName.equals("value") && attrValue.startsWith("${") && attrValue.endsWith("}");
    }

    private void convertNode(ConverterContext ctx, Object instance, Type instanceType, ITagNode child) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = instance.getClass();
        String methodName = ConverterUtil.getSetMethodName(child.getNodeName());
        Method method = ConverterUtil.getSetMethod(clazz, methodName);
        Type parameterType = method.getGenericParameterTypes()[0];
        Type resolvedParameterType = instanceType instanceof ParameterizedType && parameterType instanceof TypeVariable ? TypeUtil.resolveType((ParameterizedType)instanceType, clazz, (TypeVariable)parameterType) : parameterType;
        Class<?> rawType = TypeUtil.getRawType(resolvedParameterType);
        Object value = null;
        if (rawType.isAssignableFrom(child.getClass())) {
            value = child;
        } else if (rawType.isArray() || List.class.isAssignableFrom(rawType)) {
            value = ctx.getManager().convert(child, resolvedParameterType);
        } else if (rawType.isPrimitive() || TypeUtil.getPrimitiveClass(rawType).isPrimitive()) {
            String text = (String)ctx.getManager().convert(child, (Type)((Object)String.class));
            value = ctx.getManager().convert(text, resolvedParameterType);
        } else {
            try {
                value = ctx.getManager().convert(child, resolvedParameterType);
            }
            catch (ConverterException e) {
                String text = (String)ctx.getManager().convert(child, (Type)((Object)String.class));
                value = ctx.getManager().convert(text, resolvedParameterType);
            }
        }
        method.invoke(instance, value);
    }

    private void convertNodeList(ConverterContext ctx, Object instance, Type instanceType, List<INode> nodeList) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (INode child : nodeList) {
            this.convertNode(ctx, instance, instanceType, (ITagNode)child);
        }
    }

    @Override
    public Type getTargetType() {
        return Type.class;
    }
}

