/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.AbstractLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private Map<String, Logger> loggerCache = new HashMap<String, Logger>();
    private String threshold = "info";
    private int currentThreshold;

    @Override
    public void initialize() {
        this.currentThreshold = this.parseThreshold(this.threshold);
        if (this.currentThreshold == -1) {
            this.currentThreshold = 0;
        }
    }

    protected int parseThreshold(String text) {
        if ((text = text.trim().toLowerCase(Locale.ENGLISH)).equals("debug")) {
            return 0;
        }
        if (text.equals("info")) {
            return 1;
        }
        if (text.equals("warn")) {
            return 2;
        }
        if (text.equals("error")) {
            return 3;
        }
        if (text.equals("fatal")) {
            return 4;
        }
        return -1;
    }

    @Override
    public void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    @Override
    public void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        Iterator<Logger> iterator = this.loggerCache.values().iterator();
        while (iterator.hasNext()) {
            Logger o;
            Logger logger = o = iterator.next();
            logger.setThreshold(currentThreshold);
        }
    }

    @Override
    public int getThreshold() {
        return this.currentThreshold;
    }

    @Override
    public void setThreshold(String role, String roleHint, int threshold) {
        String key = this.toMapKey(role, roleHint);
        AbstractLogger logger = (AbstractLogger)this.loggerCache.get(key);
        if (logger == null) {
            return;
        }
        logger.setThreshold(threshold);
    }

    @Override
    public int getThreshold(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        AbstractLogger logger = (AbstractLogger)this.loggerCache.get(key);
        if (logger == null) {
            return 0;
        }
        return logger.getThreshold();
    }

    @Override
    public Logger getLoggerForComponent(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        Logger logger = this.loggerCache.get(key);
        if (logger != null) {
            return logger;
        }
        logger = this.createLogger(key);
        this.loggerCache.put(key, logger);
        return logger;
    }

    protected abstract Logger createLogger(String var1);

    @Override
    public void returnComponentLogger(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        Logger obj = this.loggerCache.remove(key);
        if (obj == null) {
            System.err.println("There was no such logger '" + key + "' " + this.hashCode() + ".");
        }
    }

    @Override
    public int getActiveLoggerCount() {
        return this.loggerCache.size();
    }

    public String getThresholdAsString() {
        return this.threshold;
    }
}

