/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.tuple;

import org.unidal.tuple.Tuple;

public class Quad<E, S, W, N>
implements Tuple {
    private volatile E m_east;
    private volatile S m_south;
    private volatile W m_west;
    private volatile N m_north;

    public Quad() {
    }

    public Quad(E east, S south, W west, N north) {
        this.m_east = east;
        this.m_south = south;
        this.m_west = west;
        this.m_north = north;
    }

    public static <E, S, W, N> Quad<E, S, W, N> from(E east, S south, W west, N north) {
        return new Quad<E, S, W, N>(east, south, west, north);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quad) {
            Quad o = (Quad)obj;
            if (this.m_east == null ? o.m_east != null : !this.m_east.equals(o.m_east)) {
                return false;
            }
            if (this.m_south == null ? o.m_south != null : !this.m_south.equals(o.m_south)) {
                return false;
            }
            if (this.m_west == null ? o.m_west != null : !this.m_west.equals(o.m_west)) {
                return false;
            }
            return !(this.m_north == null ? o.m_north != null : !this.m_north.equals(o.m_north));
        }
        return false;
    }

    @Override
    public <T> T get(int index) {
        switch (index) {
            case 0: {
                return (T)this.m_east;
            }
            case 1: {
                return (T)this.m_south;
            }
            case 2: {
                return (T)this.m_west;
            }
            case 3: {
                return (T)this.m_north;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Index from 0 to %s, but was %s!", this.size(), index));
    }

    public E getEast() {
        return this.m_east;
    }

    public N getNorth() {
        return this.m_north;
    }

    public S getSouth() {
        return this.m_south;
    }

    public W getWest() {
        return this.m_west;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_east == null ? 0 : this.m_east.hashCode());
        hash = hash * 31 + (this.m_south == null ? 0 : this.m_south.hashCode());
        hash = hash * 31 + (this.m_west == null ? 0 : this.m_west.hashCode());
        hash = hash * 31 + (this.m_north == null ? 0 : this.m_north.hashCode());
        return hash;
    }

    public void setEast(E east) {
        this.m_east = east;
    }

    public void setNorth(N north) {
        this.m_north = north;
    }

    public void setSouth(S south) {
        this.m_south = south;
    }

    public void setWest(W west) {
        this.m_west = west;
    }

    @Override
    public int size() {
        return 4;
    }

    public String toString() {
        return String.format("Quad[east=%s, south=%s, west=%s, north=%s]", this.m_east, this.m_south, this.m_west, this.m_north);
    }
}

