/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.lookup.container.model.BaseEntity;
import org.unidal.lookup.container.model.IVisitor;
import org.unidal.lookup.container.model.entity.Any;
import org.unidal.lookup.container.model.entity.ConfigurationModel;
import org.unidal.lookup.container.model.entity.RequirementModel;

public class ComponentModel
extends BaseEntity<ComponentModel> {
    private String m_role;
    private String m_roleHint;
    private String m_implementation;
    private String m_instantiationStrategy;
    private ConfigurationModel m_configuration;
    private List<RequirementModel> m_requirements = new ArrayList<RequirementModel>();
    private List<Any> m_dynamicElements = new ArrayList<Any>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitComponent(this);
    }

    public ComponentModel addRequirement(RequirementModel requirement) {
        this.m_requirements.add(requirement);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentModel) {
            ComponentModel _o = (ComponentModel)obj;
            if (!this.equals(this.getRole(), _o.getRole())) {
                return false;
            }
            if (!this.equals(this.getRoleHint(), _o.getRoleHint())) {
                return false;
            }
            if (!this.equals(this.getImplementation(), _o.getImplementation())) {
                return false;
            }
            if (!this.equals(this.getInstantiationStrategy(), _o.getInstantiationStrategy())) {
                return false;
            }
            if (!this.equals(this.getConfiguration(), _o.getConfiguration())) {
                return false;
            }
            if (!this.equals(this.getRequirements(), _o.getRequirements())) {
                return false;
            }
            return this.getDynamicElements().equals(_o.getDynamicElements());
        }
        return false;
    }

    public List<Any> getDynamicElements() {
        return this.m_dynamicElements;
    }

    public ConfigurationModel getConfiguration() {
        return this.m_configuration;
    }

    public String getImplementation() {
        return this.m_implementation;
    }

    public String getInstantiationStrategy() {
        return this.m_instantiationStrategy;
    }

    public List<RequirementModel> getRequirements() {
        return this.m_requirements;
    }

    public String getRole() {
        return this.m_role;
    }

    public String getRoleHint() {
        return this.m_roleHint;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_role == null ? 0 : this.m_role.hashCode());
        hash = hash * 31 + (this.m_roleHint == null ? 0 : this.m_roleHint.hashCode());
        hash = hash * 31 + (this.m_implementation == null ? 0 : this.m_implementation.hashCode());
        hash = hash * 31 + (this.m_instantiationStrategy == null ? 0 : this.m_instantiationStrategy.hashCode());
        hash = hash * 31 + (this.m_configuration == null ? 0 : this.m_configuration.hashCode());
        for (RequirementModel e : this.m_requirements) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        return hash;
    }

    @Override
    public void mergeAttributes(ComponentModel other) {
    }

    public void setDynamicElements(List<Any> dynamicElements) {
        this.m_dynamicElements = dynamicElements;
    }

    public ComponentModel setConfiguration(ConfigurationModel configuration) {
        this.m_configuration = configuration;
        return this;
    }

    public ComponentModel setImplementation(String implementation) {
        this.m_implementation = implementation;
        return this;
    }

    public ComponentModel setInstantiationStrategy(String instantiationStrategy) {
        this.m_instantiationStrategy = instantiationStrategy;
        return this;
    }

    public ComponentModel setRole(String role) {
        this.m_role = role;
        return this;
    }

    public ComponentModel setRoleHint(String roleHint) {
        this.m_roleHint = roleHint;
        return this;
    }

    public String getHint() {
        if (this.m_roleHint != null) {
            return this.m_roleHint;
        }
        return "default";
    }

    public boolean isEnum() {
        return "enum".equals(this.m_instantiationStrategy);
    }

    public boolean isPerLookup() {
        return "per-lookup".equals(this.m_instantiationStrategy);
    }

    public boolean isSingleton() {
        return this.m_instantiationStrategy == null || "singleton".equals(this.m_instantiationStrategy);
    }
}

