/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.ComponentLookupException;
import org.unidal.lookup.PlexusContainer;
import org.unidal.lookup.container.ComponentBox;
import org.unidal.lookup.container.ComponentKey;
import org.unidal.lookup.container.ComponentModelManager;
import org.unidal.lookup.container.lifecycle.ComponentLifecycle;
import org.unidal.lookup.container.model.entity.ComponentModel;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.logging.LoggerManager;

public class ComponentManager {
    private Map<String, ComponentBox<?>> m_components = new HashMap();
    private PlexusContainer m_container;
    private ComponentLifecycle m_lifecycle;
    private ComponentModelManager m_modelManager;
    private LoggerManager m_loggerManager;

    public ComponentManager(PlexusContainer container, InputStream in) throws Exception {
        this.m_container = container;
        this.m_modelManager = new ComponentModelManager();
        this.m_lifecycle = new ComponentLifecycle(this);
        if (in != null) {
            this.m_modelManager.loadComponents(in);
        }
        this.m_modelManager.loadComponentsFromClasspath();
        this.m_loggerManager = (LoggerManager)this.lookup(new ComponentKey(LoggerManager.class, null));
        this.register(new ComponentKey(PlexusContainer.class, null), container);
        this.register(new ComponentKey(Logger.class, null), this.m_loggerManager.getLoggerForComponent(""));
    }

    public void addComponentModel(ComponentModel component) {
        this.m_modelManager.addComponent(component);
    }

    public void destroy() {
        for (ComponentBox<?> box : this.m_components.values()) {
            box.destroy();
        }
        this.m_components.clear();
        this.m_modelManager.reset();
    }

    public PlexusContainer getContainer() {
        return this.m_container;
    }

    public LoggerManager getLoggerManager() {
        return this.m_loggerManager;
    }

    public boolean hasComponent(ComponentKey key) {
        return this.m_modelManager.hasComponentModel(key);
    }

    public void log(String pattern, Object ... args) {
        if ("true".equals(this.m_container.getContext().get("verbose"))) {
            Logger logger = this.m_loggerManager.getLoggerForComponent(null);
            logger.info(String.format(pattern, args));
        }
    }

    public <T> T lookup(ComponentKey key) throws ComponentLookupException {
        ComponentModel model;
        String role = key.getRole();
        ComponentBox<Object> box = this.m_components.get(role);
        if (box == null) {
            box = new ComponentBox(this.m_lifecycle);
            this.m_components.put(role, box);
        }
        if ((model = this.m_modelManager.getComponentModel(key)) != null) {
            return (T)box.lookup(model);
        }
        throw new ComponentLookupException("No component defined!", role, key.getRoleHint());
    }

    public <T> List<T> lookupList(String role) throws ComponentLookupException {
        List<String> roleHints = this.m_modelManager.getRoleHints(role);
        ArrayList<T> components = new ArrayList<T>();
        for (String roleHint : roleHints) {
            T component = this.lookup(new ComponentKey(role, roleHint));
            components.add(component);
        }
        return components;
    }

    public <T> Map<String, T> lookupMap(String role) throws ComponentLookupException {
        List<String> roleHints = this.m_modelManager.getRoleHints(role);
        LinkedHashMap<String, T> components = new LinkedHashMap<String, T>();
        for (String roleHint : roleHints) {
            T component = this.lookup(new ComponentKey(role, roleHint));
            components.put(roleHint, component);
        }
        return components;
    }

    public void register(ComponentKey key, Object component) {
        ComponentBox<Object> box = new ComponentBox<Object>(this.m_lifecycle).register(key, component);
        this.m_components.put(key.getRole(), box);
        this.m_modelManager.setComponentModel(key, component.getClass());
    }

    public void release(Object component) {
        this.m_lifecycle.stop(component);
    }
}

