/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.ConverterPriority;
import org.unidal.converter.TypeUtil;

public class ConverterRegistry {
    private Map<Class<?>, ConverterEntry> m_converterMap = new HashMap();
    private Map<Class<?>, Class<?>> m_typeMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Converter<?> findConverter(Type fromType, Type targetType) {
        ConverterEntry entry;
        Converter<?> c;
        boolean isClass = targetType instanceof Class;
        Class<?> fromClass = TypeUtil.getRawType(fromType);
        Class<?> targetClass = TypeUtil.getRawType(targetType);
        if (isClass && targetClass.isPrimitive()) {
            targetType = targetClass = TypeUtil.getWrapClass(targetClass);
        }
        Converter<?> converter = c = (entry = this.m_converterMap.get(targetClass)) == null ? null : entry.getCacheConverter(fromClass);
        if (c != null) {
            return c;
        }
        if (isClass && targetClass.isArray()) {
            c = this.getConverter(fromType, targetType, Array.class);
        } else {
            c = this.getConverter(fromType, targetType, targetClass);
            if (c == null) {
                c = this.getConverter(fromType, targetType, Type.class);
            }
        }
        if (c != null) {
            if (entry == null) {
                Map<Class<?>, ConverterEntry> map = this.m_converterMap;
                synchronized (map) {
                    entry = new ConverterEntry();
                    this.m_converterMap.put(targetClass, entry);
                }
            }
            entry.putCacheConverter(fromClass, c);
            return c;
        }
        throw new ConverterException("No registered converter found to convert from " + fromType + " to " + targetType);
    }

    public Class<?> findType(Class<?> fromClass) {
        Class<?> toClass = this.m_typeMap.get(fromClass);
        if (toClass != null) {
            return toClass;
        }
        return fromClass;
    }

    private Converter<?> getConverter(Type fromType, Type targetType, Class<?> targetClass) {
        Class<?> current = targetClass;
        do {
            ConverterEntry entry;
            if ((entry = this.m_converterMap.get(current)) == null) continue;
            List<Converter<?>> converters = entry.getConverters();
            for (Converter<?> c : converters) {
                if (!c.canConvert(fromType, targetType)) continue;
                return c;
            }
        } while ((current = current.getSuperclass()) != null && current != Object.class);
        return null;
    }

    public void registerConverter(Converter<?> converter) {
        this.registerConverter(converter, ConverterPriority.NORMAL.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConverter(Converter<?> converter, int priority) {
        Type targetType = converter.getTargetType();
        Class<?> targetClass = TypeUtil.getRawType(targetType);
        ConverterEntry entry = this.m_converterMap.get(targetClass);
        if (entry == null) {
            Map<Class<?>, ConverterEntry> map = this.m_converterMap;
            synchronized (map) {
                entry = this.m_converterMap.get(targetClass);
                if (entry == null) {
                    entry = new ConverterEntry();
                    this.m_converterMap.put(targetClass, entry);
                }
            }
        }
        entry.addConverter(converter, priority);
    }

    public void registerType(Class<?> fromClass, Class<?> toClass) {
        Class<?> oldClass = this.m_typeMap.put(fromClass, toClass);
        if (oldClass != null) {
            throw new IllegalStateException("Can't map to same " + fromClass + " from " + oldClass + " and " + toClass);
        }
    }

    private static class ConverterEntry {
        private List<Converter<?>> m_converters = new ArrayList();
        private List<Integer> m_priorities = new ArrayList<Integer>();
        private Map<Class<?>, Converter<?>> m_cacheMap = new HashMap();

        public void addConverter(Converter<?> converter, int priority) {
            if (!this.m_converters.contains(converter)) {
                int size;
                int index = size = this.m_priorities.size();
                for (int i = 0; i < size; ++i) {
                    if (priority <= this.m_priorities.get(i)) continue;
                    index = i;
                    break;
                }
                this.m_priorities.add(index, priority);
                this.m_converters.add(index, converter);
            } else {
                System.out.println("Converter already registered: " + converter);
            }
        }

        public Converter<?> getCacheConverter(Class<?> fromClass) {
            return this.m_cacheMap.get(fromClass);
        }

        public List<Converter<?>> getConverters() {
            return this.m_converters;
        }

        public void putCacheConverter(Class<?> fromClass, Converter<?> converter) {
            this.m_cacheMap.put(fromClass, converter);
        }
    }
}

