/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.mssqlserver;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Triple;
import org.umlg.sqlg.mssqlserver.SQLServerBaseCacheBulkRecord;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.topology.PropertyColumn;

class SQLServerEdgeGlobalUniqueIndexBulkRecord
extends SQLServerBaseCacheBulkRecord
implements ISQLServerBulkRecord {
    private final Iterator<Map.Entry<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> rowIter;
    private Triple<SqlgVertex, SqlgVertex, Map<String, Object>> currentRow;
    private SqlgEdge currentEdge;
    private final PropertyColumn propertyColumn;

    SQLServerEdgeGlobalUniqueIndexBulkRecord(SQLServerBulkCopy bulkCopy, SqlgGraph sqlgGraph, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>> edgeMap, PropertyColumn propertyColumn) throws SQLServerException {
        this.rowIter = edgeMap.entrySet().iterator();
        this.propertyColumn = propertyColumn;
        bulkCopy.addColumnMapping(1, "value");
        this.columnMetadata.put(1, new SQLServerBaseCacheBulkRecord.ColumnMetadata("value", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.STRING)[0], 0, 0, null, PropertyType.STRING));
        bulkCopy.addColumnMapping(2, "recordId");
        this.columnMetadata.put(2, new SQLServerBaseCacheBulkRecord.ColumnMetadata("recordId", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.STRING)[0], 0, 0, null, PropertyType.STRING));
        bulkCopy.addColumnMapping(3, "property");
        this.columnMetadata.put(3, new SQLServerBaseCacheBulkRecord.ColumnMetadata("property", sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.STRING)[0], 0, 0, null, PropertyType.STRING));
    }

    public Object[] getRowData() {
        ArrayList<Object> values = new ArrayList<Object>();
        Object value = ((Map)this.currentRow.getRight()).get(this.propertyColumn.getName());
        if (value == null) {
            value = "dummy_" + UUID.randomUUID().toString();
        }
        values.add(value);
        values.add(this.currentEdge.id().toString());
        values.add(this.propertyColumn.getName());
        return values.toArray();
    }

    @Override
    Object getValue(String column) {
        return ((Map)this.currentRow.getRight()).get(column);
    }

    public boolean next() {
        if (this.rowIter.hasNext()) {
            Map.Entry<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>> entry = this.rowIter.next();
            this.currentRow = entry.getValue();
            this.currentEdge = entry.getKey();
            return true;
        }
        return false;
    }
}

