/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.mssqlserver;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.topology.PropertyColumn;
import org.umlg.sqlg.util.SqlgUtil;

abstract class SQLServerBaseCacheBulkRecord
implements ISQLServerBulkRecord {
    final Map<Integer, ColumnMetadata> columnMetadata = new HashMap<Integer, ColumnMetadata>();
    SortedSet<String> columns;
    Map<String, PropertyColumn> propertyColumns;
    Map<String, PropertyType> properties;

    SQLServerBaseCacheBulkRecord() {
    }

    int addMetaData(SQLServerBulkCopy bulkCopy, SqlgGraph sqlgGraph) throws SQLServerException {
        int i = 1;
        block13: for (String column : this.columns) {
            PropertyType propertyType;
            if (this.propertyColumns != null) {
                PropertyColumn propertyColumn = this.propertyColumns.get(column);
                propertyType = propertyColumn.getPropertyType();
            } else {
                propertyType = this.properties.get(column);
            }
            switch (propertyType.ordinal()) {
                case 0: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
                    continue block13;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
                    continue block13;
                }
                case 42: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
                    continue block13;
                }
                case 8: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
                    continue block13;
                }
                case 9: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
                    continue block13;
                }
                case 10: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 0, 0, null, propertyType));
                    continue block13;
                }
                case 11: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.ZONEDDATETIME)[0], 0, 0, null, PropertyType.LOCALDATETIME));
                    bulkCopy.addColumnMapping(i, column + PropertyType.ZONEDDATETIME.getPostFixes()[0]);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.ZONEDDATETIME)[0], 0, 0, null, PropertyType.STRING));
                    continue block13;
                }
                case 12: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.PERIOD)[0], 0, 0, null, PropertyType.INTEGER));
                    bulkCopy.addColumnMapping(i, column + PropertyType.PERIOD.getPostFixes()[0]);
                    this.columnMetadata.put(i++, new ColumnMetadata(column + PropertyType.PERIOD.getPostFixes()[0], sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.PERIOD)[1], 0, 0, null, PropertyType.INTEGER));
                    bulkCopy.addColumnMapping(i, column + PropertyType.PERIOD.getPostFixes()[1]);
                    this.columnMetadata.put(i++, new ColumnMetadata(column + PropertyType.PERIOD.getPostFixes()[1], sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.PERIOD)[2], 0, 0, null, PropertyType.INTEGER));
                    continue block13;
                }
                case 13: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.DURATION)[0], 0, 0, null, PropertyType.LONG));
                    bulkCopy.addColumnMapping(i, column + PropertyType.DURATION.getPostFixes()[0]);
                    this.columnMetadata.put(i++, new ColumnMetadata(column + PropertyType.DURATION.getPostFixes()[0], sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(PropertyType.DURATION)[1], 0, 0, null, PropertyType.INTEGER));
                    continue block13;
                }
                case 22: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 8000, 0, null, propertyType));
                    continue block13;
                }
                case 23: {
                    bulkCopy.addColumnMapping(i, column);
                    this.columnMetadata.put(i++, new ColumnMetadata(column, sqlgGraph.getSqlDialect().propertyTypeToJavaSqlType(propertyType)[0], 8000, 0, null, propertyType));
                    continue block13;
                }
            }
            throw SqlgExceptions.invalidPropertyType((PropertyType)propertyType);
        }
        return i;
    }

    public Set<Integer> getColumnOrdinals() {
        return this.columnMetadata.keySet();
    }

    public String getColumnName(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).columnName;
    }

    public int getColumnType(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).columnType;
    }

    public int getPrecision(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).precision;
    }

    public int getScale(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).scale;
    }

    public boolean isAutoIncrement(int column) {
        return false;
    }

    abstract Object getValue(String var1);

    void addValues(List<Object> values) {
        block13: for (String column : this.columns) {
            PropertyType propertyType = this.propertyColumns != null ? this.propertyColumns.get(column).getPropertyType() : this.properties.get(column);
            Object value = this.getValue(column);
            switch (propertyType.ordinal()) {
                case 0: {
                    if (value != null) {
                        values.add(value);
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: {
                    if (value != null) {
                        values.add(value);
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 42: {
                    if (value != null) {
                        values.add(value);
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 8: {
                    if (value != null) {
                        values.add(value.toString());
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 9: {
                    if (value != null) {
                        Timestamp timestamp = Timestamp.valueOf((LocalDateTime)value);
                        values.add(timestamp.toString());
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 10: {
                    if (value != null) {
                        values.add(value.toString());
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 11: {
                    if (value != null) {
                        values.add(((ZonedDateTime)value).toLocalDateTime());
                        TimeZone tz = TimeZone.getTimeZone(((ZonedDateTime)value).getZone());
                        values.add(tz.getID());
                        continue block13;
                    }
                    values.add(null);
                    values.add(null);
                    continue block13;
                }
                case 12: {
                    if (value != null) {
                        Period period = (Period)value;
                        values.add(period.getYears());
                        values.add(period.getMonths());
                        values.add(period.getDays());
                        continue block13;
                    }
                    values.add(null);
                    values.add(null);
                    values.add(null);
                    continue block13;
                }
                case 13: {
                    if (value != null) {
                        Duration duration = (Duration)value;
                        values.add(duration.getSeconds());
                        values.add(duration.getNano());
                        continue block13;
                    }
                    values.add(null);
                    values.add(null);
                    continue block13;
                }
                case 22: {
                    if (value != null) {
                        values.add(value);
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
                case 23: {
                    if (value != null) {
                        byte[] byteArray = SqlgUtil.convertObjectArrayToBytePrimitiveArray((Object[])((Object[])value));
                        values.add(byteArray);
                        continue block13;
                    }
                    values.add(null);
                    continue block13;
                }
            }
            throw SqlgExceptions.invalidPropertyType((PropertyType)propertyType);
        }
    }

    class ColumnMetadata {
        final String columnName;
        final int columnType;
        final int precision;
        final int scale;
        final DateTimeFormatter dateTimeFormatter;
        final PropertyType propertyType;

        ColumnMetadata(String name, int type, int precision, int scale, DateTimeFormatter dateTimeFormatter, PropertyType propertyType) {
            this.columnName = name;
            this.columnType = type;
            this.precision = precision;
            this.scale = scale;
            this.dateTimeFormatter = dateTimeFormatter;
            this.propertyType = propertyType;
        }
    }
}

