/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.mssqlserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.umlg.sqlg.mssqlserver.SQLServerEdgeCacheBulkRecord;
import org.umlg.sqlg.mssqlserver.SQLServerEdgeGlobalUniqueIndexBulkRecord;
import org.umlg.sqlg.mssqlserver.SQLServerVertexCacheBulkRecord;
import org.umlg.sqlg.mssqlserver.SQLServerVertexGlobalUniqueIndexBulkRecord;
import org.umlg.sqlg.sql.dialect.BaseSqlDialect;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.strategy.SqlgSqlExecutor;
import org.umlg.sqlg.structure.MetaEdge;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgEdge;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.structure.topology.EdgeLabel;
import org.umlg.sqlg.structure.topology.GlobalUniqueIndex;
import org.umlg.sqlg.structure.topology.PropertyColumn;
import org.umlg.sqlg.structure.topology.Schema;
import org.umlg.sqlg.structure.topology.VertexLabel;
import org.umlg.sqlg.util.SqlgUtil;

public class MSSqlServerDialect
extends BaseSqlDialect {
    MSSqlServerDialect() {
    }

    public boolean requiresIndexName() {
        return true;
    }

    public String dialectName() {
        return "MSSqlServerDialect";
    }

    public Set<String> getInternalSchemas() {
        return ImmutableSet.copyOf(Arrays.asList("db_accessadmin", "db_backupoperator", "db_datareader", "db_ddladmin", "db_debydatareader", "db_denydatawriter", "db_owner", "db_scurityadmin", "dbo", "guest", "INFORMATION_SCHEMA", "sys"));
    }

    public boolean needsSchemaDropCascade() {
        return false;
    }

    public boolean supportsCascade() {
        return false;
    }

    public String addColumnStatement(String schema, String table, String column, String typeDefinition) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.maybeWrapInQoutes(schema));
        sql.append(".");
        sql.append(this.maybeWrapInQoutes(table));
        sql.append(" ADD ");
        sql.append(this.maybeWrapInQoutes(column));
        sql.append(" ");
        sql.append(typeDefinition);
        if (this.needsSemicolon()) {
            sql.append(";");
        }
        return sql.toString();
    }

    public boolean needForeignKeyIndex() {
        return true;
    }

    public PropertyType sqlTypeToPropertyType(SqlgGraph sqlgGraph, String schema, String table, String column, int sqlType, String typeName, ListIterator<Triple<String, Integer, String>> metaDataIter) {
        switch (sqlType) {
            case 16: {
                return PropertyType.BOOLEAN;
            }
            case 5: {
                return PropertyType.SHORT;
            }
            case 4: {
                return PropertyType.INTEGER;
            }
            case -5: {
                return PropertyType.LONG;
            }
            case 7: {
                return PropertyType.FLOAT;
            }
            case 8: {
                return PropertyType.DOUBLE;
            }
            case 12: {
                return PropertyType.STRING;
            }
            case 93: {
                return PropertyType.LOCALDATETIME;
            }
            case 91: {
                return PropertyType.LOCALDATE;
            }
            case 92: {
                return PropertyType.LOCALTIME;
            }
            case -3: {
                return PropertyType.byte_ARRAY;
            }
            case 2003: {
                return PropertyType.JSON_ARRAY;
            }
        }
        throw new IllegalStateException("Unknown sqlType " + sqlType);
    }

    public PropertyType sqlArrayTypeNameToPropertyType(String typeName, SqlgGraph sqlgGraph, String schema, String table, String columnName, ListIterator<Triple<String, Integer, String>> metaDataIter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void validateProperty(Object key, Object value) {
        if (value instanceof String) {
            return;
        }
        if (value instanceof Character) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof Byte || value instanceof Byte[] || value instanceof byte[]) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof LocalDate) {
            return;
        }
        if (value instanceof LocalDateTime) {
            return;
        }
        if (value instanceof ZonedDateTime) {
            return;
        }
        if (value instanceof LocalTime) {
            return;
        }
        if (value instanceof Period) {
            return;
        }
        if (value instanceof Duration) {
            return;
        }
        if (value instanceof JsonNode) {
            return;
        }
        throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)value);
    }

    public String getColumnEscapeKey() {
        return "\"";
    }

    public String getPrimaryKeyType() {
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    public String getAutoIncrementPrimaryKeyConstruct() {
        return "BIGINT IDENTITY NOT NULL PRIMARY KEY";
    }

    public String[] propertyTypeToSqlDefinition(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return new String[]{"BIT"};
            }
            case 1: {
                return new String[]{"TINYINT"};
            }
            case 22: {
                return new String[]{"VARBINARY(max)"};
            }
            case 23: {
                return new String[]{"VARBINARY(max)"};
            }
            case 6: {
                return new String[]{"DOUBLE PRECISION"};
            }
            case 13: {
                return new String[]{"BIGINT", "INT"};
            }
            case 5: {
                return new String[]{"REAL"};
            }
            case 3: {
                return new String[]{"INT"};
            }
            case 8: {
                return new String[]{"DATE"};
            }
            case 9: {
                return new String[]{"DATETIME2(3)"};
            }
            case 10: {
                return new String[]{"TIME"};
            }
            case 4: {
                return new String[]{"BIGINT"};
            }
            case 12: {
                return new String[]{"INT", "INT", "INT"};
            }
            case 2: {
                return new String[]{"SMALLINT"};
            }
            case 7: {
                return new String[]{"VARCHAR(2000)"};
            }
            case 42: {
                return new String[]{"VARCHAR(" + propertyType.getLength() + ")"};
            }
            case 11: {
                return new String[]{"DATETIME2(3)", "VARCHAR(255)"};
            }
            case 34: {
                return new String[]{"ARRAY"};
            }
            case 39: {
                return new String[]{"ARRAY", "ARRAY"};
            }
            case 40: {
                return new String[]{"ARRAY", "ARRAY", "ARRAY"};
            }
            case 14: {
                return new String[]{"VARCHAR(max)"};
            }
        }
        throw SqlgExceptions.invalidPropertyType((PropertyType)propertyType);
    }

    public int[] propertyTypeToJavaSqlType(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return new int[]{-7};
            }
            case 1: {
                return new int[]{-6};
            }
            case 2: {
                return new int[]{5};
            }
            case 3: {
                return new int[]{4};
            }
            case 4: {
                return new int[]{-5};
            }
            case 5: {
                return new int[]{7};
            }
            case 6: {
                return new int[]{8};
            }
            case 7: {
                return new int[]{-1};
            }
            case 42: {
                return new int[]{12};
            }
            case 9: {
                return new int[]{93};
            }
            case 8: {
                return new int[]{91};
            }
            case 10: {
                return new int[]{92};
            }
            case 11: {
                return new int[]{93, 2005};
            }
            case 13: {
                return new int[]{-5, 4};
            }
            case 12: {
                return new int[]{4, 4, 4};
            }
            case 14: {
                return new int[]{12};
            }
            case 22: {
                return new int[]{-3};
            }
            case 23: {
                return new int[]{-3};
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return new int[]{2003};
            }
            case 38: {
                return new int[]{2003, 2003};
            }
            case 39: {
                return new int[]{2003, 2003};
            }
            case 40: {
                return new int[]{2003, 2003, 2003};
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public String getForeignKeyTypeDefinition() {
        return "BIGINT";
    }

    public String getArrayDriverType(PropertyType arrayType) {
        return "ARRAY";
    }

    public void putJsonObject(ObjectNode obj, String columnName, int sqlType, Object o) {
        switch (sqlType) {
            case 2003: {
                try {
                    ArrayNode arrayNode = obj.putArray(columnName);
                    java.sql.Array sqlA = (java.sql.Array)o;
                    Object a = sqlA.getArray();
                    int len = Array.getLength(a);
                    if (len <= 0) break;
                    PropertyType pt = PropertyType.from((Object)Array.get(a, 0));
                    block15: for (int i = 0; i < len; ++i) {
                        Object v = Array.get(a, i);
                        switch (pt.ordinal()) {
                            case 0: {
                                arrayNode.add((Boolean)v);
                                continue block15;
                            }
                            case 1: {
                                arrayNode.add((int)((Byte)v).byteValue());
                                continue block15;
                            }
                            case 6: {
                                arrayNode.add((Double)v);
                                continue block15;
                            }
                            case 5: {
                                arrayNode.add((Float)v);
                                continue block15;
                            }
                            case 3: {
                                arrayNode.add((Integer)v);
                                continue block15;
                            }
                            case 4: {
                                arrayNode.add((Long)v);
                                continue block15;
                            }
                            case 2: {
                                arrayNode.add((int)((Short)v).shortValue());
                                continue block15;
                            }
                            case 7: {
                                arrayNode.add((String)v);
                            }
                        }
                    }
                    break;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                super.putJsonObject(obj, columnName, sqlType, o);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putJsonMetaObject(ObjectMapper mapper, ArrayNode metaNodeArray, String columnName, int sqlType, Object o) {
        switch (sqlType) {
            case 2003: {
                try {
                    ObjectNode metaNode = mapper.createObjectNode();
                    metaNode.put("name", columnName);
                    metaNodeArray.add((JsonNode)metaNode);
                    java.sql.Array sqlA = (java.sql.Array)o;
                    Object a = sqlA.getArray();
                    if (Array.getLength(a) <= 0) return;
                    PropertyType pt = PropertyType.from((Object)Array.get(a, 0));
                    switch (pt.ordinal()) {
                        case 0: {
                            metaNode.put("type", PropertyType.boolean_ARRAY.name());
                            return;
                        }
                        case 2: {
                            metaNode.put("type", PropertyType.short_ARRAY.name());
                            return;
                        }
                        case 3: {
                            metaNode.put("type", PropertyType.int_ARRAY.name());
                            return;
                        }
                        case 4: {
                            metaNode.put("type", PropertyType.long_ARRAY.name());
                            return;
                        }
                        case 5: {
                            metaNode.put("type", PropertyType.float_ARRAY.name());
                            return;
                        }
                        case 6: {
                            metaNode.put("type", PropertyType.double_ARRAY.name());
                            return;
                        }
                        case 7: {
                            metaNode.put("type", PropertyType.STRING_ARRAY.name());
                            return;
                        }
                    }
                    throw new IllegalStateException("Unknown array sqlType " + sqlType);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                super.putJsonMetaObject(mapper, metaNodeArray, columnName, sqlType, o);
            }
        }
    }

    public String existIndexQuery(SchemaTable schemaTable, String prefix, String indexName) {
        return "SELECT * FROM sys.indexes i JOIN sys.tables t ON i.object_id = t.object_id JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE s.name = '" + schemaTable.getSchema() + "' AND t.name = '" + prefix + schemaTable.getTable() + "' AND i.name = '" + indexName + "'";
    }

    public Set<String> getSpacialRefTable() {
        return Collections.emptySet();
    }

    public List<String> getGisSchemas() {
        return Collections.emptyList();
    }

    public void setPoint(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        throw new IllegalStateException("H2 does not support gis types, this should not have happened!");
    }

    public void setLineString(PreparedStatement preparedStatement, int parameterStartIndex, Object lineString) {
        throw new IllegalStateException("H2 does not support gis types, this should not have happened!");
    }

    public void setPolygon(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        throw new IllegalStateException("H2 does not support gis types, this should not have happened!");
    }

    public void setGeographyPoint(PreparedStatement preparedStatement, int parameterStartIndex, Object point) {
        throw new IllegalStateException("H2 does not support gis types, this should not have happened!");
    }

    public <T> T getGis(SqlgGraph sqlgGraph) {
        throw new IllegalStateException("H2 does not support gis types, this should not have happened!");
    }

    public void lockTable(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("H2 does not support table locking!");
    }

    public void alterSequenceCacheSize(SqlgGraph sqlgGraph, SchemaTable schemaTable, String sequence, int batchSize) {
        throw new UnsupportedOperationException("Hsqldb does not support alterSequenceCacheSize!");
    }

    public long nextSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("H2 does not support batch mode!");
    }

    public long currSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        throw new UnsupportedOperationException("H2 does not support batch mode!");
    }

    public String sequenceName(SqlgGraph sqlgGraph, SchemaTable outSchemaTable, String prefix) {
        throw new UnsupportedOperationException("H2 does not support sequenceName!");
    }

    public boolean supportsBulkWithinOut() {
        return true;
    }

    public boolean supportsTransactionalSchema() {
        return true;
    }

    public String createTemporaryTableStatement() {
        return "CREATE TABLE ";
    }

    public String afterCreateTemporaryTableStatement() {
        return "";
    }

    public List<String> sqlgTopologyCreationScripts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("CREATE TABLE \"sqlg_schema\".\"V_graph\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"updatedOn\" DATETIME, \"version\" VARCHAR(255), \"dbVersion\" VARCHAR(255));");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_schema\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255));");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_vertex\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255), \"schemaVertex\" VARCHAR(255), \"partitionType\" VARCHAR(255), \"partitionExpression\" VARCHAR(255), \"shardCount\" INTEGER);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_edge\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255), \"partitionType\" VARCHAR(255), \"partitionExpression\" VARCHAR(255), \"shardCount\" INTEGER);");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_partition\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255), \"from\" VARCHAR(255), \"to\" VARCHAR(255), \"in\" VARCHAR(255), \"partitionType\" VARCHAR(255), \"partitionExpression\" VARCHAR(255));");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_property\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255), \"type\" VARCHAR(255));");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_index\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255), \"index_type\" VARCHAR(255));");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_globalUniqueIndex\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_schema_vertex\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.schema__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.schema__O\") REFERENCES \"sqlg_schema\".\"V_schema\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_in_edges\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_out_edges\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_property\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_property\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_identifier\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, \"identifier_index\" INTEGER, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_identifier\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, \"identifier_index\" INTEGER, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_partition\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.partition__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.partition__I\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_partition\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.partition__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.partition__I\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_partition_partition\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.partition__I\" BIGINT, \"sqlg_schema.partition__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.partition__I\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.partition__O\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_distribution\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_colocate\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_distribution\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_colocate\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_vertex_index\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.index__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.index__I\") REFERENCES \"sqlg_schema\".\"V_index\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_edge_index\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.index__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.index__I\") REFERENCES \"sqlg_schema\".\"V_index\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_index_property\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.index__O\" BIGINT, \"sequence\" INTEGER, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.index__O\") REFERENCES \"sqlg_schema\".\"V_index\" (\"ID\"));");
        result.add("CREATE TABLE \"sqlg_schema\".\"V_log\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"timestamp\" TIMESTAMP, \"pid\" INTEGER, \"log\" VARCHAR);");
        result.add("CREATE TABLE \"sqlg_schema\".\"E_globalUniqueIndex_property\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.globalUniqueIndex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.globalUniqueIndex__O\") REFERENCES \"sqlg_schema\".\"V_globalUniqueIndex\" (\"ID\"));");
        return result;
    }

    public String sqlgCreateTopologyGraph() {
        return "CREATE TABLE \"sqlg_schema\".\"V_graph\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"updatedOn\" DATETIME, \"version\" VARCHAR(255), \"dbVersion\" VARCHAR(255));";
    }

    public String sqlgAddIndexEdgeSequenceColumn() {
        return "ALTER TABLE \"sqlg_schema\".\"E_index_property\" ADD \"sequence\" INTEGER DEFAULT 0;";
    }

    public Object convertArray(PropertyType propertyType, java.sql.Array array) throws SQLException {
        switch (propertyType.ordinal()) {
            case 21: {
                return SqlgUtil.convertObjectArrayToBooleanArray((Object[])((Object[])array.getArray()));
            }
            case 20: {
                return SqlgUtil.convertObjectArrayToBooleanPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 25: {
                return SqlgUtil.convertObjectOfShortsArrayToShortArray((Object[])((Object[])array.getArray()));
            }
            case 24: {
                return SqlgUtil.convertObjectOfShortsArrayToShortPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 27: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerArray((Object[])((Object[])array.getArray()));
            }
            case 26: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 29: {
                return SqlgUtil.convertObjectOfLongsArrayToLongArray((Object[])((Object[])array.getArray()));
            }
            case 28: {
                return SqlgUtil.convertObjectOfLongsArrayToLongPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 33: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoubleArray((Object[])((Object[])array.getArray()));
            }
            case 32: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoublePrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 31: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatArray((Object[])((Object[])array.getArray()));
            }
            case 30: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 34: {
                return SqlgUtil.convertObjectOfStringsArrayToStringArray((Object[])((Object[])array.getArray()));
            }
            case 35: {
                Object[] timestamps = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfTimestampToLocalDateTime((Object[])timestamps, (Object)new LocalDateTime[timestamps.length]);
            }
            case 36: {
                Object[] dates = (Object[])array.getArray();
                if (dates.length > 0 && dates[0] instanceof Timestamp) {
                    return SqlgUtil.copyObjectArrayOfTimestampToLocalDate((Object[])dates, (Object)new LocalDate[dates.length]);
                }
                return SqlgUtil.copyObjectArrayOfDateToLocalDate((Object[])dates, (Object)new LocalDate[dates.length]);
            }
            case 37: {
                Object[] times = (Object[])array.getArray();
                return SqlgUtil.copyObjectArrayOfTimeToLocalTime((Object[])times, (Object)new LocalTime[times.length]);
            }
        }
        throw new IllegalStateException("Unhandled property type " + propertyType.name());
    }

    public void setArray(PreparedStatement statement, int index, PropertyType type, Object[] values) throws SQLException {
        statement.setObject(index, values);
    }

    public String getPublicSchema() {
        return "graph";
    }

    public String getRangeClause(Range<Long> r) {
        return "OFFSET " + r.getMinimum() + " ROWS FETCH NEXT " + ((Long)r.getMaximum() - (Long)r.getMinimum()) + " ROWS ONLY";
    }

    public String getSkipClause(long skip) {
        return " OFFSET " + skip + " ROWS";
    }

    public boolean isSystemIndex(String indexName) {
        return indexName.startsWith("PK_") || indexName.startsWith("FK_") || indexName.endsWith("_idx");
    }

    public boolean supportsType(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 23: {
                return true;
            }
            case 22: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 14: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public boolean supportsBooleanArrayValues() {
        return false;
    }

    public boolean supportsDoubleArrayValues() {
        return false;
    }

    public boolean supportsFloatArrayValues() {
        return false;
    }

    public boolean supportsIntegerArrayValues() {
        return false;
    }

    public boolean supportsShortArrayValues() {
        return false;
    }

    public boolean supportsLongArrayValues() {
        return false;
    }

    public boolean supportsStringArrayValues() {
        return false;
    }

    public boolean supportsFloatValues() {
        return false;
    }

    public boolean supportsByteValues() {
        return false;
    }

    public boolean supportsLocalDateTimeArrayValues() {
        return false;
    }

    public boolean supportsLocalTimeArrayValues() {
        return false;
    }

    public boolean supportsLocalDateArrayValues() {
        return false;
    }

    public boolean supportsZonedDateTimeArrayValues() {
        return false;
    }

    public boolean supportsPeriodArrayValues() {
        return false;
    }

    public boolean supportsDurationArrayValues() {
        return false;
    }

    public boolean needsTemporaryTablePrefix() {
        return true;
    }

    public String temporaryTablePrefix() {
        return "#";
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public void flushVertexCache(SqlgGraph sqlgGraph, Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> vertexCache) {
        Connection connection = sqlgGraph.tx().getConnection();
        for (Map.Entry<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> entry : vertexCache.entrySet()) {
            Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertices;
            SchemaTable schemaTable = entry.getKey();
            VertexLabel vertexLabel = null;
            if (!schemaTable.isTemporary()) {
                vertexLabel = (VertexLabel)sqlgGraph.getTopology().getVertexLabel(schemaTable.getSchema(), schemaTable.getTable()).orElseThrow(() -> new IllegalStateException(String.format("VertexLabel %s not found.", schemaTable.toString())));
            }
            if (((SortedSet)(vertices = entry.getValue()).getLeft()).isEmpty()) {
                HashMap<String, PropertyType> columns = new HashMap<String, PropertyType>();
                columns.put("dummy", PropertyType.from((Object)0));
                sqlgGraph.getTopology().ensureVertexLabelPropertiesExist(schemaTable.getSchema(), schemaTable.getTable(), columns);
            }
            try {
                SQLServerConnection sqlServerConnection = connection.unwrap(SQLServerConnection.class);
                try (SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((Connection)sqlServerConnection);){
                    SQLServerBulkCopyOptions options = new SQLServerBulkCopyOptions();
                    options.setTableLock(true);
                    bulkCopy.setBulkCopyOptions(options);
                    if (schemaTable.isTemporary()) {
                        bulkCopy.setDestinationTableName(sqlgGraph.getSqlDialect().maybeWrapInQoutes(sqlgGraph.getSqlDialect().temporaryTablePrefix() + "V_" + schemaTable.getTable()));
                    } else {
                        bulkCopy.setDestinationTableName(sqlgGraph.getSqlDialect().maybeWrapInQoutes(schemaTable.getSchema()) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("V_" + schemaTable.getTable()));
                    }
                    bulkCopy.writeToServer((ISQLServerBulkRecord)new SQLServerVertexCacheBulkRecord(bulkCopy, sqlgGraph, schemaTable, vertices));
                }
                if (vertexLabel != null && vertexLabel.hasIDPrimaryKey()) {
                    long endHigh;
                    int numberInserted = ((Map)vertices.getRight()).size();
                    if (schemaTable.isTemporary() || numberInserted <= 0) continue;
                    try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT IDENT_CURRENT('" + schemaTable.getSchema() + "." + "V_" + schemaTable.getTable() + "')");){
                        ResultSet resultSet = preparedStatement.executeQuery();
                        resultSet.next();
                        endHigh = resultSet.getLong(1);
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    long id = endHigh - (long)numberInserted + 1L;
                    for (SqlgVertex sqlgVertex : ((Map)vertices.getRight()).keySet()) {
                        sqlgVertex.setInternalPrimaryKey(RecordId.from((SchemaTable)schemaTable, (Long)id++));
                    }
                    continue;
                }
                if (vertexLabel == null) continue;
                for (Map.Entry sqlgVertexMapEntry : ((Map)vertices.getRight()).entrySet()) {
                    SqlgVertex sqlgVertex = (SqlgVertex)sqlgVertexMapEntry.getKey();
                    Map values = (Map)sqlgVertexMapEntry.getValue();
                    ArrayList<Comparable> identifiers = new ArrayList<Comparable>();
                    for (String identifier : vertexLabel.getIdentifiers()) {
                        identifiers.add((Comparable)values.get(identifier));
                    }
                    sqlgVertex.setInternalPrimaryKey(RecordId.from((SchemaTable)schemaTable, identifiers));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flushEdgeCache(SqlgGraph sqlgGraph, Map<MetaEdge, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>> edgeCache) {
        Connection connection = sqlgGraph.tx().getConnection();
        try {
            for (MetaEdge metaEdge : edgeCache.keySet()) {
                SchemaTable schemaTable = metaEdge.getSchemaTable();
                EdgeLabel edgeLabel = (EdgeLabel)sqlgGraph.getTopology().getEdgeLabel(schemaTable.getSchema(), schemaTable.getTable()).orElseThrow(() -> new IllegalStateException(String.format("EdgeLabel not found for %s.%s", schemaTable.getSchema(), schemaTable.getTable())));
                Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> triples = edgeCache.get(metaEdge);
                try {
                    SQLServerConnection sqlServerConnection = connection.unwrap(SQLServerConnection.class);
                    try (SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((Connection)sqlServerConnection);){
                        SQLServerBulkCopyOptions options = new SQLServerBulkCopyOptions();
                        options.setTableLock(true);
                        bulkCopy.setBulkCopyOptions(options);
                        bulkCopy.setDestinationTableName(sqlgGraph.getSqlDialect().maybeWrapInQoutes(schemaTable.getSchema()) + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("E_" + schemaTable.getTable()));
                        bulkCopy.writeToServer((ISQLServerBulkRecord)new SQLServerEdgeCacheBulkRecord(bulkCopy, sqlgGraph, metaEdge, schemaTable, triples));
                    }
                    if (edgeLabel.hasIDPrimaryKey()) {
                        long endHigh;
                        int numberInserted = ((Map)triples.getRight()).size();
                        if (schemaTable.isTemporary() || numberInserted <= 0) continue;
                        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT IDENT_CURRENT('" + schemaTable.getSchema() + "." + "E_" + schemaTable.getTable() + "')");){
                            ResultSet resultSet = preparedStatement.executeQuery();
                            resultSet.next();
                            endHigh = resultSet.getLong(1);
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                        long id = endHigh - (long)numberInserted + 1L;
                        for (SqlgEdge sqlgEdge : ((Map)triples.getRight()).keySet()) {
                            sqlgEdge.setInternalPrimaryKey(RecordId.from((SchemaTable)schemaTable, (Long)id++));
                        }
                        continue;
                    }
                    for (Map.Entry sqlgEdgeTripleEntry : ((Map)triples.getRight()).entrySet()) {
                        SqlgEdge sqlgEdge = (SqlgEdge)sqlgEdgeTripleEntry.getKey();
                        Map values = (Map)((Triple)sqlgEdgeTripleEntry.getValue()).getRight();
                        ArrayList<Comparable> identifiers = new ArrayList<Comparable>();
                        for (String identifier : edgeLabel.getIdentifiers()) {
                            identifiers.add((Comparable)values.get(identifier));
                        }
                        sqlgEdge.setInternalPrimaryKey(RecordId.from((SchemaTable)schemaTable, identifiers));
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flushVertexGlobalUniqueIndexes(SqlgGraph sqlgGraph, Map<SchemaTable, Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>>> vertexCache) {
        for (SchemaTable schemaTable : vertexCache.keySet()) {
            Pair<SortedSet<String>, Map<SqlgVertex, Map<String, Object>>> vertices = vertexCache.get(schemaTable);
            Map propertyColumnMap = sqlgGraph.getTopology().getPropertiesFor(schemaTable.withPrefix("V_"));
            for (Map.Entry propertyColumnEntry : propertyColumnMap.entrySet()) {
                PropertyColumn propertyColumn = (PropertyColumn)propertyColumnEntry.getValue();
                for (GlobalUniqueIndex globalUniqueIndex : propertyColumn.getGlobalUniqueIndices()) {
                    try {
                        Connection connection = sqlgGraph.tx().getConnection();
                        SQLServerConnection sqlServerConnection = connection.unwrap(SQLServerConnection.class);
                        try (SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((Connection)sqlServerConnection);){
                            bulkCopy.setDestinationTableName(sqlgGraph.getSqlDialect().maybeWrapInQoutes("gui_schema") + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("V_" + globalUniqueIndex.getName()));
                            bulkCopy.writeToServer((ISQLServerBulkRecord)new SQLServerVertexGlobalUniqueIndexBulkRecord(bulkCopy, sqlgGraph, vertices, propertyColumn));
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public void flushEdgeGlobalUniqueIndexes(SqlgGraph sqlgGraph, Map<MetaEdge, Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>>> edgeCache) {
        for (MetaEdge metaEdge : edgeCache.keySet()) {
            Pair<SortedSet<String>, Map<SqlgEdge, Triple<SqlgVertex, SqlgVertex, Map<String, Object>>>> triples = edgeCache.get(metaEdge);
            Map edgeMap = (Map)triples.getRight();
            Map propertyColumnMap = sqlgGraph.getTopology().getPropertiesFor(metaEdge.getSchemaTable().withPrefix("E_"));
            for (Map.Entry propertyColumnEntry : propertyColumnMap.entrySet()) {
                PropertyColumn propertyColumn = (PropertyColumn)propertyColumnEntry.getValue();
                for (GlobalUniqueIndex globalUniqueIndex : propertyColumn.getGlobalUniqueIndices()) {
                    try {
                        Connection connection = sqlgGraph.tx().getConnection();
                        SQLServerConnection sqlServerConnection = connection.unwrap(SQLServerConnection.class);
                        try (SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((Connection)sqlServerConnection);){
                            bulkCopy.setDestinationTableName(sqlgGraph.getSqlDialect().maybeWrapInQoutes("gui_schema") + "." + sqlgGraph.getSqlDialect().maybeWrapInQoutes("V_" + globalUniqueIndex.getName()));
                            bulkCopy.writeToServer((ISQLServerBulkRecord)new SQLServerEdgeGlobalUniqueIndexBulkRecord(bulkCopy, sqlgGraph, edgeMap, propertyColumn));
                        }
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public boolean supportsSchemaIfNotExists() {
        return false;
    }

    public boolean isMssqlServer() {
        return true;
    }

    public boolean uniqueIndexConsidersNullValuesEqual() {
        return true;
    }

    public String dropSchemaStatement(String schema) {
        return "DROP SCHEMA " + this.maybeWrapInQoutes(schema) + (this.needsSemicolon() ? ";" : "");
    }

    public String valueToValuesString(PropertyType propertyType, Object value) {
        Preconditions.checkState((boolean)this.supportsType(propertyType), (String)"PropertyType %s is not supported", (Object)propertyType.name());
        switch (propertyType.ordinal()) {
            case 7: {
                return "'" + this.escapeQuotes(value) + "'";
            }
            case 1: {
                return value.toString();
            }
            case 22: {
                return "0x" + DatatypeConverter.printHexBinary((byte[])((byte[])value));
            }
            case 23: {
                byte[] bytes = SqlgUtil.convertObjectArrayToBytePrimitiveArray((Object[])((Byte[])value));
                return "0x" + DatatypeConverter.printHexBinary((byte[])bytes);
            }
            case 0: {
                Boolean b = (Boolean)value;
                if (b.booleanValue()) {
                    return Integer.valueOf(1).toString();
                }
                return Integer.valueOf(0).toString();
            }
            case 2: {
                return value.toString();
            }
            case 3: {
                return value.toString();
            }
            case 4: {
                return value.toString();
            }
            case 6: {
                return value.toString();
            }
            case 8: {
                return "'" + value.toString() + "'";
            }
            case 9: {
                return "'" + Timestamp.valueOf((LocalDateTime)value).toString() + "'";
            }
            case 10: {
                return "'" + Time.valueOf((LocalTime)value).toString() + "'";
            }
            case 14: {
                return "'" + value.toString() + "'";
            }
        }
        throw SqlgExceptions.invalidPropertyType((PropertyType)propertyType);
    }

    public String sqlToTurnOffReferentialConstraintCheck(String tableName) {
        return "ALTER TABLE " + tableName + " NOCHECK CONSTRAINT ALL";
    }

    public String sqlToTurnOnReferentialConstraintCheck(String tableName) {
        return "ALTER TABLE " + tableName + " CHECK CONSTRAINT ALL";
    }

    public List<Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>> drop(SqlgGraph sqlgGraph, String leafElementsToDelete, @Nullable String edgesToDelete, LinkedList<SchemaTableTree> distinctQueryStack) {
        Object sb;
        ArrayList<Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>> sqls = new ArrayList<Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>>();
        SchemaTableTree last = distinctQueryStack.getLast();
        SchemaTableTree lastEdge = null;
        boolean isVertex = last.getSchemaTable().isVertexTable();
        VertexLabel lastVertexLabel = null;
        if (isVertex) {
            Optional schemaOptional = sqlgGraph.getTopology().getSchema(last.getSchemaTable().getSchema());
            Preconditions.checkState((boolean)schemaOptional.isPresent(), (String)"BUG: %s not found in the topology.", (Object)last.getSchemaTable().getSchema());
            Schema schema = (Schema)schemaOptional.get();
            Optional vertexLabelOptional = schema.getVertexLabel(last.getSchemaTable().withOutPrefix().getTable());
            Preconditions.checkState((boolean)vertexLabelOptional.isPresent(), (String)"BUG: %s not found in the topology.", (Object)last.getSchemaTable().withOutPrefix().getTable());
            lastVertexLabel = (VertexLabel)vertexLabelOptional.get();
        }
        boolean queryTraversesEdge = isVertex && distinctQueryStack.size() > 1;
        EdgeLabel lastEdgeLabel = null;
        if (queryTraversesEdge) {
            lastEdge = distinctQueryStack.get(distinctQueryStack.size() - 2);
            Optional edgeSchema = sqlgGraph.getTopology().getSchema(lastEdge.getSchemaTable().getSchema());
            Preconditions.checkState((boolean)edgeSchema.isPresent(), (String)"BUG: %s not found in the topology.", (Object)lastEdge.getSchemaTable().getSchema());
            Optional edgeLabelOptional = ((Schema)edgeSchema.get()).getEdgeLabel(lastEdge.getSchemaTable().withOutPrefix().getTable());
            Preconditions.checkState((boolean)edgeLabelOptional.isPresent(), (String)"BUG: %s not found in the topology.", (Object)lastEdge.getSchemaTable().getTable());
            lastEdgeLabel = (EdgeLabel)edgeLabelOptional.get();
        }
        if (isVertex) {
            int count;
            EdgeLabel edgeLabel;
            for (Map.Entry edgeLabelEntry : lastVertexLabel.getOutEdgeLabels().entrySet()) {
                edgeLabel = (EdgeLabel)edgeLabelEntry.getValue();
                if (edgeLabel.equals(lastEdgeLabel)) continue;
                sb = new StringBuilder();
                ((StringBuilder)sb).append("DELETE FROM ");
                ((StringBuilder)sb).append(this.maybeWrapInQoutes(edgeLabel.getSchema().getName()));
                ((StringBuilder)sb).append(".");
                ((StringBuilder)sb).append(this.maybeWrapInQoutes("E_" + edgeLabel.getName()));
                ((StringBuilder)sb).append("\nFROM (");
                ((StringBuilder)sb).append(leafElementsToDelete);
                ((StringBuilder)sb).append("\n) x\n");
                ((StringBuilder)sb).append("WHERE ");
                if (last.isHasIDPrimaryKey()) {
                    ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastVertexLabel.getSchema().getName() + "." + lastVertexLabel.getName() + "__O"));
                    ((StringBuilder)sb).append(" = x.").append(last.lastMappedAliasIdentifier("ID"));
                } else {
                    count = 1;
                    for (String identifier : last.getIdentifiers()) {
                        ((StringBuilder)sb).append(this.maybeWrapInQoutes(edgeLabel.getSchema().getName()));
                        ((StringBuilder)sb).append(".");
                        ((StringBuilder)sb).append(this.maybeWrapInQoutes("E_" + edgeLabel.getName()));
                        ((StringBuilder)sb).append(".").append(this.maybeWrapInQoutes(lastVertexLabel.getSchema().getName() + "." + lastVertexLabel.getName() + "." + identifier + "__O"));
                        ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(last.lastMappedAliasIdentifier(identifier)));
                        if (count++ >= edgeLabel.getIdentifiers().size()) continue;
                        ((StringBuilder)sb).append(" AND ");
                    }
                }
                sqls.add((Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>)Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.NORMAL, (Object)((StringBuilder)sb).toString(), (Object)false));
            }
            for (Map.Entry edgeLabelEntry : lastVertexLabel.getInEdgeLabels().entrySet()) {
                edgeLabel = (EdgeLabel)edgeLabelEntry.getValue();
                if (edgeLabel.equals(lastEdgeLabel)) continue;
                sb = new StringBuilder();
                ((StringBuilder)sb).append("DELETE FROM ");
                ((StringBuilder)sb).append(this.maybeWrapInQoutes(edgeLabel.getSchema().getName()));
                ((StringBuilder)sb).append(".");
                ((StringBuilder)sb).append(this.maybeWrapInQoutes("E_" + edgeLabel.getName()));
                ((StringBuilder)sb).append("\nFROM (");
                ((StringBuilder)sb).append(leafElementsToDelete);
                ((StringBuilder)sb).append("\n) x\n");
                ((StringBuilder)sb).append("WHERE ");
                if (last.isHasIDPrimaryKey()) {
                    ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastVertexLabel.getSchema().getName() + "." + lastVertexLabel.getName() + "__I"));
                    ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(last.lastMappedAliasIdentifier("ID")));
                } else {
                    count = 1;
                    for (String identifier : last.getIdentifiers()) {
                        ((StringBuilder)sb).append(this.maybeWrapInQoutes(edgeLabel.getSchema().getName()));
                        ((StringBuilder)sb).append(".");
                        ((StringBuilder)sb).append(this.maybeWrapInQoutes("E_" + edgeLabel.getName()));
                        ((StringBuilder)sb).append(".").append(this.maybeWrapInQoutes(identifier));
                        ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(last.lastMappedAliasIdentifier(identifier)));
                        if (count++ >= edgeLabel.getIdentifiers().size()) continue;
                        ((StringBuilder)sb).append(" AND ");
                    }
                }
                sqls.add((Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>)Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.NORMAL, (Object)((StringBuilder)sb).toString(), (Object)false));
            }
        }
        if (queryTraversesEdge) {
            String edgeTableName;
            for (EdgeLabel edgeLabel : lastVertexLabel.getOutEdgeLabels().values()) {
                edgeTableName = this.maybeWrapInQoutes(edgeLabel.getSchema().getName()) + "." + this.maybeWrapInQoutes("E_" + edgeLabel.getLabel());
                sqls.add(Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.ALTER, (Object)this.sqlToTurnOffReferentialConstraintCheck(edgeTableName), (Object)false));
            }
            for (EdgeLabel edgeLabel : lastVertexLabel.getInEdgeLabels().values()) {
                edgeTableName = this.maybeWrapInQoutes(edgeLabel.getSchema().getName()) + "." + this.maybeWrapInQoutes("E_" + edgeLabel.getLabel());
                sqls.add(Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.ALTER, (Object)this.sqlToTurnOffReferentialConstraintCheck(edgeTableName), (Object)false));
            }
        }
        sb = new StringBuilder();
        ((StringBuilder)sb).append("DELETE FROM ");
        ((StringBuilder)sb).append(this.maybeWrapInQoutes(last.getSchemaTable().getSchema()));
        ((StringBuilder)sb).append(".");
        ((StringBuilder)sb).append(this.maybeWrapInQoutes(last.getSchemaTable().getTable()));
        ((StringBuilder)sb).append("\nFROM (");
        ((StringBuilder)sb).append(leafElementsToDelete);
        ((StringBuilder)sb).append("\n) x\n");
        ((StringBuilder)sb).append("WHERE ");
        if (last.isHasIDPrimaryKey()) {
            ((StringBuilder)sb).append(this.maybeWrapInQoutes(last.getSchemaTable().getSchema()));
            ((StringBuilder)sb).append(".");
            ((StringBuilder)sb).append(this.maybeWrapInQoutes(last.getSchemaTable().getTable()));
            ((StringBuilder)sb).append(".").append(this.maybeWrapInQoutes("ID"));
            ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(last.lastMappedAliasIdentifier("ID")));
        } else {
            int count = 1;
            for (String identifier : last.getIdentifiers()) {
                ((StringBuilder)sb).append(this.maybeWrapInQoutes(last.getSchemaTable().getSchema()));
                ((StringBuilder)sb).append(".");
                ((StringBuilder)sb).append(this.maybeWrapInQoutes(last.getSchemaTable().getTable()));
                ((StringBuilder)sb).append(".").append(this.maybeWrapInQoutes(identifier));
                ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(last.lastMappedAliasIdentifier(identifier)));
                if (count++ >= last.getIdentifiers().size()) continue;
                ((StringBuilder)sb).append(" AND ");
            }
        }
        sqls.add(Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.NORMAL, (Object)((StringBuilder)sb).toString(), (Object)false));
        if (queryTraversesEdge) {
            sb = new StringBuilder();
            ((StringBuilder)sb).append("DELETE FROM ");
            ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastEdge.getSchemaTable().getSchema()));
            ((StringBuilder)sb).append(".");
            ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastEdge.getSchemaTable().getTable()));
            ((StringBuilder)sb).append("\nFROM (");
            ((StringBuilder)sb).append(edgesToDelete);
            ((StringBuilder)sb).append("\n) x\n");
            ((StringBuilder)sb).append("WHERE ");
            if (lastEdge.isHasIDPrimaryKey()) {
                ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastEdge.getSchemaTable().getSchema()));
                ((StringBuilder)sb).append(".");
                ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastEdge.getSchemaTable().getTable()));
                ((StringBuilder)sb).append(".").append(this.maybeWrapInQoutes("ID"));
                ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(lastEdge.lastMappedAliasIdentifier("ID")));
            } else {
                int count = 1;
                for (String identifier : lastEdge.getIdentifiers()) {
                    ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastEdge.getSchemaTable().getSchema()));
                    ((StringBuilder)sb).append(".");
                    ((StringBuilder)sb).append(this.maybeWrapInQoutes(lastEdge.getSchemaTable().getTable()));
                    ((StringBuilder)sb).append(".").append(this.maybeWrapInQoutes(identifier));
                    ((StringBuilder)sb).append(" = x.").append(this.maybeWrapInQoutes(lastEdge.lastMappedAliasIdentifier(identifier)));
                    if (count++ >= last.getIdentifiers().size()) continue;
                    ((StringBuilder)sb).append(" AND ");
                }
            }
            sqls.add((Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>)Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.EDGE, (Object)((StringBuilder)sb).toString(), (Object)false));
        }
        if (queryTraversesEdge) {
            String edgeTableName;
            for (EdgeLabel edgeLabel : lastVertexLabel.getOutEdgeLabels().values()) {
                edgeTableName = this.maybeWrapInQoutes(edgeLabel.getSchema().getName()) + "." + this.maybeWrapInQoutes("E_" + edgeLabel.getLabel());
                sqls.add((Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>)Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.ALTER, (Object)this.sqlToTurnOnReferentialConstraintCheck(edgeTableName), (Object)false));
            }
            for (EdgeLabel edgeLabel : lastVertexLabel.getInEdgeLabels().values()) {
                edgeTableName = this.maybeWrapInQoutes(edgeLabel.getSchema().getName()) + "." + this.maybeWrapInQoutes("E_" + edgeLabel.getLabel());
                sqls.add((Triple<SqlgSqlExecutor.DROP_QUERY, String, Boolean>)Triple.of((Object)SqlgSqlExecutor.DROP_QUERY.ALTER, (Object)this.sqlToTurnOnReferentialConstraintCheck(edgeTableName), (Object)false));
            }
        }
        return sqls;
    }

    public String dropWithForeignKey(boolean out, EdgeLabel edgeLabel, VertexLabel vertexLabel, Collection<RecordId.ID> ids, boolean mutatingCallbacks) {
        int count;
        StringBuilder sql = new StringBuilder();
        sql.append("WITH todelete(");
        if (vertexLabel.hasIDPrimaryKey()) {
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : vertexLabel.getIdentifiers()) {
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= vertexLabel.getIdentifiers().size()) continue;
                sql.append(",");
            }
        }
        sql.append(") as (\nSELECT * FROM (VALUES");
        if (vertexLabel.hasIDPrimaryKey()) {
            count = 1;
            for (RecordId.ID id : ids) {
                sql.append("(");
                sql.append(id.getSequenceId());
                sql.append(")");
                if (count++ >= ids.size()) continue;
                sql.append(",");
            }
        } else {
            int cnt = 1;
            for (RecordId.ID id : ids) {
                sql.append("(");
                int count2 = 1;
                for (Comparable identifierValue : id.getIdentifiers()) {
                    sql.append(this.toRDBSStringLiteral(identifierValue));
                    if (count2++ >= id.getIdentifiers().size()) continue;
                    sql.append(",");
                }
                sql.append(")");
                if (cnt++ >= ids.size()) continue;
                sql.append(",");
            }
        }
        sql.append(") as tmp(");
        if (vertexLabel.hasIDPrimaryKey()) {
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : vertexLabel.getIdentifiers()) {
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= vertexLabel.getIdentifiers().size()) continue;
                sql.append(",");
            }
        }
        sql.append("))\n");
        sql.append("DELETE a FROM\n\t");
        sql.append(this.maybeWrapInQoutes(edgeLabel.getSchema().getName()));
        sql.append(".");
        sql.append(this.maybeWrapInQoutes("E_" + edgeLabel.getName()));
        sql.append(" a ");
        if (mutatingCallbacks) {
            sql.append("\nOUTPUT DELETED.");
            sql.append(this.maybeWrapInQoutes("ID"));
        }
        sql.append("JOIN todelete on ");
        if (vertexLabel.hasIDPrimaryKey()) {
            sql.append("todelete.");
            sql.append(this.maybeWrapInQoutes("ID"));
            sql.append(" = a.");
            sql.append(this.maybeWrapInQoutes(vertexLabel.getSchema().getName() + "." + vertexLabel.getName() + (out ? "__O" : "__I")));
        } else {
            count = 1;
            for (String identifier : vertexLabel.getIdentifiers()) {
                sql.append("todelete.");
                sql.append(this.maybeWrapInQoutes(identifier));
                sql.append(" = a.");
                sql.append(this.maybeWrapInQoutes(vertexLabel.getSchema().getName() + "." + vertexLabel.getName() + "." + identifier + (out ? "__O" : "__I")));
                if (count++ >= vertexLabel.getIdentifiers().size()) continue;
                sql.append(" AND ");
            }
        }
        return sql.toString();
    }

    public List<String> addPartitionTables() {
        return Arrays.asList("ALTER TABLE \"sqlg_schema\".\"V_vertex\" ADD \"partitionType\" VARCHAR(255) DEFAULT 'NONE' WITH VALUES;", "ALTER TABLE \"sqlg_schema\".\"V_vertex\" ADD \"partitionExpression\" VARCHAR(255);", "ALTER TABLE \"sqlg_schema\".\"V_vertex\" ADD \"shardCount\" INTEGER;", "ALTER TABLE \"sqlg_schema\".\"V_edge\" ADD \"partitionType\" VARCHAR(255) DEFAULT 'NONE' WITH VALUES;", "ALTER TABLE \"sqlg_schema\".\"V_edge\" ADD \"partitionExpression\" VARCHAR(255);", "ALTER TABLE \"sqlg_schema\".\"V_edge\" ADD \"shardCount\" INTEGER;", "CREATE TABLE \"sqlg_schema\".\"V_partition\" (\"ID\" BIGINT IDENTITY PRIMARY KEY, \"createdOn\" DATETIME, \"name\" VARCHAR(255), \"from\" VARCHAR(255), \"to\" VARCHAR(255), \"in\" VARCHAR(255), \"partitionType\" VARCHAR(255), \"partitionExpression\" VARCHAR(255));", "CREATE TABLE \"sqlg_schema\".\"E_vertex_partition\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.partition__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.partition__I\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_edge_partition\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.partition__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.partition__I\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_partition_partition\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.partition__I\" BIGINT, \"sqlg_schema.partition__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.partition__I\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"),  FOREIGN KEY (\"sqlg_schema.partition__O\") REFERENCES \"sqlg_schema\".\"V_partition\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_vertex_identifier\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, \"identifier_index\" INTEGER, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_edge_identifier\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, \"identifier_index\" INTEGER, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_vertex_distribution\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_vertex_colocate\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_edge_distribution\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));", "CREATE TABLE \"sqlg_schema\".\"E_edge_colocate\"(\"ID\" BIGINT IDENTITY PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"));");
    }

    public String addDbVersionToGraph(DatabaseMetaData metadata) {
        try {
            return "ALTER TABLE \"sqlg_schema\".\"V_graph\" ADD \"dbVersion\" VARCHAR(255) DEFAULT '" + metadata.getDatabaseProductVersion() + "';";
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String drop(VertexLabel vertexLabel, Collection<RecordId.ID> ids) {
        int count;
        StringBuilder sql = new StringBuilder();
        sql.append("WITH todelete(");
        if (vertexLabel.hasIDPrimaryKey()) {
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : vertexLabel.getIdentifiers()) {
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= vertexLabel.getIdentifiers().size()) continue;
                sql.append(",");
            }
        }
        sql.append(") as (\nSELECT * FROM (VALUES");
        if (vertexLabel.hasIDPrimaryKey()) {
            count = 1;
            for (RecordId.ID id : ids) {
                sql.append("(");
                sql.append(id.getSequenceId());
                sql.append(")");
                if (count++ >= ids.size()) continue;
                sql.append(",");
            }
        } else {
            int cnt = 1;
            for (RecordId.ID id : ids) {
                sql.append("(");
                int count2 = 1;
                for (Comparable identifierValue : id.getIdentifiers()) {
                    sql.append(this.toRDBSStringLiteral(identifierValue));
                    if (count2++ >= id.getIdentifiers().size()) continue;
                    sql.append(",");
                }
                sql.append(")");
                if (cnt++ >= ids.size()) continue;
                sql.append(",");
            }
        }
        sql.append(") as tmp(");
        if (vertexLabel.hasIDPrimaryKey()) {
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : vertexLabel.getIdentifiers()) {
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= vertexLabel.getIdentifiers().size()) continue;
                sql.append(",");
            }
        }
        sql.append("))\n");
        sql.append("DELETE a FROM\n\t");
        sql.append(this.maybeWrapInQoutes(vertexLabel.getSchema().getName()));
        sql.append(".");
        sql.append(this.maybeWrapInQoutes("V_" + vertexLabel.getName()));
        sql.append(" a JOIN todelete on ");
        if (vertexLabel.hasIDPrimaryKey()) {
            sql.append("todelete.");
            sql.append(this.maybeWrapInQoutes("ID"));
            sql.append(" = a.");
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : vertexLabel.getIdentifiers()) {
                sql.append("todelete.");
                sql.append(this.maybeWrapInQoutes(identifier));
                sql.append(" = a.");
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= vertexLabel.getIdentifiers().size()) continue;
                sql.append(" AND ");
            }
        }
        return sql.toString();
    }

    public String drop(EdgeLabel edgeLabel, Collection<RecordId.ID> ids) {
        int count;
        StringBuilder sql = new StringBuilder();
        sql.append("WITH todelete(");
        if (edgeLabel.hasIDPrimaryKey()) {
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : edgeLabel.getIdentifiers()) {
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= edgeLabel.getIdentifiers().size()) continue;
                sql.append(",");
            }
        }
        sql.append(") as (\nSELECT * FROM (VALUES");
        if (edgeLabel.hasIDPrimaryKey()) {
            count = 1;
            for (RecordId.ID id : ids) {
                sql.append("(");
                sql.append(id.getSequenceId());
                sql.append(")");
                if (count++ >= ids.size()) continue;
                sql.append(",");
            }
        } else {
            int cnt = 1;
            for (RecordId.ID id : ids) {
                sql.append("(");
                int count2 = 1;
                for (Comparable identifierValue : id.getIdentifiers()) {
                    sql.append(this.toRDBSStringLiteral(identifierValue));
                    if (count2++ >= id.getIdentifiers().size()) continue;
                    sql.append(",");
                }
                sql.append(")");
                if (cnt++ >= ids.size()) continue;
                sql.append(",");
            }
        }
        sql.append(") as tmp(");
        if (edgeLabel.hasIDPrimaryKey()) {
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : edgeLabel.getIdentifiers()) {
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= edgeLabel.getIdentifiers().size()) continue;
                sql.append(",");
            }
        }
        sql.append("))\n");
        sql.append("DELETE a FROM\n\t");
        sql.append(this.maybeWrapInQoutes(edgeLabel.getSchema().getName()));
        sql.append(".");
        sql.append(this.maybeWrapInQoutes("E_" + edgeLabel.getName()));
        sql.append(" a JOIN todelete on ");
        if (edgeLabel.hasIDPrimaryKey()) {
            sql.append("todelete.");
            sql.append(this.maybeWrapInQoutes("ID"));
            sql.append(" = a.");
            sql.append(this.maybeWrapInQoutes("ID"));
        } else {
            count = 1;
            for (String identifier : edgeLabel.getIdentifiers()) {
                sql.append("todelete.");
                sql.append(this.maybeWrapInQoutes(identifier));
                sql.append(" = a.");
                sql.append(this.maybeWrapInQoutes(identifier));
                if (count++ >= edgeLabel.getIdentifiers().size()) continue;
                sql.append(" AND ");
            }
        }
        return sql.toString();
    }

    public void grantReadOnlyUserPrivilegesToSqlgSchemas(SqlgGraph sqlgGraph) {
        Connection conn = sqlgGraph.tx().getConnection();
        try (Statement statement = conn.createStatement();){
            statement.execute("CREATE LOGIN sqlgReadOnly WITH PASSWORD = 'P@ssw0rd1'");
            statement.execute("CREATE USER sqlgReadOnly FOR LOGIN sqlgReadOnly");
            statement.execute("GRANT SELECT ON SCHEMA :: graph TO sqlgReadOnly");
            statement.execute("GRANT SELECT ON SCHEMA :: sqlg_schema TO sqlgReadOnly");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

