/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.io.IOException;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaTable;
import org.ujorm.tools.Check;

public class SqlNameProvider {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(SqlNameProvider.class);

    public String getUniqueConstraintName(List<MetaColumn> list) {
        return this.getUniqueConstraintName(list.toArray(new MetaColumn[0]));
    }

    public String getUniqueConstraintName(MetaColumn ... metaColumnArray) {
        assert (metaColumnArray.length > 0);
        MetaTable metaTable = metaColumnArray[0].getTable();
        String string = "uq__" + (String)MetaTable.NAME.of((Ujo)metaTable);
        for (MetaColumn metaColumn : metaColumnArray) {
            string = string + "__";
            string = string + metaColumn.getName();
        }
        return string;
    }

    public String getIndexName(MetaColumn ... metaColumnArray) {
        assert (metaColumnArray.length > 0);
        MetaTable metaTable = metaColumnArray[0].getTable();
        String string = "ix__" + (String)MetaTable.NAME.of((Ujo)metaTable);
        for (MetaColumn metaColumn : metaColumnArray) {
            string = string + "__";
            string = string + metaColumn.getName();
        }
        return string;
    }

    protected void printConstraintName(MetaTable metaTable, MetaColumn metaColumn, Appendable appendable) throws IOException {
        String string = metaColumn.getConstraintName();
        if (Check.hasLength((CharSequence)string)) {
            appendable.append(string);
        } else {
            appendable.append("fk_");
            appendable.append((CharSequence)MetaTable.NAME.of((Ujo)metaTable));
            appendable.append("__");
            appendable.append((CharSequence)MetaColumn.NAME.of((Ujo)metaColumn));
        }
    }

    public String buildDefaultConstraintName(MetaTable metaTable, MetaColumn metaColumn) {
        String string = "fk__" + (String)MetaTable.NAME.of((Ujo)metaTable) + "__" + (String)MetaColumn.NAME.of((Ujo)metaColumn);
        return string;
    }

    public String buildDefaultConstraintForDefaultValueName(MetaTable metaTable, MetaColumn metaColumn) {
        String string = "df__" + (String)MetaTable.NAME.of((Ujo)metaTable) + "__" + (String)MetaColumn.NAME.of((Ujo)metaColumn);
        return string;
    }

    public String buildPrimaryKeyName(MetaTable metaTable, List<MetaColumn> list) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("pk__").append((String)MetaTable.NAME.of((Ujo)metaTable));
        for (MetaColumn metaColumn : list) {
            String string = (String)MetaColumn.NAME.of((Ujo)metaColumn);
            stringBuilder.append("__").append(string);
        }
        return stringBuilder.toString();
    }
}

