/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl.configuration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.uiautomation.ios.client.uiamodels.impl.RemoteIOSObject;
import org.uiautomation.ios.client.uiamodels.impl.RemoteUIAElement;
import org.uiautomation.ios.communication.Helper;
import org.uiautomation.ios.communication.HttpClientFactory;
import org.uiautomation.ios.communication.Path;
import org.uiautomation.ios.communication.WebDriverLikeCommand;
import org.uiautomation.ios.communication.WebDriverLikeRequest;

public class WebDriverLikeCommandExecutor {
    private final URL remoteURL;
    private ErrorHandler errorHandler = new ErrorHandler();
    private final RemoteWebDriver driver;

    public WebDriverLikeCommandExecutor(RemoteWebDriver driver) {
        if (!(driver.getCommandExecutor() instanceof HttpCommandExecutor)) {
            throw new WebDriverException("ios driver only supports http communication.");
        }
        HttpCommandExecutor exe = (HttpCommandExecutor)driver.getCommandExecutor();
        URL remoteServer = exe.getAddressOfRemoteServer();
        this.remoteURL = remoteServer;
        this.driver = driver;
    }

    public <T> T execute(WebDriverLikeRequest request) {
        Response response = null;
        long total = 0L;
        try {
            HttpClient client = this.newHttpClientWithTimeout();
            String url = this.remoteURL + request.getPath();
            BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest(request.getMethod(), url);
            if (request.hasPayload()) {
                r.setEntity((HttpEntity)new StringEntity(request.getPayload().toString(), "UTF-8"));
            }
            HttpHost h = new HttpHost(this.remoteURL.getHost(), this.remoteURL.getPort());
            long start = System.currentTimeMillis();
            HttpResponse res = client.execute(h, (HttpRequest)r);
            total = System.currentTimeMillis() - start;
            response = Helper.exctractResponse((HttpResponse)res);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        response = this.errorHandler.throwIfResponseFailed(response, total);
        try {
            return this.cast(response.getValue());
        }
        catch (ClassCastException e) {
            System.out.println(e.getMessage() + " for " + response.getValue());
            throw e;
        }
    }

    private HttpClient newHttpClientWithTimeout() {
        DefaultHttpClient client = HttpClientFactory.getClient();
        int commandTimeoutMillis = 600000;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)commandTimeoutMillis);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)commandTimeoutMillis);
        client.setParams((HttpParams)params);
        return client;
    }

    public WebDriverLikeRequest buildRequest(WebDriverLikeCommand command, RemoteUIAElement element, Map<String, ?> params, Map<String, String> extraParamInPath) {
        String method = command.method();
        Path p = new Path(command).withSession(this.driver.getSessionId());
        if (element != null) {
            p.withReference(element.getReference());
        }
        for (String key : extraParamInPath.keySet()) {
            p.validateAndReplace(":" + key, extraParamInPath.get(key));
        }
        WebDriverLikeRequest request = new WebDriverLikeRequest(method, p, params);
        return request;
    }

    public WebDriverLikeRequest buildRequest(WebDriverLikeCommand command, RemoteUIAElement element, Map<String, ?> params) {
        return this.buildRequest(command, element, params, new HashMap<String, String>());
    }

    public WebDriverLikeRequest buildRequest(WebDriverLikeCommand command) {
        return this.buildRequest(command, null, null);
    }

    public WebDriverLikeRequest buildRequest(WebDriverLikeCommand command, Map<String, ?> params) {
        return this.buildRequest(command, null, params);
    }

    private <T> T cast(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.containsKey("ELEMENT")) {
                return (T)RemoteIOSObject.createObject(this.driver, map);
            }
            if (map.containsKey("tree")) {
                String serialized = new BeanToJsonConverter().convert(o);
                try {
                    return (T)new JSONObject(serialized);
                }
                catch (JSONException e) {
                    throw new WebDriverException("cannot cast");
                }
            }
            return (T)map;
        }
        if (o instanceof Collection) {
            ArrayList<T> res = new ArrayList<T>();
            Collection c = (Collection)o;
            for (Object ob : c) {
                res.add(this.cast(ob));
            }
            return (T)res;
        }
        return (T)o;
    }
}

