/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl.augmenter;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.uiautomation.ios.client.uiamodels.impl.AttachRemoteIOSDriver;
import org.uiautomation.ios.client.uiamodels.impl.RemoteIOSDriver;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.AddConfigurable;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.AddIOSSearchContext;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.AddIOSTouchScreen;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.AddLogElementTree;

public class IOSDriverAugmenter {
    public static <T> T augment(WebDriver driver) {
        Augmenter augmenter = new Augmenter();
        augmenter.addDriverAugmentation("configurable", (AugmenterProvider)new AddConfigurable());
        augmenter.addDriverAugmentation("elementTree", (AugmenterProvider)new AddLogElementTree());
        augmenter.addDriverAugmentation("iosSearchContext", (AugmenterProvider)new AddIOSSearchContext());
        augmenter.addDriverAugmentation("iosTouchScreen", (AugmenterProvider)new AddIOSTouchScreen());
        return (T)augmenter.augment(driver);
    }

    public static RemoteIOSDriver getIOSDriver(RemoteWebDriver driver) {
        if (!(driver.getCommandExecutor() instanceof HttpCommandExecutor)) {
            throw new WebDriverException("ios only supports http communication.");
        }
        HttpCommandExecutor e = (HttpCommandExecutor)driver.getCommandExecutor();
        AttachRemoteIOSDriver attach = new AttachRemoteIOSDriver(e.getAddressOfRemoteServer(), driver.getSessionId());
        return attach;
    }
}

