/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.uiautomation.ios.UIAModels.ScrollDirection;
import org.uiautomation.ios.UIAModels.UIAScrollView;
import org.uiautomation.ios.client.uiamodels.impl.RemoteUIAElement;
import org.uiautomation.ios.communication.WebDriverLikeCommand;
import org.uiautomation.ios.communication.WebDriverLikeRequest;

public class RemoteUIAScrollView
extends RemoteUIAElement
implements UIAScrollView {
    public RemoteUIAScrollView(RemoteWebDriver driver, String reference) {
        super(driver, reference);
    }

    public void scroll(ScrollDirection scrollDirection) {
        switch (scrollDirection) {
            case UP: {
                this.createScrollRequest("up");
                break;
            }
            case DOWN: {
                this.createScrollRequest("down");
                break;
            }
            case LEFT: {
                this.createScrollRequest("left");
                break;
            }
            case RIGHT: {
                this.createScrollRequest("right");
                break;
            }
            default: {
                throw new WebDriverException("Scrolling direction : " + scrollDirection + " not recognised");
            }
        }
    }

    private void createScrollRequest(String direction) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENT_SCROLL, (Map<String, ?>)ImmutableMap.of((Object)"direction", (Object)direction));
        this.commandExecutor.execute(request);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void scrollToElementWithName(String name) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENT_SCROLL, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
        this.commandExecutor.execute(request);
    }

    public void scrollToElementWithPredicate(String predicate) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENT_SCROLL, (Map<String, ?>)ImmutableMap.of((Object)"predicateString", (Object)predicate));
        this.commandExecutor.execute(request);
    }
}

