/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.uiautomation.ios.UIAModels.UIAElement;
import org.uiautomation.ios.UIAModels.UIAPoint;
import org.uiautomation.ios.UIAModels.UIARect;
import org.uiautomation.ios.UIAModels.predicate.AndCriteria;
import org.uiautomation.ios.UIAModels.predicate.Criteria;
import org.uiautomation.ios.UIAModels.predicate.TypeCriteria;
import org.uiautomation.ios.client.uiamodels.impl.RemoteIOSDriver;
import org.uiautomation.ios.client.uiamodels.impl.RemoteIOSObject;
import org.uiautomation.ios.communication.Path;
import org.uiautomation.ios.communication.WebDriverLikeCommand;
import org.uiautomation.ios.communication.WebDriverLikeRequest;

public class RemoteUIAElement
extends RemoteIOSObject
implements UIAElement {
    public RemoteUIAElement(RemoteWebDriver driver, String reference) {
        super(driver, reference);
    }

    public String getLabel() {
        return this.getAttribute("label");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public <T extends UIAElement> T findElement(Class<T> type, Criteria c) throws NoSuchElementException {
        AndCriteria newOne = new AndCriteria(new Criteria[]{new TypeCriteria(type), c});
        return this.findElement((Criteria)newOne);
    }

    public <T extends UIAElement> T findElement(Criteria c) throws NoSuchElementException {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"depth", (Object)-1, (Object)"criteria", (Object)c.stringify()));
        return (T)((UIAElement)this.commandExecutor.execute(request));
    }

    public List<UIAElement> findElements(Criteria c) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENTS, (Map<String, ?>)ImmutableMap.of((Object)"depth", (Object)-1, (Object)"criteria", (Object)c.stringify()));
        return (List)this.commandExecutor.execute(request);
    }

    protected WebElement findElement(String by, String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (WebElement)this.commandExecutor.execute(request);
    }

    protected List<WebElement> findElements(String by, String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENTS, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (List)this.commandExecutor.execute(request);
    }

    protected WebDriverLikeRequest buildRequest(WebDriverLikeCommand command, Map<String, ?> params) {
        return this.commandExecutor.buildRequest(command, this, params);
    }

    public void tap() {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.CLICK);
        this.commandExecutor.execute(request);
    }

    protected WebDriverLikeRequest buildRequest(WebDriverLikeCommand command) {
        return this.buildRequest(command, null);
    }

    public void touchAndHold(int durationInSecs) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.NATIVE_TOUCH_AND_HOLD, (Map<String, ?>)ImmutableMap.of((Object)"duration", (Object)durationInSecs));
        this.commandExecutor.execute(request);
    }

    public void doubleTap() {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.DOUBLE_TAP);
        this.commandExecutor.execute(request);
    }

    public void twoFingerTap() {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.TWO_FINGER_TAP);
        this.commandExecutor.execute(request);
    }

    public void scrollToVisible() {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.ELEMENT_SCROLL, (Map<String, ?>)ImmutableMap.of((Object)"toVisible", (Object)"true"));
        this.commandExecutor.execute(request);
    }

    public JSONObject logElementTree(File screenshot, boolean translation) throws Exception {
        WebDriverLikeCommand command = WebDriverLikeCommand.TREE;
        Path p = new Path(command).withSession(this.getDriver().getSessionId()).withReference(this.getReference());
        return this.logElementTree(screenshot, translation, p, command, this.getDriver());
    }

    public JSONObject logElementTree(File screenshot, boolean translation, Path path, WebDriverLikeCommand command, RemoteWebDriver driver) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.TREE, (Map<String, ?>)ImmutableMap.of((Object)"attachScreenshot", (Object)(screenshot != null ? 1 : 0), (Object)"translation", (Object)translation));
        JSONObject log = (JSONObject)this.commandExecutor.execute(request);
        if (screenshot != null) {
            JSONObject screen = log.optJSONObject("screenshot");
            String content = screen.optString("64encoded");
            RemoteUIAElement.createFileFrom64EncodedString(screenshot, content);
        }
        log.remove("screenshot");
        return log;
    }

    public static void createFileFrom64EncodedString(File f, String encoded64) {
        try {
            byte[] img64 = Base64.decodeBase64((String)encoded64);
            FileOutputStream os = new FileOutputStream(f);
            os.write(img64);
            os.close();
        }
        catch (Exception e) {
            throw new WebDriverException("cannot extract screenshot" + e.getMessage());
        }
    }

    public boolean isDisplayed() {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.DISPLAYED);
        return (Boolean)this.commandExecutor.execute(request);
    }

    public String getAttribute(String name) {
        WebDriverLikeRequest request = this.commandExecutor.buildRequest(WebDriverLikeCommand.ATTRIBUTE, this, null, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)name));
        String returnValue = String.valueOf(this.commandExecutor.execute(request));
        if (returnValue.equals("null")) {
            return null;
        }
        return returnValue;
    }

    public UIARect getRect() {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.RECT);
        Map rect = (Map)this.commandExecutor.execute(request);
        Map origin = (Map)rect.get("origin");
        Map size = (Map)rect.get("size");
        Long x = (Long)origin.get("x");
        Long y = (Long)origin.get("y");
        Long height = (Long)size.get("height");
        Long width = (Long)size.get("width");
        UIARect res = new UIARect(x.intValue(), y.intValue(), height.intValue(), width.intValue());
        return res;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getSimpleName());
        builder.append("int. key:" + this.getReference());
        builder.append(",name:" + this.getName());
        builder.append(",value:" + this.getValue());
        builder.append(",label:" + this.getLabel());
        return builder.toString();
    }

    public void flickInsideWithOptions(int touchCount, UIAPoint startOffset, UIAPoint endOffset) {
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.FLICK_INSIDE_WITH_OPTIONS, (Map<String, ?>)ImmutableMap.of((Object)"touchCount", (Object)touchCount, (Object)"xstart", (Object)startOffset.getX(), (Object)"ystart", (Object)startOffset.getY(), (Object)"xend", (Object)endOffset.getX(), (Object)"yend", (Object)endOffset.getY()));
        this.commandExecutor.execute(request);
    }

    public static RemoteUIAElement getFrontMostApp(RemoteIOSDriver driver) {
        return new RemoteUIAElement(driver, "1");
    }

    public static RemoteUIAElement target(RemoteIOSDriver driver) {
        return new RemoteUIAElement(driver, "2");
    }

    public Point getLocation() {
        System.out.println("getLocation in RemoteUIAElement");
        WebDriverLikeRequest request = this.buildRequest(WebDriverLikeCommand.RECT);
        Map rect = (Map)this.commandExecutor.execute(request);
        Map origin = (Map)rect.get("origin");
        Long x = (Long)origin.get("x");
        Long y = (Long)origin.get("y");
        Point res = new Point(x.intValue(), y.intValue());
        return res;
    }
}

