/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.uiautomation.ios.client.uiamodels.impl.configuration.WebDriverLikeCommandExecutor;

public abstract class RemoteIOSObject
extends RemoteWebElement {
    private final RemoteWebDriver driver;
    private final String reference;
    protected final WebDriverLikeCommandExecutor commandExecutor;

    public RemoteIOSObject(RemoteWebDriver driver, String reference) {
        this.driver = driver;
        this.reference = reference;
        this.setParent(driver);
        this.commandExecutor = new WebDriverLikeCommandExecutor(driver);
    }

    public static WebElement createObject(RemoteWebDriver driver, Map<String, Object> ro) {
        String ref = ro.get("ELEMENT").toString();
        String type = (String)ro.get("type");
        if (type != null) {
            String remoteObjectName = "org.uiautomation.ios.client.uiamodels.impl.Remote" + type;
            if ("UIAElementNil".equals(type)) {
                return null;
            }
            boolean isArray = false;
            Object[] args = null;
            Class[] argsClass = null;
            if (!isArray) {
                args = new Object[]{driver, ref};
                argsClass = new Class[]{RemoteWebDriver.class, String.class};
            }
            try {
                Class<?> clazz = Class.forName(remoteObjectName);
                Constructor<?> c = clazz.getConstructor(argsClass);
                Object o = c.newInstance(args);
                RemoteWebElement element = (RemoteWebElement)o;
                element.setFileDetector(driver.getFileDetector());
                element.setParent(driver);
                element.setId(ref);
                return (RemoteIOSObject)((Object)o);
            }
            catch (Exception e) {
                throw new WebDriverException("error casting", (Throwable)e);
            }
        }
        RemoteWebElement element = new RemoteWebElement();
        element.setFileDetector(driver.getFileDetector());
        element.setId(ref);
        element.setParent(driver);
        return element;
    }

    protected RemoteWebDriver getDriver() {
        return this.driver;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ",ref:" + this.reference;
    }
}

