/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.remote.RemoteTouchScreen;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;
import org.uiautomation.ios.IOSCapabilities;
import org.uiautomation.ios.UIAModels.Orientation;
import org.uiautomation.ios.UIAModels.UIAElement;
import org.uiautomation.ios.UIAModels.UIAKeyboard;
import org.uiautomation.ios.UIAModels.configuration.DriverConfiguration;
import org.uiautomation.ios.UIAModels.predicate.Criteria;
import org.uiautomation.ios.UIAModels.predicate.TypeCriteria;
import org.uiautomation.ios.client.uiamodels.impl.RemoteUIAElement;
import org.uiautomation.ios.client.uiamodels.impl.RemoteUIAKeyboard;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.Configurable;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.ElementTree;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.IOSSearchContext;
import org.uiautomation.ios.client.uiamodels.impl.augmenter.IOSTouchScreen;
import org.uiautomation.ios.client.uiamodels.impl.configuration.RemoteDriverConfiguration;
import org.uiautomation.ios.client.uiamodels.impl.configuration.WebDriverLikeCommandExecutor;
import org.uiautomation.ios.communication.WebDriverLikeCommand;
import org.uiautomation.ios.communication.WebDriverLikeRequest;

public class RemoteIOSDriver
extends RemoteWebDriver
implements TakesScreenshot,
Rotatable,
LocationContext,
ElementTree,
IOSSearchContext,
Configurable,
HasTouchScreen,
IOSTouchScreen {
    private String remoteURL;
    private Map<String, Object> requestedCapabilities;
    private String host;
    private int port;
    private DriverConfiguration configuration;
    protected WebDriverLikeCommandExecutor executor;
    private TouchScreen touchScreen;

    protected RemoteIOSDriver() {
        this.executor = new WebDriverLikeCommandExecutor(this);
        this.touchScreen = new RemoteTouchScreen(this.getExecuteMethod());
    }

    public RemoteIOSDriver(URL url, IOSCapabilities cap) {
        super(url, (Capabilities)cap);
        this.remoteURL = url.toExternalForm();
        this.executor = new WebDriverLikeCommandExecutor(this);
        this.touchScreen = new RemoteTouchScreen(this.getExecuteMethod());
        this.requestedCapabilities = cap == null ? null : cap.getRawCapabilities();
        this.port = url.getPort();
        this.host = url.getHost();
        this.configuration = new RemoteDriverConfiguration(this);
    }

    @Override
    public JSONObject logElementTree(File screenshot, boolean translation) throws WebDriverException {
        return RemoteIOSDriver.logElementTree(this.executor, screenshot, translation);
    }

    @Override
    public void dragFromToForDuration(Point from, Point to, int duration) throws WebDriverException {
        RemoteIOSDriver.dragFromToForDuration(this.executor, from, to, duration);
    }

    @Override
    public void pinchOpenFromToForDuration(Point from, Point to, int durationInSecs) {
        RemoteIOSDriver.pinchOpenFromToForDuration(this.executor, from, to, durationInSecs);
    }

    @Override
    public void pinchCloseFromToForDuration(Point from, Point to, int durationInSecs) {
        RemoteIOSDriver.pinchCloseFromToForDuration(this.executor, from, to, durationInSecs);
    }

    public IOSCapabilities getCapabilities() {
        Capabilities cap = super.getCapabilities();
        if (cap == null) {
            return null;
        }
        IOSCapabilities ioscap = new IOSCapabilities(cap.asMap());
        return ioscap;
    }

    protected WebElement findElement(String by, String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.ELEMENT_ROOT, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (WebElement)this.executor.execute(request);
    }

    protected List<WebElement> findElements(String by, String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null.");
        }
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.ELEMENTS_ROOT, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (List)this.executor.execute(request);
    }

    @Override
    public <T extends UIAElement> T findElement(Criteria c) throws NoSuchElementException {
        return RemoteIOSDriver.findElement(this.executor, c);
    }

    @Override
    public List<UIAElement> findElements(Criteria c) {
        return RemoteIOSDriver.findElements(this.executor, c);
    }

    public Set<String> getWindowHandles() {
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.WINDOW_HANDLES);
        List all = (List)this.executor.execute(request);
        HashSet<String> res = new HashSet<String>();
        res.addAll(all);
        return res;
    }

    public Object executeScript(String script, Object ... args) {
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.EXECUTE_SCRIPT, (Map<String, ?>)params);
        return this.executor.execute(request);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    public Keyboard getKeyboard() {
        return (RemoteUIAKeyboard)((Object)this.findElement((Criteria)new TypeCriteria(UIAKeyboard.class)));
    }

    public void rotate(ScreenOrientation orientation) {
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.SET_ORIENTATION, (Map<String, ?>)ImmutableMap.of((Object)"orientation", (Object)orientation));
        this.executor.execute(request);
    }

    public void rotate(Orientation orientation) {
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.SET_ORIENTATION, (Map<String, ?>)ImmutableMap.of((Object)"orientation", (Object)orientation));
        this.executor.execute(request);
    }

    public ScreenOrientation getOrientation() {
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.GET_ORIENTATION);
        String res = (String)this.executor.execute(request);
        return ScreenOrientation.valueOf((String)res);
    }

    public Orientation getNativeOrientation() {
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.GET_ORIENTATION);
        String res = (String)this.executor.execute(request);
        return Orientation.valueOf((String)res);
    }

    public Dimension getScreenSize() {
        WebDriverLikeRequest request = this.executor.buildRequest(WebDriverLikeCommand.GET_SCREENRECT);
        Map size = (Map)this.executor.execute(request);
        Long height = (Long)size.get("height");
        Long width = (Long)size.get("width");
        return new Dimension(width.intValue(), height.intValue());
    }

    @Override
    public void setConfiguration(WebDriverLikeCommand command, String key, Object value) {
        RemoteIOSDriver.setConfiguration(this.executor, command, key, value);
    }

    @Override
    public Map<String, Object> getConfiguration(WebDriverLikeCommand command) {
        return RemoteIOSDriver.getConfiguration(this.executor, command);
    }

    public Location location() {
        return null;
    }

    public void setLocation(Location location) {
    }

    public static JSONObject logElementTree(WebDriverLikeCommandExecutor executor, File screenshot, boolean translation) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.TREE_ROOT, (Map<String, ?>)ImmutableMap.of((Object)"attachScreenshot", (Object)(screenshot != null ? 1 : 0), (Object)"translation", (Object)translation));
        JSONObject log = (JSONObject)executor.execute(request);
        if (screenshot != null) {
            JSONObject screen = log.optJSONObject("screenshot");
            String content = screen.optString("64encoded");
            RemoteUIAElement.createFileFrom64EncodedString(screenshot, content);
        }
        log.remove("screenshot");
        return log;
    }

    public static List<UIAElement> findElements(WebDriverLikeCommandExecutor executor, Criteria c) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.ELEMENTS_ROOT, (Map<String, ?>)ImmutableMap.of((Object)"depth", (Object)-1, (Object)"criteria", (Object)c.stringify()));
        return (List)executor.execute(request);
    }

    public static <T extends UIAElement> T findElement(WebDriverLikeCommandExecutor executor, Criteria c) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.ELEMENT_ROOT, (Map<String, ?>)ImmutableMap.of((Object)"depth", (Object)-1, (Object)"criteria", (Object)c.stringify()));
        return (T)((UIAElement)executor.execute(request));
    }

    public static Map<String, Object> getConfiguration(WebDriverLikeCommandExecutor executor, WebDriverLikeCommand command) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.GET_CONFIGURATION, null, new HashMap(), (Map<String, String>)ImmutableMap.of((Object)"command", (Object)command.toString()));
        return (Map)executor.execute(request);
    }

    public static void setConfiguration(WebDriverLikeCommandExecutor executor, WebDriverLikeCommand command, String key, Object value) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.CONFIGURE, null, (Map<String, ?>)ImmutableMap.of((Object)key, (Object)value), (Map<String, String>)ImmutableMap.of((Object)"command", (Object)command.toString()));
        executor.execute(request);
    }

    public TouchScreen getTouch() {
        return this.touchScreen;
    }

    public static void dragFromToForDuration(WebDriverLikeCommandExecutor executor, Point from, Point to, int durationInSecs) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.DRAG_FROM_TO_FOR_DURATION, (Map<String, ?>)ImmutableMap.of((Object)"fromX", (Object)Integer.toString(from.getX()), (Object)"fromY", (Object)Integer.toString(from.getY()), (Object)"toX", (Object)Integer.toString(to.getX()), (Object)"toY", (Object)Integer.toString(to.getY()), (Object)"duration", (Object)durationInSecs));
        executor.execute(request);
    }

    public static void pinchCloseFromToForDuration(WebDriverLikeCommandExecutor executor, Point from, Point to, int durationInSecs) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.PINCH_CLOSE_FROM_TO_FOR_DURATION, (Map<String, ?>)ImmutableMap.of((Object)"fromX", (Object)Integer.toString(from.getX()), (Object)"fromY", (Object)Integer.toString(from.getY()), (Object)"toX", (Object)Integer.toString(to.getX()), (Object)"toY", (Object)Integer.toString(to.getY()), (Object)"duration", (Object)durationInSecs));
        executor.execute(request);
    }

    public static void pinchOpenFromToForDuration(WebDriverLikeCommandExecutor executor, Point from, Point to, int durationInSecs) {
        WebDriverLikeRequest request = executor.buildRequest(WebDriverLikeCommand.PINCH_OPEN_FROM_TO_FOR_DURATION, (Map<String, ?>)ImmutableMap.of((Object)"fromX", (Object)Integer.toString(from.getX()), (Object)"fromY", (Object)Integer.toString(from.getY()), (Object)"toX", (Object)Integer.toString(to.getX()), (Object)"toY", (Object)Integer.toString(to.getY()), (Object)"duration", (Object)durationInSecs));
        executor.execute(request);
    }
}

