/*
 * Decompiled with CFR 0.152.
 */
package org.uiautomation.ios.client.uiamodels.impl;

import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.uiautomation.ios.UIAModels.predicate.Criteria;
import org.uiautomation.ios.UIAModels.predicate.CriteriaDecorator;
import org.uiautomation.ios.UIAModels.predicate.L10NStrategy;
import org.uiautomation.ios.UIAModels.predicate.LabelCriteria;
import org.uiautomation.ios.UIAModels.predicate.MatchingStrategy;
import org.uiautomation.ios.UIAModels.predicate.NameCriteria;
import org.uiautomation.ios.UIAModels.predicate.PropertyEqualCriteria;
import org.uiautomation.ios.UIAModels.predicate.ValueCriteria;

public class ClientSideCriteriaFactory {
    private CriteriaDecorator decorator;

    public ClientSideCriteriaFactory(Map<String, String> contentByKey) {
        this.decorator = new ClientSideL10NDecorator(contentByKey);
    }

    public NameCriteria nameCriteria(String expected, L10NStrategy l10nStrategy, MatchingStrategy matchingStrategy) {
        NameCriteria c = new NameCriteria(expected, l10nStrategy, matchingStrategy);
        c.addDecorator(this.decorator);
        c.decorate();
        return c;
    }

    public LabelCriteria labelCriteria(String expected, L10NStrategy l10nStrategy, MatchingStrategy matchingStrategy) {
        LabelCriteria c = new LabelCriteria(expected, l10nStrategy, matchingStrategy);
        c.addDecorator(this.decorator);
        c.decorate();
        return c;
    }

    public ValueCriteria valueCriteria(String expected, L10NStrategy l10nStrategy, MatchingStrategy matchingStrategy) {
        ValueCriteria c = new ValueCriteria(expected, l10nStrategy, matchingStrategy);
        c.addDecorator(this.decorator);
        c.decorate();
        return c;
    }

    private boolean requiresDecoration(Criteria c) {
        PropertyEqualCriteria crit;
        L10NStrategy strategy;
        return c instanceof PropertyEqualCriteria && (strategy = (crit = (PropertyEqualCriteria)c).getL10nstrategy()) == L10NStrategy.clientL10N;
    }

    class ClientSideL10NDecorator
    implements CriteriaDecorator {
        private Map<String, String> clientSideL10n;

        public ClientSideL10NDecorator(Map<String, String> clientSideL10n) {
            this.clientSideL10n = clientSideL10n;
        }

        public void decorate(Criteria c) {
            if (ClientSideCriteriaFactory.this.requiresDecoration(c)) {
                PropertyEqualCriteria criteria = (PropertyEqualCriteria)c;
                String newValue = this.localizeString(criteria.getValue());
                criteria.setValue(newValue);
                criteria.setL10nstrategy(L10NStrategy.none);
            }
        }

        private String localizeString(String value) {
            if (this.clientSideL10n == null) {
                throw new WebDriverException("you need to provide client side content to use the client side l10n");
            }
            String res = this.clientSideL10n.get(value);
            if (res == null) {
                throw new WebDriverException("no client side content provided for " + value);
            }
            return res;
        }
    }
}

