/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.net.URI;
import java.net.URISyntaxException;
import org.uberfire.commons.util.Preconditions;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.api.FileSystemProviders;

public final class Paths {
    private Paths() {
    }

    public static Path get(String first, String ... more) throws IllegalArgumentException {
        Preconditions.checkNotNull((String)"first", (Object)first);
        if (first.trim().length() == 0) {
            return FileSystems.getDefault().getPath(first, new String[0]);
        }
        URI uri = null;
        if (more == null || more.length == 0) {
            try {
                uri = new URI(first);
            }
            catch (URISyntaxException ex) {
                try {
                    uri = URI.create(first);
                }
                catch (IllegalArgumentException e) {
                    uri = null;
                }
            }
        }
        if (uri != null && uri.getScheme() != null) {
            return Paths.get(uri);
        }
        return FileSystems.getDefault().getPath(first, more);
    }

    public static Path get(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        return FileSystemProviders.resolveProvider(uri).getPath(uri);
    }
}

