/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bayesian.network.client.shapes;

import com.emitrom.lienzo.client.core.shape.IPrimitive;
import com.emitrom.lienzo.client.core.shape.Rectangle;
import com.emitrom.lienzo.client.core.shape.Text;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.uberfire.ext.wires.bayesian.network.client.utils.BayesianUtils;
import org.uberfire.ext.wires.bayesian.network.parser.client.model.BayesVariable;
import org.uberfire.ext.wires.core.api.shapes.OverridesFactoryDescription;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;

public class EditableBayesianNode
extends WiresBaseShape
implements OverridesFactoryDescription,
Serializable {
    private static final long serialVersionUID = -5490131652690005490L;
    private static final int BOUNDARY_SIZE = 10;
    private Rectangle header;
    private Text textHeader;
    private Map<Text, List<Rectangle>> porcentualBars;
    private final Rectangle rectangle;
    private final Rectangle bounding;
    private final BayesVariable variable;

    public EditableBayesianNode() {
        this(0.0, 0.0, 0.0, 0.0, "");
    }

    public EditableBayesianNode(Rectangle shape) {
        this(shape.getWidth(), shape.getHeight(), shape.getOffset().getX(), shape.getOffset().getY(), BayesianUtils.getNodeColors()[0][0]);
    }

    public EditableBayesianNode(double width, double height, double positionXNode, double positionYNode, String fillColor) {
        this(width, height, positionXNode, positionYNode, fillColor, new BayesVariable());
    }

    public EditableBayesianNode(double width, double height, double positionXNode, double positionYNode, String fillColor, BayesVariable variable) {
        this.variable = variable;
        this.rectangle = new Rectangle(width, height);
        this.rectangle.setStrokeColor("#999999");
        this.rectangle.setStrokeWidth(2.0);
        this.rectangle.setFillColor(fillColor);
        this.bounding = new Rectangle(width + 10.0, height + 10.0, this.rectangle.getCornerRadius());
        this.bounding.setX(this.getX() - 5.0);
        this.bounding.setY(this.getY() - 5.0);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.1);
        this.add((IPrimitive)this.rectangle);
        this.setX(positionXNode);
        this.setY(positionYNode);
        this.porcentualBars = Maps.newHashMap();
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.bounding);
        } else {
            this.remove((IPrimitive)this.bounding);
        }
    }

    public boolean contains(double cx, double cy) {
        return false;
    }

    public void buildNode() {
        this.add((IPrimitive)this.header);
        this.add((IPrimitive)this.textHeader);
        for (Map.Entry<Text, List<Rectangle>> porcenualBar : this.porcentualBars.entrySet()) {
            for (Rectangle rec : porcenualBar.getValue()) {
                this.add((IPrimitive)rec);
            }
            this.add((IPrimitive)porcenualBar.getKey());
        }
    }

    public Rectangle getParentNode() {
        return this.rectangle;
    }

    public Rectangle getHeader() {
        return this.header;
    }

    public void setHeader(Rectangle header) {
        this.header = header;
    }

    public Text getTextHeader() {
        return this.textHeader;
    }

    public void setTextHeader(Text textHeader) {
        this.textHeader = textHeader;
    }

    public Map<Text, List<Rectangle>> getPorcentualsBar() {
        return this.porcentualBars;
    }

    public void setPorcentualBars(Map<Text, List<Rectangle>> porcentualBars) {
        this.porcentualBars = porcentualBars;
    }

    public double getWidth() {
        return this.rectangle.getWidth();
    }

    public BayesVariable getVariable() {
        return this.variable;
    }

    public String getDescription() {
        return this.variable.getName();
    }
}

