/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.list;

import java.util.Collection;
import java.util.List;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class EntitiesListTest
extends AbstractSecurityManagementTest {
    protected EntitiesList<User> presenter;
    protected HeadingSize headingSize = HeadingSize.H3;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EntitiesList.View view;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new EntitiesList(this.loadingBox, this.view);
        this.presenter.setPageSize(5);
        this.presenter.setEntityTitleSize(this.headingSize);
    }

    @Test
    public void testClear() throws Exception {
        this.presenter.callback = (EntitiesList.Callback)Mockito.mock(EntitiesList.Callback.class);
        this.presenter.paginationConstraints = (EntitiesList.PaginationConstraints)Mockito.mock(EntitiesList.PaginationConstraints.class);
        this.presenter.totalPages = 10;
        this.presenter.emptyEntitiesText = "empty";
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.callback);
        Assert.assertNull((Object)this.presenter.paginationConstraints);
        Assert.assertEquals((long)this.presenter.totalPages, (long)-1L);
        Assert.assertNull((Object)this.presenter.emptyEntitiesText);
        ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(ArgumentMatchers.anyString(), (EntitiesList.PaginationConstraints)ArgumentMatchers.any(EntitiesList.PaginationConstraints.class));
        ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (HeadingSize)ArgumentMatchers.any(HeadingSize.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testCallbacks() throws Exception {
        String id = "user1";
        EntitiesList.Callback callback = (EntitiesList.Callback)Mockito.mock(EntitiesList.Callback.class);
        EntitiesList.PaginationConstraints paginationConstraints = (EntitiesList.PaginationConstraints)Mockito.mock(EntitiesList.PaginationConstraints.class);
        Mockito.when((Object)paginationConstraints.getCurrentPage()).thenReturn((Object)5);
        this.presenter.callback = callback;
        this.presenter.paginationConstraints = paginationConstraints;
        this.presenter.totalPages = 10;
        this.presenter.getEntityType();
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).getEntityType();
        this.presenter.onReadEntity("user1");
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onReadEntity("user1");
        this.presenter.onRemoveEntity("user1");
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onRemoveEntity("user1");
        this.presenter.onGoToFirstPage();
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onChangePage(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)1));
        this.presenter.onGoToPrevPage();
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onChangePage(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)4));
        this.presenter.onGoToNextPage();
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onChangePage(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)6));
        this.presenter.onGoToLastPage();
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onChangePage(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)11));
        this.presenter.onSelectEntity("user1", 0, false);
        ((EntitiesList.Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSelectEntity("user1", false);
    }

    @Test
    public void testCreatePaginationCallbackSinglePage() throws Exception {
        Integer size = 10;
        List<User> users = this.buildUsersList(size);
        boolean hasNextPage = false;
        boolean page = true;
        int pageSize = 50;
        AbstractEntityManager.SearchResponse<User> searchResponse = this.createSearchResponse(users, size, false, "", 1, 50);
        EntitiesList.PaginationConstraints constraints = this.presenter.createPaginationCallback(searchResponse);
        Assert.assertFalse((boolean)constraints.isFirstPageEnabled());
        Assert.assertFalse((boolean)constraints.isFirstPageVisible());
        Assert.assertFalse((boolean)constraints.isNextPageEnabled());
        Assert.assertFalse((boolean)constraints.isNextPageVisible());
        Assert.assertFalse((boolean)constraints.isPrevPageEnabled());
        Assert.assertFalse((boolean)constraints.isPrevPageVisible());
        Assert.assertFalse((boolean)constraints.isLastPageEnabled());
        Assert.assertFalse((boolean)constraints.isLastPageVisible());
        Assert.assertEquals((Object)constraints.getTotal(), (Object)size);
        Assert.assertEquals((long)constraints.getCurrentPage(), (long)1L);
    }

    @Test
    public void testCreatePaginationCallbackMultiplePagesAtFirstPage() throws Exception {
        Integer size = 10;
        List<User> users = this.buildUsersList(size);
        boolean hasNextPage = false;
        boolean page = true;
        int pageSize = 5;
        AbstractEntityManager.SearchResponse<User> searchResponse = this.createSearchResponse(users, size, false, "", 1, 5);
        EntitiesList.PaginationConstraints constraints = this.presenter.createPaginationCallback(searchResponse);
        Assert.assertFalse((boolean)constraints.isFirstPageEnabled());
        Assert.assertFalse((boolean)constraints.isFirstPageVisible());
        Assert.assertTrue((boolean)constraints.isNextPageEnabled());
        Assert.assertTrue((boolean)constraints.isNextPageVisible());
        Assert.assertFalse((boolean)constraints.isPrevPageEnabled());
        Assert.assertFalse((boolean)constraints.isPrevPageVisible());
        Assert.assertTrue((boolean)constraints.isLastPageEnabled());
        Assert.assertTrue((boolean)constraints.isLastPageVisible());
        Assert.assertEquals((Object)constraints.getTotal(), (Object)size);
        Assert.assertEquals((long)constraints.getCurrentPage(), (long)1L);
    }

    @Test
    public void testCreatePaginationCallbackMultiplePagesAtSecondPage() throws Exception {
        Integer size = 10;
        List<User> users = this.buildUsersList(size);
        boolean hasNextPage = false;
        int page = 2;
        int pageSize = 5;
        AbstractEntityManager.SearchResponse<User> searchResponse = this.createSearchResponse(users, size, false, "", 2, 5);
        EntitiesList.PaginationConstraints constraints = this.presenter.createPaginationCallback(searchResponse);
        Assert.assertTrue((boolean)constraints.isFirstPageEnabled());
        Assert.assertTrue((boolean)constraints.isFirstPageVisible());
        Assert.assertFalse((boolean)constraints.isNextPageEnabled());
        Assert.assertFalse((boolean)constraints.isNextPageVisible());
        Assert.assertTrue((boolean)constraints.isPrevPageEnabled());
        Assert.assertTrue((boolean)constraints.isPrevPageVisible());
        Assert.assertFalse((boolean)constraints.isLastPageEnabled());
        Assert.assertFalse((boolean)constraints.isLastPageVisible());
        Assert.assertEquals((Object)constraints.getTotal(), (Object)size);
        Assert.assertEquals((long)constraints.getCurrentPage(), (long)2L);
    }

    @Test
    public void testShow() throws Exception {
        int size = 10;
        List<User> users = this.buildUsersList(10);
        boolean hasNextPage = false;
        boolean page = true;
        int pageSize = 50;
        AbstractEntityManager.SearchResponse<User> searchResponse = this.createSearchResponse(users, 10, false, "", 1, 50);
        EntitiesList.Callback<User> callback = this.createEntitiesListCallback(users, true, true, true);
        this.presenter.show(searchResponse, callback);
        Assert.assertEquals((Object)this.presenter.callback, callback);
        ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).configure((String)ArgumentMatchers.any(), (EntitiesList.PaginationConstraints)ArgumentMatchers.any(EntitiesList.PaginationConstraints.class));
        for (int x = 0; x < 10; ++x) {
            ((EntitiesList.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).add(x, this.getUserIdentifier(x), this.getUserIdentifier(x), this.headingSize, true, true, true, false);
        }
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
    }

    protected EntitiesList.Callback<User> createEntitiesListCallback(Collection<User> entities, boolean canRead, boolean canRemove, boolean canSelect) {
        EntitiesList.Callback callback = (EntitiesList.Callback)Mockito.mock(EntitiesList.Callback.class);
        Mockito.when((Object)callback.canRead()).thenReturn((Object)canRead);
        Mockito.when((Object)callback.canRemove()).thenReturn((Object)canRemove);
        Mockito.when((Object)callback.canSelect()).thenReturn((Object)canSelect);
        Mockito.when((Object)callback.isSelected(ArgumentMatchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)callback.getIdentifier((Object)((User)ArgumentMatchers.any(User.class)))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                User user = (User)invocationOnMock.getArguments()[0];
                return user.getIdentifier();
            }
        });
        Mockito.when((Object)callback.getTitle((Object)((User)ArgumentMatchers.any(User.class)))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocationOnMock) throws Throwable {
                User user = (User)invocationOnMock.getArguments()[0];
                return user.getIdentifier();
            }
        });
        return callback;
    }

    protected AbstractEntityManager.SearchResponse<User> createSearchResponse(List<User> users, int total, boolean hasNextPage, String searchPattern, int page, int pageSize) {
        AbstractEntityManager.SearchResponse response = (AbstractEntityManager.SearchResponse)Mockito.mock(AbstractEntityManager.SearchResponse.class);
        Mockito.when((Object)response.getResults()).thenReturn(users);
        Mockito.when((Object)response.getTotal()).thenReturn((Object)total);
        Mockito.when((Object)response.getPage()).thenReturn((Object)page);
        Mockito.when((Object)response.getPageSize()).thenReturn((Object)pageSize);
        return response;
    }
}

