/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group;

import com.google.gwt.user.client.ui.IsWidget;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class GroupEditorTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    EventSourceMock<OnShowEvent> onShowEvent;
    @Mock
    EventSourceMock<OnEditEvent> onEditEvent;
    @Mock
    EventSourceMock<OnDeleteEvent> onDeleteEvent;
    @Mock
    ACLSettings aclSettings;
    @Mock
    ACLViewer aclViewer;
    @Mock
    ACLEditor aclEditor;
    @Mock
    GroupEditor.View view;
    @Mock
    Group group;
    private GroupEditor tested;

    @Before
    public void setup() {
        Mockito.when((Object)this.userSystemManager.isGroupCapabilityEnabled((Capability)ArgumentMatchers.any(Capability.class))).thenReturn((Object)true);
        Mockito.when((Object)this.group.getName()).thenReturn((Object)"group1");
        this.tested = new GroupEditor(this.userSystemManager, this.onEditEvent, this.onShowEvent, this.onDeleteEvent, this.aclSettings, this.aclViewer, this.aclEditor, this.view);
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testClear() {
        this.tested.group = this.group;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.group);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testShow() {
        this.tested.show(this.group);
        Assert.assertEquals((Object)this.group, (Object)this.tested.group);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show("group1");
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showACL((IsWidget)this.aclViewer);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(false);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEditButtonVisible(true);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(false);
    }

    @Test
    public void testEdit() {
        this.tested.edit(this.group);
        Assert.assertEquals((Object)this.group, (Object)this.tested.group);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show("group1");
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).editACL((IsWidget)this.aclEditor);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(true);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEditButtonVisible(false);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDeleteButtonVisible(true);
    }

    @Test
    public void testOnDelete() {
        this.tested.onDelete();
        ((EventSourceMock)Mockito.verify(this.onDeleteEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(OnDeleteEvent.class));
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDeleteButtonVisible(ArgumentMatchers.anyBoolean());
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(ArgumentMatchers.anyString());
        ((GroupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }
}

