/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedGroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAttributesEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.ContextualEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnDeleteEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserGroupsEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnUpdateUserRolesEvent;

@Dependent
public class UserEditor
implements IsWidget,
org.uberfire.ext.security.management.client.editor.user.UserEditor {
    public View view;
    ClientUserSystemManager userSystemManager;
    UserAttributesEditor userAttributesEditor;
    UserAssignedGroupsExplorer userAssignedGroupsExplorer;
    UserAssignedGroupsEditor userAssignedGroupsEditor;
    UserAssignedRolesExplorer userAssignedRolesExplorer;
    UserAssignedRolesEditor userAssignedRolesEditor;
    ACLViewer aclViewer;
    Event<OnEditEvent> onEditEvent;
    Event<OnShowEvent> onShowEvent;
    Event<OnDeleteEvent> onDeleteEvent;
    Event<OnChangePasswordEvent> onChangePasswordEvent;
    User user;
    boolean isEditMode;

    @Inject
    public UserEditor(ClientUserSystemManager userSystemManager, UserAttributesEditor userAttributesEditor, UserAssignedGroupsExplorer userAssignedGroupsExplorer, UserAssignedGroupsEditor userAssignedGroupsEditor, UserAssignedRolesExplorer userAssignedRolesExplorer, UserAssignedRolesEditor userAssignedRolesEditor, ACLViewer aclViewer, Event<OnEditEvent> onEditEvent, Event<OnShowEvent> onShowEvent, Event<OnDeleteEvent> onDeleteEvent, Event<OnChangePasswordEvent> onChangePasswordEvent, View view) {
        this.userSystemManager = userSystemManager;
        this.userAttributesEditor = userAttributesEditor;
        this.userAssignedGroupsExplorer = userAssignedGroupsExplorer;
        this.userAssignedGroupsEditor = userAssignedGroupsEditor;
        this.userAssignedRolesExplorer = userAssignedRolesExplorer;
        this.userAssignedRolesEditor = userAssignedRolesEditor;
        this.aclViewer = aclViewer;
        this.onEditEvent = onEditEvent;
        this.onShowEvent = onShowEvent;
        this.onDeleteEvent = onDeleteEvent;
        this.onChangePasswordEvent = onChangePasswordEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.userAttributesEditor.view, this.userAssignedGroupsExplorer.view, this.userAssignedGroupsEditor.view, this.userAssignedRolesExplorer.view, this.userAssignedRolesEditor.view, this.aclViewer);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String identifier() {
        return this.user.getIdentifier();
    }

    public UserAttributesEditor attributesEditor() {
        return this.userAttributesEditor;
    }

    public UserAssignedGroupsExplorer groupsExplorer() {
        return this.userAssignedGroupsExplorer;
    }

    public org.uberfire.ext.security.management.client.editor.user.UserAssignedRolesExplorer rolesExplorer() {
        return this.userAssignedRolesExplorer;
    }

    public UserAssignedGroupsEditor groupsEditor() {
        return this.userAssignedGroupsEditor;
    }

    public UserAssignedRolesEditor rolesEditor() {
        return this.userAssignedRolesEditor;
    }

    public void show(User user) {
        this.clear();
        this.isEditMode = false;
        this.aclViewer.show(user);
        this.open(user);
        this.onShowEvent.fire((Object)new OnShowEvent(this, user));
    }

    public void edit(User user) {
        this.clear();
        this.isEditMode = true;
        this.open(user);
    }

    public void flush() {
        assert (this.user != null);
        assert (this.isEditMode);
    }

    public User getValue() {
        return this.user;
    }

    public void setViolations(Set<ConstraintViolation<User>> violations) {
    }

    public void clear() {
        this.isEditMode = false;
        this.user = null;
        this.userAttributesEditor.clear();
        this.userAssignedGroupsExplorer.clear();
        this.userAssignedGroupsEditor.clear();
        this.userAssignedRolesExplorer.clear();
    }

    public UserEditor setEditButtonVisible(boolean isVisible) {
        this.view.setEditButtonVisible(isVisible);
        return this;
    }

    public UserEditor setDeleteButtonVisible(boolean isVisible) {
        this.view.setDeleteButtonVisible(isVisible);
        return this;
    }

    public UserEditor setChangePasswordButtonVisible(boolean isVisible) {
        this.view.setChangePasswordButtonVisible(isVisible);
        return this;
    }

    public UserEditor setAttributesEditorVisible(boolean isVisible) {
        this.view.setAttributesEditorVisible(isVisible);
        return this;
    }

    public UserEditor setAddToGroupsButtonVisible(boolean isVisible) {
        this.view.setAddToGroupsButtonVisible(isVisible);
        return this;
    }

    public UserEditor setPermissionsVisible(boolean isVisible) {
        this.view.setPermissionsVisible(isVisible);
        return this;
    }

    public ACLViewer getACLViewer() {
        return this.aclViewer;
    }

    void onEdit() {
        this.onEditEvent.fire((Object)new OnEditEvent(this, this.user));
    }

    void onDelete() {
        this.onDeleteEvent.fire((Object)new OnDeleteEvent(this, this.user));
    }

    void onChangePassword() {
        this.onChangePasswordEvent.fire((Object)new OnChangePasswordEvent(this, this.user));
    }

    void onAssignGroups() {
        UserImpl dummyUser = new UserImpl(this.user.getIdentifier(), (Collection)this.userAssignedRolesExplorer.getValue(), (Collection)this.userAssignedGroupsExplorer.getValue(), this.user.getProperties());
        if (this.isEditMode) {
            this.userAssignedGroupsEditor.edit((User)dummyUser);
        } else {
            this.userAssignedGroupsEditor.show((User)dummyUser);
        }
    }

    void onAssignRoles() {
        UserImpl dummyUser = new UserImpl(this.user.getIdentifier(), (Collection)this.userAssignedRolesExplorer.getValue(), (Collection)this.userAssignedGroupsExplorer.getValue(), this.user.getProperties());
        if (this.isEditMode) {
            this.userAssignedRolesEditor.edit((User)dummyUser);
        } else {
            this.userAssignedRolesEditor.show((User)dummyUser);
        }
    }

    protected void open(User user) {
        assert (user != null);
        this.user = user;
        String id = user.getIdentifier();
        this.view.setUsername(id);
        boolean canUpdate = this.canUpdate();
        boolean canDelete = this.canDelete();
        boolean canManageAttributes = this.canManageAttributes();
        boolean canChangePwd = this.canChangePassword();
        boolean canAssignGroups = this.canAssignGroups();
        boolean canAssignRoles = this.canAssignRoles();
        boolean hasAttributes = user.getProperties() != null && !user.getProperties().isEmpty();
        boolean shouldHideAttributesEditor = !canManageAttributes && !hasAttributes;
        this.view.setEditButtonVisible(!this.isEditMode && canUpdate);
        this.view.setDeleteButtonVisible(this.isEditMode && canDelete);
        this.view.setChangePasswordButtonVisible(this.isEditMode && canChangePwd);
        this.view.setAddToGroupsButtonVisible(this.isEditMode && canAssignGroups);
        this.view.setAddToRolesButtonVisible(this.isEditMode && canAssignRoles);
        this.view.setAttributesEditorVisible(!shouldHideAttributesEditor);
    }

    boolean canUpdate() {
        boolean canUpdate = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_UPDATE_USER);
        return canUpdate;
    }

    boolean canDelete() {
        boolean canDelete = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_DELETE_USER);
        return canDelete;
    }

    public boolean canAssignGroups() {
        boolean canAssignGroups = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_ASSIGN_GROUPS);
        return canAssignGroups;
    }

    public boolean canAssignRoles() {
        boolean canAssignRoles = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_ASSIGN_ROLES);
        return canAssignRoles;
    }

    boolean canChangePassword() {
        boolean canChangePassword = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_CHANGE_PASSWORD);
        return canChangePassword;
    }

    boolean canManageAttributes() {
        boolean canManageAttributes = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_MANAGE_ATTRIBUTES);
        return canManageAttributes;
    }

    void onOnUserGroupsUpdatedEvent(@Observes OnUpdateUserGroupsEvent onUpdateUserGroupsEvent) {
        if (this.checkEventContext(onUpdateUserGroupsEvent, this.userAssignedGroupsEditor)) {
            this.userAssignedGroupsEditor.flush();
            Object groups = this.userAssignedGroupsEditor.getValue();
            this.userAssignedGroupsExplorer.getValue().clear();
            this.userAssignedGroupsExplorer.getValue().addAll(groups);
            this.userAssignedGroupsExplorer.doShow();
        }
    }

    void onOnUserRolesUpdatedEvent(@Observes OnUpdateUserRolesEvent onUpdateUserRolesEvent) {
        if (this.checkEventContext(onUpdateUserRolesEvent, this.userAssignedRolesEditor)) {
            this.userAssignedRolesEditor.flush();
            Object roles = this.userAssignedRolesEditor.getValue();
            this.userAssignedRolesExplorer.getValue().clear();
            this.userAssignedRolesExplorer.getValue().addAll(roles);
            this.userAssignedRolesExplorer.doShow();
        }
    }

    private boolean checkEventContext(ContextualEvent contextualEvent, Object context) {
        return contextualEvent != null && contextualEvent.getContext() != null && contextualEvent.getContext().equals(context);
    }

    public static interface View
    extends UberView<UserEditor> {
        public View initWidgets(UserAttributesEditor.View var1, AssignedEntitiesExplorer var2, AssignedEntitiesEditor var3, AssignedEntitiesExplorer var4, AssignedEntitiesEditor var5, ACLViewer var6);

        public View setUsername(String var1);

        public View setEditButtonVisible(boolean var1);

        public View setDeleteButtonVisible(boolean var1);

        public View setChangePasswordButtonVisible(boolean var1);

        public View setAddToGroupsButtonVisible(boolean var1);

        public View setAddToRolesButtonVisible(boolean var1);

        public View setAttributesEditorVisible(boolean var1);

        public View setPermissionsVisible(boolean var1);
    }
}

