/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.NewUserAttributeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAttributesEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.UpdateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserAttributesEditorTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    EventSourceMock<CreateUserAttributeEvent> createUserAttributeEventEvent;
    @Mock
    EventSourceMock<UpdateUserAttributeEvent> updateUserAttributeEventEvent;
    @Mock
    EventSourceMock<DeleteUserAttributeEvent> deleteUserAttributeEventEvent;
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    NewUserAttributeEditor newUserAttributeEditor;
    @Mock
    UserAttributesEditor.View view;
    private UserAttributesEditor presenter;
    private UserManager.UserAttribute attribute;

    @Before
    public void setup() {
        Mockito.when((Object)this.newUserAttributeEditor.clear()).thenReturn((Object)this.newUserAttributeEditor);
        Mockito.when((Object)this.userSystemManager.isUserCapabilityEnabled((Capability)Matchers.any(Capability.class))).thenReturn((Object)true);
        this.attribute = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)this.attribute.getName()).thenReturn((Object)"attr1");
        Mockito.when((Object)this.attribute.getDefaultValue()).thenReturn((Object)"v1");
        Mockito.when((Object)this.attribute.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)this.attribute.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)this.userSystemManager.getUserSupportedAttribute("attr1")).thenReturn((Object)this.attribute);
        Mockito.when((Object)this.view.getColumnCount()).thenReturn((Object)0);
        this.presenter = new UserAttributesEditor(this.userSystemManager, this.confirmBox, this.createUserAttributeEventEvent, this.updateUserAttributeEventEvent, this.deleteUserAttributeEventEvent, this.errorEvent, this.newUserAttributeEditor, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((NewUserAttributeEditor.View)Matchers.any());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCanCreate(Matchers.anyBoolean());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showEmpty();
    }

    @Test
    public void testClear() {
        this.presenter.attributes = new HashMap();
        this.presenter.isEditMode = true;
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.attributes);
        Assert.assertFalse((boolean)this.presenter.isEditMode);
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((NewUserAttributeEditor.View)Matchers.any(NewUserAttributeEditor.View.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCanCreate(Matchers.anyBoolean());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showEmpty();
    }

    @Test
    public void testShow() {
        User user = (User)Mockito.mock(User.class);
        HashMap<String, String> attrs = new HashMap<String, String>(1);
        attrs.put("attr1", "value1");
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getProperties()).thenReturn(attrs);
        this.presenter.isEditMode = true;
        this.presenter.show(user);
        Assert.assertFalse((boolean)this.presenter.isEditMode);
        Assert.assertTrue((this.presenter.attributes.size() == 1 ? 1 : 0) != 0);
        ((NewUserAttributeEditor)Mockito.verify((Object)this.newUserAttributeEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((NewUserAttributeEditor)Mockito.verify((Object)this.newUserAttributeEditor, (VerificationMode)Mockito.times((int)1))).showAddButton();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCanCreate(false);
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(UserAttributesEditor.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((NewUserAttributeEditor.View)Matchers.any(NewUserAttributeEditor.View.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
    }

    @Test
    public void testEdit() {
        User user = (User)Mockito.mock(User.class);
        HashMap<String, String> attrs = new HashMap<String, String>(1);
        attrs.put("attr1", "value1");
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)user.getProperties()).thenReturn(attrs);
        this.presenter.isEditMode = false;
        this.presenter.edit(user);
        Assert.assertTrue((boolean)this.presenter.isEditMode);
        Assert.assertTrue((this.presenter.attributes.size() == 1 ? 1 : 0) != 0);
        ((NewUserAttributeEditor)Mockito.verify((Object)this.newUserAttributeEditor, (VerificationMode)Mockito.times((int)1))).clear();
        ((NewUserAttributeEditor)Mockito.verify((Object)this.newUserAttributeEditor, (VerificationMode)Mockito.times((int)1))).showAddButton();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCanCreate(true);
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(UserAttributesEditor.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((NewUserAttributeEditor.View)Matchers.any(NewUserAttributeEditor.View.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
    }

    @Test
    public void testGetValue() {
        UserManager.UserAttribute attribute1 = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)attribute1.getName()).thenReturn((Object)"attr1");
        Mockito.when((Object)attribute1.getDefaultValue()).thenReturn((Object)"v1");
        Mockito.when((Object)attribute1.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)attribute1.isMandatory()).thenReturn((Object)true);
        UserManager.UserAttribute attribute2 = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)attribute2.getName()).thenReturn((Object)"attr2");
        Mockito.when((Object)attribute2.getDefaultValue()).thenReturn((Object)"v2");
        Mockito.when((Object)attribute2.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)attribute2.isMandatory()).thenReturn((Object)true);
        HashMap<UserManager.UserAttribute, String> attrs = new HashMap<UserManager.UserAttribute, String>(1);
        attrs.put(attribute1, "value1");
        attrs.put(attribute2, "value2");
        this.presenter.attributes = attrs;
        Map result = this.presenter.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"value1", result.get("attr1"));
        Assert.assertEquals((Object)"value2", result.get("attr2"));
    }

    @Test
    public void testUpdateAttribute() {
        this.presenter.isEditMode = true;
        this.presenter.attributes = new HashMap();
        this.presenter.attributes.put(this.attribute, "value1");
        this.presenter.updateUserAttribute(0, "attr1", "value2");
        ((EventSourceMock)Mockito.verify(this.updateUserAttributeEventEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(UpdateUserAttributeEvent.class));
        Assert.assertTrue((this.presenter.attributes.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"value2", this.presenter.attributes.get(this.attribute));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCanCreate(Matchers.anyBoolean());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(UserAttributesEditor.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((NewUserAttributeEditor.View)Matchers.any(NewUserAttributeEditor.View.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
    }

    @Test
    public void testRemoveAttribute() {
        this.presenter.isEditMode = true;
        this.presenter.attributes = new HashMap();
        this.presenter.attributes.put(this.attribute, "value1");
        Map.Entry<String, String> entry = new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return "attr1";
            }

            @Override
            public String getValue() {
                return "value1";
            }

            @Override
            public String setValue(String value) {
                return null;
            }
        };
        this.presenter.removeUserAttribute(0, (Map.Entry)entry);
        ((EventSourceMock)Mockito.verify(this.deleteUserAttributeEventEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(DeleteUserAttributeEvent.class));
        Assert.assertTrue((boolean)this.presenter.attributes.isEmpty());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCanCreate(Matchers.anyBoolean());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(UserAttributesEditor.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((NewUserAttributeEditor.View)Matchers.any(NewUserAttributeEditor.View.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
    }

    @Test
    public void testOnAttributeCreated() {
        UserManager.UserAttribute attr2 = (UserManager.UserAttribute)Mockito.mock(UserManager.UserAttribute.class);
        Mockito.when((Object)attr2.getName()).thenReturn((Object)"attr2");
        Mockito.when((Object)attr2.getDefaultValue()).thenReturn((Object)"v2");
        Mockito.when((Object)attr2.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)attr2.isMandatory()).thenReturn((Object)true);
        Mockito.when((Object)this.userSystemManager.getUserSupportedAttribute("attr2")).thenReturn((Object)attr2);
        CreateUserAttributeEvent createUserAttributeEvent = (CreateUserAttributeEvent)Mockito.mock(CreateUserAttributeEvent.class);
        Map.Entry<String, String> entry = new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return "attr2";
            }

            @Override
            public String getValue() {
                return "value2";
            }

            @Override
            public String setValue(String value) {
                return null;
            }
        };
        Mockito.when((Object)createUserAttributeEvent.getAttribute()).thenReturn((Object)entry);
        this.presenter.attributes = new HashMap();
        this.presenter.onAttributeCreated(createUserAttributeEvent);
        Assert.assertTrue((this.presenter.attributes.size() == 1 ? 1 : 0) != 0);
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCanCreate(Matchers.anyBoolean());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).redraw();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getColumnCount();
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setColumnSortHandler((ColumnSortEvent.ListHandler)Matchers.any(ColumnSortEvent.ListHandler.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addColumn((Column)Matchers.any(Column.class), Matchers.anyString());
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(Matchers.any(UserAttributesEditor.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((NewUserAttributeEditor.View)Matchers.any(NewUserAttributeEditor.View.class));
        ((UserAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(Matchers.anyInt());
    }
}

