/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.PermissionTreeFactory;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;

@Dependent
public class ACLEditor
implements IsWidget {
    View view;
    PermissionWidgetFactory nodeWidgetFactory;
    PermissionTreeFactory permissionTreeFactory;
    PermissionTree permissionTree;
    List<PermissionNodeEditor> permissionNodeEditorList = new ArrayList<PermissionNodeEditor>();

    @Inject
    public ACLEditor(View view, PermissionWidgetFactory nodeWidgetFactory, PermissionTreeFactory permissionTreeFactory) {
        this.view = view;
        this.nodeWidgetFactory = nodeWidgetFactory;
        this.permissionTreeFactory = permissionTreeFactory;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public PermissionCollection getPermissions() {
        DefaultPermissionCollection pc = new DefaultPermissionCollection();
        this.collect((PermissionCollection)pc, this.permissionNodeEditorList);
        return pc;
    }

    private void collect(PermissionCollection pc, List<PermissionNodeEditor> nodeEditors) {
        if (nodeEditors != null) {
            for (PermissionNodeEditor nodeEditor : nodeEditors) {
                for (Permission p : nodeEditor.getPermissionNode().getPermissionList()) {
                    pc.add(new Permission[]{p});
                }
                this.collect(pc, nodeEditor.getChildEditors());
            }
        }
    }

    public void edit(Role role) {
        this.edit(this.permissionTreeFactory.createPermissionTree(role));
    }

    public void edit(Group group) {
        this.edit(this.permissionTreeFactory.createPermissionTree(group));
    }

    private void edit(PermissionTree tree) {
        this.permissionTree = tree;
        this.view.clear();
        this.permissionNodeEditorList.clear();
        List rootNodeList = tree.getRootNodes();
        for (PermissionNode rootNode : rootNodeList) {
            PermissionNodeEditor rootNodeEditor = this.nodeWidgetFactory.createEditor(rootNode);
            rootNodeEditor.setACLEditor(this);
            rootNodeEditor.edit(rootNode);
            this.view.addRootNodeWidget(rootNodeEditor);
            this.permissionNodeEditorList.add(rootNodeEditor);
        }
    }

    public static interface View
    extends UberView<ACLEditor> {
        public void clear();

        public void addRootNodeWidget(IsWidget var1);
    }
}

