/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.form.error.BasicEditorError;
import org.gwtbootstrap3.client.ui.form.validator.Validator;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.ChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ChangePassword
implements IsWidget {
    final Validator<String> passwordValidator = new Validator<String>(){

        public int getPriority() {
            return 0;
        }

        public List<EditorError> validate(Editor<String> editor, String value) {
            ArrayList<EditorError> result = new ArrayList<EditorError>();
            if (value == null || value.trim().length() == 0) {
                result.add((EditorError)new BasicEditorError(editor, (Object)value, UsersManagementWidgetsConstants.INSTANCE.passwordCannotBeEmpty()));
            }
            return result;
        }
    };
    public View view;
    ClientUserSystemManager userSystemManager;
    Event<NotificationEvent> workbenchNotification;
    Event<OnErrorEvent> errorEvent;
    Event<ChangePasswordEvent> changePasswordEvent;
    String username = null;
    ChangePasswordCallback callback;

    @Inject
    public ChangePassword(ClientUserSystemManager userSystemManager, Event<NotificationEvent> workbenchNotification, Event<OnErrorEvent> errorEvent, Event<ChangePasswordEvent> changePasswordEvent, View view) {
        this.userSystemManager = userSystemManager;
        this.errorEvent = errorEvent;
        this.workbenchNotification = workbenchNotification;
        this.changePasswordEvent = changePasswordEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.configure(this.passwordValidator, this.passwordValidator);
    }

    public void show(String username) {
        this.clear();
        this.username = username;
        this.callback = null;
        this.view.show(UsersManagementWidgetsConstants.INSTANCE.changePasswordFor() + " " + username);
    }

    public void show(String username, ChangePasswordCallback callback) {
        this.clear();
        this.username = username;
        this.callback = callback;
        this.view.show(UsersManagementWidgetsConstants.INSTANCE.changePasswordFor() + " " + username);
    }

    public void clear() {
        this.username = null;
        this.callback = null;
        this.view.clear();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    boolean validatePasswordsMatch(String p1, String p2) {
        boolean valid;
        boolean bl = valid = p1 != null && p1.equals(p2);
        if (!valid) {
            this.showErrorMessage(UsersManagementWidgetsConstants.INSTANCE.passwordsNotMatch());
        }
        return valid;
    }

    void onUpdatePassword(String newPassword, final Command callback) {
        this.userSystemManager.users((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void group) {
                ChangePassword.this.changePasswordEvent.fire((Object)new ChangePasswordEvent(this));
                ChangePassword.this.workbenchNotification.fire((Object)new NotificationEvent(UsersManagementWidgetsConstants.INSTANCE.passwordUpdatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                if (callback != null) {
                    callback.execute();
                }
                if (ChangePassword.this.callback != null) {
                    ChangePassword.this.callback.onPasswordUpdated();
                }
                ChangePassword.this.view.hide();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                if (throwable != null) {
                    ChangePassword.this.showError(throwable);
                } else {
                    ChangePassword.this.showErrorMessage(message.getSubject());
                }
                if (callback != null) {
                    callback.execute();
                }
                if (ChangePassword.this.callback != null) {
                    ChangePassword.this.callback.onError(throwable);
                }
                return false;
            }
        }).changePassword(this.username, newPassword);
    }

    void showErrorMessage(String message) {
        this.showError((Throwable)new SecurityManagementException(message));
    }

    void showError(Throwable throwable) {
        this.errorEvent.fire((Object)new OnErrorEvent(this, throwable));
    }

    public static interface View
    extends UberView<ChangePassword> {
        public View configure(Validator<String> var1, Validator<String> var2);

        public View show(String var1);

        public View hide();

        public View clear();
    }

    public static interface ChangePasswordCallback {
        public void onPasswordUpdated();

        public void onError(Throwable var1);
    }
}

