/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.BasePermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeViewer;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.PermissionNode;

@Dependent
public class LeafPermissionNodeViewer
extends BasePermissionNodeViewer {
    View view;
    PermissionNode permissionNode;

    @Inject
    public LeafPermissionNodeViewer(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public PermissionNode getPermissionNode() {
        return this.permissionNode;
    }

    @Override
    public List<PermissionNodeViewer> getChildren() {
        return null;
    }

    @Override
    public void show(PermissionNode node) {
        this.permissionNode = node;
        String name = node.getNodeName();
        String fullName = node.getNodeFullName();
        this.view.setNodeName(name);
        if (fullName != null && !fullName.equals(name)) {
            this.view.setNodeFullName(fullName);
        }
        for (Permission permission : this.permissionNode.getPermissionList()) {
            if (AuthorizationResult.ACCESS_GRANTED.equals((Object)permission.getResult())) {
                String granted = node.getPermissionGrantName(permission).toLowerCase();
                this.view.permissionGranted(granted);
                continue;
            }
            String denied = node.getPermissionDenyName(permission).toLowerCase();
            this.view.permissionDenied(denied);
        }
    }

    public static interface View
    extends UberView<LeafPermissionNodeViewer> {
        public void setNodeName(String var1);

        public void setNodeFullName(String var1);

        public void permissionGranted(String var1);

        public void permissionDenied(String var1);
    }
}

