/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.LeafPermissionNodeViewer;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;

@RunWith(value=MockitoJUnitRunner.class)
public class LeafPermissionNodeViewerTest {
    @Mock
    LeafPermissionNodeViewer.View view;
    @Mock
    Permission permission1;
    @Mock
    Permission permission2;
    LeafPermissionNodeViewer presenter;
    PermissionLeafNode permissionNode;

    @Before
    public void setUp() {
        this.presenter = new LeafPermissionNodeViewer(this.view);
        Mockito.when((Object)this.permission1.getResult()).thenReturn((Object)AuthorizationResult.ACCESS_DENIED);
        Mockito.when((Object)this.permission1.getName()).thenReturn((Object)"p1");
        Mockito.when((Object)this.permission2.getResult()).thenReturn((Object)AuthorizationResult.ACCESS_GRANTED);
        Mockito.when((Object)this.permission2.getName()).thenReturn((Object)"p2");
        this.permissionNode = new PermissionLeafNode();
        this.permissionNode.setNodeName("r1");
        this.permissionNode.setNodeFullName("r1 full");
        this.permissionNode.addPermission(this.permission1, "grant1", "deny1");
        this.permissionNode.addPermission(this.permission2, "grant2", "deny2");
        this.presenter.show((PermissionNode)this.permissionNode);
    }

    @Test
    public void testShow() {
        Assert.assertNull((Object)this.presenter.getChildren());
        Assert.assertEquals((Object)this.presenter.getPermissionNode(), (Object)this.permissionNode);
        ((LeafPermissionNodeViewer.View)Mockito.verify((Object)this.view)).setNodeName("r1");
        ((LeafPermissionNodeViewer.View)Mockito.verify((Object)this.view)).setNodeFullName("r1 full");
        ((LeafPermissionNodeViewer.View)Mockito.verify((Object)this.view)).permissionDenied("deny1");
        ((LeafPermissionNodeViewer.View)Mockito.verify((Object)this.view)).permissionGranted("grant2");
        ((LeafPermissionNodeViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).permissionGranted("grant1");
        ((LeafPermissionNodeViewer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).permissionDenied("deny2");
    }
}

