/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Group;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.CreateEntity;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.GroupUsersAssignment;
import org.uberfire.ext.security.management.client.widgets.management.editor.group.workflow.GroupCreationWorkflow;
import org.uberfire.ext.security.management.client.widgets.management.editor.workflow.EntityWorkflowView;
import org.uberfire.ext.security.management.client.widgets.management.events.AddUsersToGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.ext.security.management.client.widgets.popup.LoadingBox;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class GroupCreationWorkflowTest
extends AbstractSecurityManagementTest {
    @Mock
    EventSourceMock<OnErrorEvent> errorEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    LoadingBox loadingBox;
    @Mock
    CreateEntity createEntity;
    @Mock
    GroupUsersAssignment groupUsersAssignment;
    @Mock
    EventSourceMock<CreateGroupEvent> onCreateGroupEvent;
    @Mock
    EntityWorkflowView view;
    @Mock
    Group group;
    private GroupCreationWorkflow tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.group.getName()).thenReturn((Object)"group1");
        Mockito.when((Object)this.view.setWidget((IsWidget)Matchers.any(IsWidget.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.clearNotifications()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class))).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setCancelButtonVisible(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonEnabled(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonVisible(Matchers.anyBoolean())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.setSaveButtonText(Matchers.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.showNotification(Matchers.anyString())).thenReturn((Object)this.view);
        Mockito.when((Object)this.groupsManagerService.get(Matchers.anyString())).thenReturn((Object)this.group);
        GroupManagerSettings settings = (GroupManagerSettings)Mockito.mock(GroupManagerSettings.class);
        Mockito.when((Object)settings.allowEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.userSystemManager.getGroupManagerSettings()).thenReturn((Object)settings);
        this.tested = new GroupCreationWorkflow(this.userSystemManager, this.errorEvent, this.confirmBox, this.loadingBox, (Event)this.workbenchNotification, this.createEntity, this.groupUsersAssignment, this.onCreateGroupEvent, this.view);
    }

    @Test
    public void testClear() {
        this.tested.group = this.group;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.group);
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).clear();
        ((GroupUsersAssignment)Mockito.verify((Object)this.groupUsersAssignment, (VerificationMode)Mockito.times((int)1))).clear();
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCancelButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonVisible(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setSaveButtonEnabled(Matchers.anyBoolean());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showNotification(Matchers.anyString());
    }

    @Test
    public void testShowError() {
        this.tested.showErrorMessage("error1");
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnErrorEvent.class));
    }

    @Test
    public void testCreate() {
        this.tested.create();
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
    }

    @Test
    public void testShowUsersAssignment() {
        this.tested.group = this.group;
        this.tested.showUsersAssignment(this.group.getName());
        ((GroupUsersAssignment)Mockito.verify((Object)this.groupUsersAssignment, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearNotifications();
    }

    @Test
    public void testCheckCreateExisting() {
        Mockito.when((Object)this.groupsManagerService.get(Matchers.anyString())).thenReturn((Object)this.group);
        Mockito.when((Object)this.createEntity.getEntityIdentifier()).thenReturn((Object)"group1");
        this.tested.checkCreate();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnErrorEvent.class));
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).setErrorState();
    }

    @Test
    public void testCheckCreateConstrainedGroup() {
        ArrayList<String> cGroups = new ArrayList<String>(1);
        cGroups.add("admin");
        Mockito.when((Object)this.userSystemManager.getConstrainedGroups()).thenReturn(cGroups);
        Mockito.when((Object)this.createEntity.getEntityIdentifier()).thenReturn((Object)"admin");
        this.tested.checkCreate();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnErrorEvent.class));
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).setErrorState();
    }

    @Test
    public void testCreateGroup() {
        ((ConfirmBox)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Command noCommand = (Command)invocationOnMock.getArguments()[3];
                noCommand.execute();
                return null;
            }
        }).when((Object)this.confirmBox)).show(Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class));
        this.tested.createGroup("group1");
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)2))).clear();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((ConfirmBox)Mockito.verify((Object)this.confirmBox, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (Command)Matchers.any(Command.class));
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.onCreateGroupEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(CreateGroupEvent.class));
    }

    @Test
    public void testOnAssignUsers() {
        AddUsersToGroupEvent addUsersToGroupEvent = (AddUsersToGroupEvent)Mockito.mock(AddUsersToGroupEvent.class);
        HashSet<String> users = new HashSet<String>(1);
        users.add("user1");
        Mockito.when((Object)addUsersToGroupEvent.getContext()).thenReturn((Object)this.groupUsersAssignment);
        Mockito.when((Object)addUsersToGroupEvent.getUsers()).thenReturn(users);
        this.tested.group = this.group;
        this.tested.onAssignUsers(addUsersToGroupEvent);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.onCreateGroupEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(CreateGroupEvent.class));
        ((CreateEntity)Mockito.verify((Object)this.createEntity, (VerificationMode)Mockito.times((int)1))).show(Matchers.anyString(), Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCancelButtonVisible(false);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCallback((EntityWorkflowView.Callback)Matchers.any(EntityWorkflowView.Callback.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonText(Matchers.anyString());
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonVisible(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSaveButtonEnabled(true);
        ((EntityWorkflowView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNotifications();
    }
}

