/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.PriorityDropDown;
import org.uberfire.ext.security.management.client.widgets.management.events.HomePerspectiveChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PriorityChangedEvent;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;

@Dependent
public class ACLSettings
implements IsWidget {
    View view;
    PermissionManager permissionManager;
    PerspectiveDropDown homePerspectiveDropDown;
    PerspectiveTreeProvider perspectiveTreeProvider;
    PriorityDropDown priorityDropDown;
    Event<HomePerspectiveChangedEvent> homePerspectiveChangedEvent;
    Event<PriorityChangedEvent> priorityChangedEvent;
    AuthorizationPolicy authzPolicy;
    boolean isEditMode;

    @Inject
    public ACLSettings(View view, PermissionManager permissionManager, PerspectiveDropDown homePerspectiveDropDown, PerspectiveTreeProvider perspectiveTreeProvider, PriorityDropDown priorityDropDown, Event<HomePerspectiveChangedEvent> homePerspectiveChangedEvent, Event<PriorityChangedEvent> priorityChangedEvent) {
        this.view = view;
        this.permissionManager = permissionManager;
        this.homePerspectiveDropDown = homePerspectiveDropDown;
        this.perspectiveTreeProvider = perspectiveTreeProvider;
        this.priorityDropDown = priorityDropDown;
        this.homePerspectiveChangedEvent = homePerspectiveChangedEvent;
        this.priorityChangedEvent = priorityChangedEvent;
        this.authzPolicy = permissionManager.getAuthorizationPolicy();
        homePerspectiveDropDown.setMaxItems(50);
        homePerspectiveDropDown.setOnChange(this::onHomePerspectiveSelected);
        homePerspectiveDropDown.setPerspectiveNameProvider(arg_0 -> ((PerspectiveTreeProvider)perspectiveTreeProvider).getPerspectiveName(arg_0));
        homePerspectiveDropDown.setPerspectiveIdsExcluded(perspectiveTreeProvider.getPerspectiveIdsExcluded());
        view.setHomePerspectiveSelector((IsWidget)homePerspectiveDropDown);
        priorityDropDown.setOnChange(this::onPrioritySelected);
        view.setPrioritySelector(priorityDropDown);
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public PerspectiveActivity getHomePerspective() {
        return this.homePerspectiveDropDown.getSelectedPerspective();
    }

    public int getPriority() {
        return this.priorityDropDown.getSelectedPriority();
    }

    public void show(Role role) {
        this.isEditMode = false;
        this.open(role);
    }

    public void show(Group group) {
        this.isEditMode = false;
        this.open(group);
    }

    public void edit(Role role) {
        this.isEditMode = true;
        this.open(role);
    }

    public void edit(Group group) {
        this.isEditMode = true;
        this.open(group);
    }

    private void open(Role role) {
        String homePerspectiveId = this.authzPolicy.getHomePerspective(role);
        int priority = this.authzPolicy.getPriority(role);
        this.open(homePerspectiveId, priority);
    }

    private void open(Group group) {
        String homePerspectiveId = this.authzPolicy.getHomePerspective(group);
        int priority = this.authzPolicy.getPriority(group);
        this.open(homePerspectiveId, priority);
    }

    private void open(String homePerspectiveId, int priority) {
        if (homePerspectiveId == null) {
            homePerspectiveId = this.homePerspectiveDropDown.getDefaultPerspective().getIdentifier();
        }
        this.view.setHomePerspectiveSelectorEnabled(this.isEditMode);
        this.view.setPrioritySelectorEnabled(this.isEditMode);
        if (this.isEditMode) {
            if (homePerspectiveId != null) {
                this.homePerspectiveDropDown.setSelectedPerspective(homePerspectiveId);
            }
            this.priorityDropDown.setSelectedPriority(priority);
        } else {
            if (homePerspectiveId != null) {
                String itemName = this.homePerspectiveDropDown.getItemName(homePerspectiveId);
                this.view.setHomePerspectiveName(itemName);
                this.view.setHomePerspectiveTitle(homePerspectiveId);
            } else {
                this.view.setNoHomePerspectiveDefined();
            }
            this.view.setPriorityName(this.priorityDropDown.getPriorityName(priority));
        }
    }

    void onHomePerspectiveSelected() {
        PerspectiveActivity p = this.getHomePerspective();
        this.homePerspectiveChangedEvent.fire((Object)new HomePerspectiveChangedEvent(this, p));
    }

    void onPrioritySelected() {
        int priority = this.getPriority();
        this.priorityChangedEvent.fire((Object)new PriorityChangedEvent(this, priority));
    }

    public static interface View
    extends UberView<ACLSettings> {
        public View setHomePerspectiveName(String var1);

        public View setHomePerspectiveTitle(String var1);

        public View setHomePerspectiveSelectorEnabled(boolean var1);

        public View setHomePerspectiveSelector(IsWidget var1);

        public View setNoHomePerspectiveDefined();

        public View setPriorityName(String var1);

        public View setPrioritySelectorEnabled(boolean var1);

        public View setPrioritySelector(IsWidget var1);
    }
}

