/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management;

import com.google.gwt.editor.client.Editor;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.api.service.UserManagerService;
import org.uberfire.ext.security.management.client.widgets.management.AbstractSecurityManagementTest;
import org.uberfire.ext.security.management.client.widgets.management.ChangePassword;
import org.uberfire.ext.security.management.client.widgets.management.events.ChangePasswordEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ChangePasswordTest
extends AbstractSecurityManagementTest {
    @Mock
    EventSourceMock<ChangePasswordEvent> changePasswordEvent;
    @Mock
    EventSourceMock<OnErrorEvent> onErrorEvent;
    @Mock
    ChangePassword.View view;
    private ChangePassword presenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.presenter = new ChangePassword(this.userSystemManager, (Event)this.workbenchNotification, this.onErrorEvent, this.changePasswordEvent, this.view);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClear() throws Exception {
        this.presenter.clear();
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString());
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hide();
        Assert.assertNull((Object)this.presenter.username);
        Assert.assertNull((Object)this.presenter.callback);
    }

    @Test
    public void testShowError() throws Exception {
        String error = "error1";
        this.presenter.showError(error);
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).show(Mockito.anyString());
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hide();
        ((EventSourceMock)Mockito.verify(this.onErrorEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(OnErrorEvent.class));
    }

    @Test
    public void testShow() throws Exception {
        this.presenter.show("user1");
        junit.framework.Assert.assertEquals((String)this.presenter.username, (String)"user1");
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show(Mockito.anyString());
    }

    @Test
    public void testPasswordValidator() throws Exception {
        List errors = this.presenter.passwordValidator.validate((Editor)Mockito.mock(Editor.class), (Object)"password1");
        Assert.assertTrue((boolean)errors.isEmpty());
        errors = this.presenter.passwordValidator.validate((Editor)Mockito.mock(Editor.class), (Object)"");
        Assert.assertFalse((boolean)errors.isEmpty());
    }

    @Test
    public void testValidatePasswordMatch() throws Exception {
        Assert.assertTrue((boolean)this.presenter.validatePasswordsMatch("password1", "password1"));
        Assert.assertFalse((boolean)this.presenter.validatePasswordsMatch("password1", "password2"));
    }

    @Test
    public void testUpdatePassword() throws Exception {
        String newPassw = "new-password";
        Command callback = (Command)Mockito.mock(Command.class);
        ChangePassword.ChangePasswordCallback changePasswordCallback = (ChangePassword.ChangePasswordCallback)Mockito.mock(ChangePassword.ChangePasswordCallback.class);
        this.presenter.username = "user";
        this.presenter.callback = changePasswordCallback;
        this.presenter.onUpdatePassword("new-password", callback);
        ((UserManagerService)Mockito.verify((Object)this.userManagerService, (VerificationMode)Mockito.times((int)1))).changePassword(this.presenter.username, "new-password");
        ((EventSourceMock)Mockito.verify(this.changePasswordEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(ChangePasswordEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.workbenchNotification, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((Command)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).execute();
        ((ChangePassword.ChangePasswordCallback)Mockito.verify((Object)changePasswordCallback, (VerificationMode)Mockito.times((int)1))).onPasswordUpdated();
        ((ChangePassword.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
    }
}

