/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.Container;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.InputGroup;
import org.gwtbootstrap3.client.ui.InputGroupButton;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.properties.editor.client.PropertyEditorItemsWidget;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.fields.PropertyEditorFieldType;
import org.uberfire.ext.properties.editor.client.widgets.AbstractPropertyEditorWidget;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemLabel;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemWidget;
import org.uberfire.ext.properties.editor.model.CustomPropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

public class PropertyEditorHelper {
    public static void extractEditorFrom(PropertyEditorWidget propertyEditorWidget, PanelGroup propertyMenu, PropertyEditorEvent event, String propertyNameFilter) {
        propertyMenu.clear();
        for (PropertyEditorCategory category : event.getSortedProperties()) {
            PropertyEditorHelper.createCategory(propertyEditorWidget, propertyMenu, category, propertyNameFilter);
        }
    }

    static void createCategory(PropertyEditorWidget propertyEditorWidget, PanelGroup propertyMenu, PropertyEditorCategory category, String propertyNameFilter) {
        Panel panel = (Panel)GWT.create(Panel.class);
        PanelCollapse panelCollapse = PropertyEditorHelper.createPanelCollapse(propertyEditorWidget, category);
        PanelHeader headerPanel = PropertyEditorHelper.createPanelHeader(category, propertyMenu, panelCollapse);
        PanelBody panelBody = PropertyEditorHelper.createPanelBody();
        Form form = PropertyEditorHelper.createPanelContent(panelBody);
        boolean categoryHasActiveChilds = false;
        for (PropertyEditorFieldInfo field : category.getFields()) {
            if (!PropertyEditorHelper.isAMatchOfFilter(propertyNameFilter, field)) continue;
            categoryHasActiveChilds = true;
            form.add((Widget)PropertyEditorHelper.createItemsWidget(field, category, form));
        }
        if (categoryHasActiveChilds) {
            panelCollapse.add((Widget)panelBody);
            panel.add((Widget)headerPanel);
            panel.add((Widget)panelCollapse);
            propertyMenu.add((Widget)panel);
        }
    }

    static PanelHeader createPanelHeader(PropertyEditorCategory category, PanelGroup propertyMenu, PanelCollapse panelCollapse) {
        Heading heading = new Heading(HeadingSize.H4);
        Anchor anchor = (Anchor)GWT.create(Anchor.class);
        anchor.setText(category.getName());
        anchor.setDataToggle(Toggle.COLLAPSE);
        anchor.setDataParent(propertyMenu.getId());
        anchor.setDataTargetWidget((Widget)panelCollapse);
        anchor.addStyleName("collapsed");
        heading.add((Widget)anchor);
        PanelHeader header = (PanelHeader)GWT.create(PanelHeader.class);
        header.add((Widget)heading);
        return header;
    }

    static PanelCollapse createPanelCollapse(PropertyEditorWidget propertyEditorWidget, PropertyEditorCategory category) {
        PanelCollapse collapse = (PanelCollapse)GWT.create(PanelCollapse.class);
        collapse.addShowHandler(showEvent -> propertyEditorWidget.addExpandedCategory(category.getName()));
        collapse.addHiddenHandler(hiddenEvent -> {
            hiddenEvent.stopPropagation();
            propertyEditorWidget.collapseCategory(category.getName());
        });
        if (propertyEditorWidget.getExpandedCategories().contains(category.getName())) {
            collapse.setIn(true);
        }
        return collapse;
    }

    private static Form createPanelContent(PanelBody panelBody) {
        Container container = (Container)GWT.create(Container.class);
        container.setFluid(true);
        Row row = (Row)GWT.create(Row.class);
        Column column = new Column(ColumnSize.MD_12, new ColumnSize[0]);
        Form form = (Form)GWT.create(Form.class);
        form.setType(FormType.HORIZONTAL);
        container.add((Widget)row);
        row.add((Widget)column);
        column.add((Widget)form);
        panelBody.add((Widget)container);
        return form;
    }

    private static PanelBody createPanelBody() {
        return (PanelBody)GWT.create(PanelBody.class);
    }

    public static void extractEditorFrom(PropertyEditorWidget propertyEditorWidget, PanelGroup propertyMenu, PropertyEditorEvent event) {
        PropertyEditorHelper.extractEditorFrom(propertyEditorWidget, propertyMenu, event, "");
    }

    static PropertyEditorItemsWidget createItemsWidget(PropertyEditorFieldInfo field, PropertyEditorCategory category, Form panelBody) {
        PropertyEditorItemsWidget items = (PropertyEditorItemsWidget)((Object)GWT.create(PropertyEditorItemsWidget.class));
        items.add((Widget)PropertyEditorHelper.createLabel(field));
        items.add((Widget)PropertyEditorHelper.createField(field, items, category, panelBody));
        return items;
    }

    static PropertyEditorItemLabel createLabel(PropertyEditorFieldInfo field) {
        PropertyEditorItemLabel item = (PropertyEditorItemLabel)((Object)GWT.create(PropertyEditorItemLabel.class));
        item.setText(field.getLabel());
        item.setFor(String.valueOf(field.hashCode()));
        if (field.hasHelpInfo()) {
            item.setHelpTitle(field.getHelpHeading());
            item.setHelpContent(field.getHelpText());
        }
        return item;
    }

    static PropertyEditorItemWidget createField(PropertyEditorFieldInfo field, PropertyEditorItemsWidget parent, PropertyEditorCategory category, Form panelBody) {
        Widget fieldWidget;
        PropertyEditorItemWidget itemWidget = (PropertyEditorItemWidget)((Object)GWT.create(PropertyEditorItemWidget.class));
        InputGroup content = (InputGroup)GWT.create(InputGroup.class);
        PropertyEditorFieldType editorFieldType = PropertyEditorFieldType.getFieldTypeFrom(field);
        if (editorFieldType == PropertyEditorFieldType.CUSTOM) {
            Class widgetClass = ((CustomPropertyEditorFieldInfo)field).getCustomEditorClass();
            fieldWidget = PropertyEditorHelper.getWidget(field, widgetClass);
        } else {
            fieldWidget = editorFieldType.widget(field);
        }
        PropertyEditorHelper.createErrorHandlingInfraStructure(parent, fieldWidget);
        content.add(fieldWidget);
        if (field.isRemovalSupported()) {
            content.add((Widget)PropertyEditorHelper.createRemoveAddOn(field, category, parent, panelBody));
        }
        itemWidget.add((Widget)content);
        return itemWidget;
    }

    private static InputGroupButton createRemoveAddOn(final PropertyEditorFieldInfo field, final PropertyEditorCategory category, final PropertyEditorItemsWidget parent, final Form categoryPanel) {
        InputGroupButton groupButton = (InputGroupButton)GWT.create(InputGroupButton.class);
        Button button = (Button)GWT.create(Button.class);
        button.setIcon(IconType.MINUS);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                category.getFields().remove(field);
                categoryPanel.remove((Widget)parent);
            }
        });
        groupButton.add((Widget)button);
        return groupButton;
    }

    private static Widget getWidget(PropertyEditorFieldInfo property, Class fieldType) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        SyncBeanDef iocBeanDef = beanManager.lookupBean(fieldType, new Annotation[0]);
        AbstractField field = (AbstractField)iocBeanDef.getInstance();
        return field.widget(property);
    }

    static void createErrorHandlingInfraStructure(PropertyEditorItemsWidget parent, Widget widget) {
        AbstractPropertyEditorWidget abstractPropertyEditorWidget = (AbstractPropertyEditorWidget)widget;
        abstractPropertyEditorWidget.setParent(parent);
    }

    public static boolean validade(PropertyEditorEvent event) {
        if (event == null) {
            throw new NullEventException("Event should not be null,");
        }
        if (event.getSortedProperties().isEmpty()) {
            throw new NoPropertiesException("Event should not have empty properties.");
        }
        return event != null && !event.getSortedProperties().isEmpty();
    }

    static boolean isAMatchOfFilter(String propertyNameFilter, PropertyEditorFieldInfo field) {
        if (propertyNameFilter.isEmpty()) {
            return true;
        }
        return field.getLabel().toUpperCase().contains(propertyNameFilter.toUpperCase());
    }

    public static class NoPropertiesException
    extends RuntimeException {
        public NoPropertiesException() {
        }

        public NoPropertiesException(String message) {
            super(message);
        }
    }

    public static class NullEventException
    extends RuntimeException {
        public NullEventException() {
        }

        public NullEventException(String message) {
            super(message);
        }
    }
}

