/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ProvidesKey;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;
import org.uberfire.ext.widgets.common.client.tables.UberfireSimplePager;

public class PagedTable<T>
extends SimpleTable<T> {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private int pageSize;
    private AbstractDataProvider<T> dataProvider;
    @UiField
    public UberfireSimplePager pager;
    @UiField
    public ListBox pageSizesSelector;
    protected boolean showPageSizesSelector = false;

    public PagedTable() {
        this(10);
    }

    public PagedTable(int pageSize) {
        this(pageSize, null);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey) {
        this(pageSize, providesKey, null);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences) {
        this(pageSize, providesKey, gridGlobalPreferences, false);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences, boolean showPageSizesSelector) {
        this(pageSize, providesKey, gridGlobalPreferences, showPageSizesSelector, false, false);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences, boolean showPageSizesSelector, boolean showFFButton, boolean showLButton) {
        super(providesKey, gridGlobalPreferences);
        this.showPageSizesSelector = showPageSizesSelector;
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        this.setSelectedValue(this.pageSizesSelector, String.valueOf(pageSize));
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.pageSizesSelector.setVisible(this.showPageSizesSelector);
        this.setShowFastFordwardPagerButton(showFFButton);
        this.setShowLastPagerButton(showLButton);
        this.createPageSizesListBox(5, 20, 5);
    }

    private void setSelectedValue(ListBox listbox, String value) {
        for (int i = 0; i < listbox.getItemCount(); ++i) {
            if (!listbox.getValue(i).equals(value)) continue;
            listbox.setSelectedIndex(i);
            return;
        }
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public void setDataProvider(AbstractDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.addDataDisplay((HasData)this);
    }

    public AbstractDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStart() {
        return this.pager.getPageStart();
    }

    public final void loadPageSizePreferences() {
        this.pageSize = this.getPageSizeStored();
        this.dataGrid.setPageSize(this.pageSize);
        this.pager.setPageSize(this.pageSize);
        this.dataGrid.setHeight((this.pageSize == 0 ? 1 : this.pageSize) * 30 + 10 + "px");
    }

    public void createPageSizesListBox(int minPageSize, int maxPageSize, int incPageSize) {
        this.pageSizesSelector.clear();
        block0: for (int i = minPageSize; i <= maxPageSize; i += incPageSize) {
            this.pageSizesSelector.addItem(String.valueOf(i) + " " + CommonConstants.INSTANCE.Items(), String.valueOf(i));
            if (i != this.pageSize) continue;
            for (int z = 0; z < this.pageSizesSelector.getItemCount(); ++z) {
                if (!this.pageSizesSelector.getValue(z).equals(String.valueOf(i))) continue;
                this.pageSizesSelector.setSelectedIndex(z);
                continue block0;
            }
        }
        this.pageSizesSelector.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                PagedTable.this.storePageSizeInGridPreferences(Integer.parseInt(PagedTable.this.pageSizesSelector.getSelectedValue()));
                PagedTable.this.loadPageSizePreferences();
            }
        });
        this.loadPageSizePreferences();
    }

    private void storePageSizeInGridPreferences(int pageSize) {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            gridPreferencesStore.setPageSizePreferences(pageSize);
            super.saveGridPreferences();
        }
        this.pageSize = pageSize;
    }

    private int getPageSizeStored() {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            return gridPreferencesStore.getPageSizePreferences();
        }
        return this.pageSize;
    }

    private void resetPageSize() {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            gridPreferencesStore.resetPageSizePreferences();
            this.storePageSizeInGridPreferences(gridPreferencesStore.getGlobalPreferences().getPageSize());
            this.loadPageSizePreferences();
        }
    }

    public void setShowLastPagerButton(boolean showLastPagerButton) {
        this.pager.setShowLastPageButton(showLastPagerButton);
    }

    public void setShowFastFordwardPagerButton(boolean showFastFordwardPagerButton) {
        this.pager.setShowFastFordwardPageButton(showFastFordwardPagerButton);
    }

    static interface Binder
    extends UiBinder<Widget, PagedTable> {
    }
}

