/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common.popups;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.shared.event.ModalShowEvent;
import org.gwtbootstrap3.client.shared.event.ModalShowHandler;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.base.button.CloseButton;
import org.gwtbootstrap3.client.ui.base.modal.ModalContent;
import org.gwtbootstrap3.client.ui.base.modal.ModalDialog;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;

public class BaseModal
extends Modal {
    private ModalBody body;

    public BaseModal() {
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setDataKeyboard(true);
        this.setRemoveOnHide(true);
        this.setHideOtherModals(false);
        this.setShowHandler();
        this.setKeyPressHandler();
        this.getElement().setId("panel-id");
        this.addShowHandler(new ModalShowHandler(){

            public void onShow(ModalShowEvent evt) {
                Modal modal = evt.getModal();
                modal.getElement().setAttribute("maxHeight", "100px");
                modal.getElement().setAttribute("overflowY", "scroll");
            }
        });
    }

    public void show() {
        super.show();
    }

    private void setKeyPressHandler() {
        this.addDomHandler((EventHandler)this.getEnterDomHandler(), KeyDownEvent.getType());
    }

    protected KeyDownHandler getEnterDomHandler() {
        return new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13 && BaseModal.this.handleDefaultAction()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        };
    }

    private void setShowHandler() {
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent shownEvent) {
                BaseModal.this.setFocus((HasWidgets)BaseModal.this, Boolean.FALSE);
            }
        });
    }

    protected boolean setFocus(HasWidgets container, Boolean found) {
        for (Widget w : container) {
            if (w instanceof CloseButton) continue;
            if (w instanceof Focusable) {
                ((Focusable)w).setFocus(true);
                found = true;
            } else if (w instanceof HasWidgets) {
                found = this.setFocus((HasWidgets)w, found);
            }
            if (!Boolean.TRUE.equals(found)) continue;
            break;
        }
        return found;
    }

    protected boolean handleDefaultAction() {
        return this.handleDefaultAction(this);
    }

    protected <T extends ComplexPanel> boolean handleDefaultAction(T panel) {
        for (int i = 0; i < panel.getWidgetCount(); ++i) {
            Widget w = panel.getWidget(i);
            if (w instanceof ModalFooter) {
                return this.handleModalFooter((ModalFooter)w);
            }
            if (w instanceof ModalDialog) {
                return this.handleDefaultAction((ModalDialog)w);
            }
            if (!(w instanceof ModalContent)) continue;
            return this.handleDefaultAction((ModalContent)w);
        }
        return false;
    }

    private boolean handleModalFooter(ModalFooter footer) {
        for (Widget fw : footer) {
            Button b;
            if (fw instanceof ModalFooter) {
                return this.handleModalFooter((ModalFooter)fw);
            }
            if (!(fw instanceof Button) || !(b = (Button)fw).getType().equals((Object)ButtonType.PRIMARY)) continue;
            b.fireEvent((GwtEvent)new ClickEvent(){});
            return true;
        }
        return false;
    }

    public void setBody(Widget widget) {
        ModalBody body = new ModalBody();
        body.add(widget);
        this.add((Widget)body);
    }
}

