/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables.popup;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ControlLabel;
import com.github.gwtbootstrap.client.ui.Form;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.ext.widgets.common.client.resources.CommonImages;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.DataGridFilterSummary;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewFilterPopup
extends BaseModal {
    public static String FILTER_NAME_PARAM = "filterName";
    @UiField
    public TabPanel tabPanel;
    @UiField
    public Form horizontalForm;
    @UiField
    public FlowPanel existingFiltersPanel;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    HashMap formValues = new HashMap();
    private GridPreferencesStore gridPreferenceStore;
    private final List<ControlGroup> filterControlGroups = new ArrayList<ControlGroup>();
    private CommonImages images = (CommonImages)GWT.create(CommonImages.class);
    Command refreshFiltersCommand;
    protected AsyncDataProvider<DataGridFilterSummary> dataProvider;
    PagedTable<DataGridFilterSummary> existingFiltersGrid = new PagedTable(5);
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public NewFilterPopup() {
        this.createProvider();
        this.initColumns();
        this.setTitle(CommonConstants.INSTANCE.Filter_Management());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(CommonConstants.INSTANCE.OK(), new Command(){

            public void execute() {
                NewFilterPopup.this.okButton();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show(Command addfilterCommand, Command refreshFilters, GridPreferencesStore gridPreferenceStore) {
        this.addCreateFilterButton(addfilterCommand);
        this.refreshFiltersCommand = refreshFilters;
        this.gridPreferenceStore = gridPreferenceStore;
        this.refreshGrid();
        super.show();
    }

    private void okButton() {
        this.refreshFiltersCommand.execute();
        this.closePopup();
    }

    public void init() {
        this.horizontalForm.clear();
        this.filterControlGroups.clear();
        ControlGroup controlGroup = new ControlGroup();
        ControlLabel controlLabel = new ControlLabel();
        controlLabel.setTitle(CommonConstants.INSTANCE.Filter_Name());
        HTML lab = new HTML("<span style=\"color:red\"> * </span><span style=\"margin-right:10px\">" + CommonConstants.INSTANCE.Filter_Name() + "</span>");
        controlLabel.add((Widget)lab);
        TextBox fieldTextBox = new TextBox();
        fieldTextBox.setName(FILTER_NAME_PARAM);
        controlGroup.add((Widget)controlLabel);
        controlGroup.add((Widget)fieldTextBox);
        this.filterControlGroups.add(controlGroup);
        this.horizontalForm.add((Widget)controlGroup);
        this.existingFiltersPanel.clear();
        this.existingFiltersPanel.add(this.existingFiltersGrid);
        this.existingFiltersGrid.loadPageSizePreferences();
        this.existingFiltersGrid.setcolumnPickerButtonVisibe(false);
        this.existingFiltersGrid.setEmptyTableCaption(CommonConstants.INSTANCE.NoCustomFilterAvailable());
    }

    public void cleanFormValues(List<ControlGroup> controlGroups) {
        this.formValues = new HashMap();
        this.clearErrorMessages();
        for (ControlGroup groupControl : controlGroups) {
            if (groupControl.getWidget(1) instanceof TextBox) {
                ((TextBox)groupControl.getWidget(1)).setText("");
                continue;
            }
            if (!(groupControl.getWidget(1) instanceof ListBox)) continue;
            ListBox listBox = (ListBox)groupControl.getWidget(1);
            listBox.setSelectedIndex(-1);
        }
    }

    public void closePopup() {
        this.cleanFormValues(this.filterControlGroups);
        this.hide();
        super.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        this.clearErrorMessages();
        String filterName = (String)this.formValues.get(FILTER_NAME_PARAM);
        if (filterName == null || filterName.trim().length() == 0) {
            this.errorMessages.setText(CommonConstants.INSTANCE.Filter_Must_Have_A_Name());
            this.errorMessagesGroup.setType(ControlGroupType.ERROR);
            valid = false;
        } else {
            this.errorMessages.setText("");
            this.errorMessagesGroup.setType(ControlGroupType.NONE);
        }
        return valid;
    }

    public void getFormValues(List<ControlGroup> controlGroups) {
        this.formValues = new HashMap();
        for (ControlGroup groupControl : controlGroups) {
            if (groupControl.getWidget(1) instanceof TextBox) {
                this.formValues.put(((TextBox)groupControl.getWidget(1)).getName(), ((TextBox)groupControl.getWidget(1)).getValue());
                continue;
            }
            if (!(groupControl.getWidget(1) instanceof ListBox)) continue;
            ListBox listBox = (ListBox)groupControl.getWidget(1);
            ArrayList<String> selectedValues = new ArrayList<String>();
            for (int i = 0; i < listBox.getItemCount(); ++i) {
                if (!listBox.isItemSelected(i)) continue;
                selectedValues.add(listBox.getValue(i));
            }
            this.formValues.put(listBox.getName(), selectedValues);
        }
    }

    private void clearErrorMessages() {
        this.errorMessages.setText("");
    }

    public HashMap getFormValues() {
        return this.formValues;
    }

    public void addListBoxToFilter(String label, String fieldName, boolean multiselect, HashMap<String, String> listBoxInfo) {
        ControlGroup controlGroup = new ControlGroup();
        ControlLabel controlLabel = new ControlLabel();
        controlLabel.setTitle(label);
        HTML lab = new HTML("<span style=\"margin-right:10px\">" + label + "</span>");
        controlLabel.add((Widget)lab);
        ListBox listBox = new ListBox(multiselect);
        if (listBoxInfo != null) {
            Set<String> listBoxKeys = listBoxInfo.keySet();
            for (String key : listBoxKeys) {
                listBox.addItem(listBoxInfo.get(key), key);
            }
        }
        listBox.setName(fieldName);
        controlGroup.add((Widget)controlLabel);
        controlGroup.add((Widget)listBox);
        this.filterControlGroups.add(controlGroup);
        this.horizontalForm.add((Widget)controlGroup);
    }

    public void addTextBoxToFilter(String label, String fieldName) {
        this.addTextBoxToFilter(label, fieldName, "");
    }

    public void addTextBoxToFilter(String label, String fieldName, String defaultValue) {
        ControlGroup controlGroup = new ControlGroup();
        ControlLabel controlLabel = new ControlLabel();
        controlLabel.setTitle(label);
        HTML lab = new HTML("<span style=\"margin-right:10px\">" + label + "</span>");
        controlLabel.add((Widget)lab);
        TextBox textBox = new TextBox();
        textBox.setName(fieldName);
        if (defaultValue != null && defaultValue.trim().length() > 0) {
            textBox.setText(defaultValue);
        }
        controlGroup.add((Widget)controlLabel);
        controlGroup.add((Widget)textBox);
        this.filterControlGroups.add(controlGroup);
        this.horizontalForm.add((Widget)controlGroup);
    }

    private void createProvider() {
        this.dataProvider = new AsyncDataProvider<DataGridFilterSummary>(){

            protected void onRangeChanged(HasData<DataGridFilterSummary> display) {
                Range visibleRange = display.getVisibleRange();
                List currentCustomFilters = NewFilterPopup.this.getData();
                NewFilterPopup.this.dataProvider.updateRowCount(currentCustomFilters.size(), true);
                int endRange = visibleRange.getStart() + 5 < currentCustomFilters.size() ? visibleRange.getStart() + 5 : currentCustomFilters.size();
                NewFilterPopup.this.dataProvider.updateRowData(visibleRange.getStart(), currentCustomFilters.subList(visibleRange.getStart(), endRange));
            }
        };
        this.existingFiltersGrid.setDataProvider(this.dataProvider);
    }

    private List<DataGridFilterSummary> getData() {
        HashMap storedCustomFilters;
        ArrayList<DataGridFilterSummary> customFilters = new ArrayList<DataGridFilterSummary>();
        if (this.gridPreferenceStore != null && (storedCustomFilters = this.gridPreferenceStore.getCustomFilters()) != null && storedCustomFilters.size() > 0) {
            Set customFilterKeys = storedCustomFilters.keySet();
            for (String customFilterName : customFilterKeys) {
                customFilters.add(new DataGridFilterSummary(customFilterName));
            }
        }
        return customFilters;
    }

    public void initColumns() {
        Column descriptionColumn = this.initDescriptionColumn();
        Column actionsColumn = this.initActionsColumn();
        ArrayList columnMetas = new ArrayList();
        columnMetas.add(new ColumnMeta(descriptionColumn, CommonConstants.INSTANCE.Filter_Name()));
        columnMetas.add(new ColumnMeta(actionsColumn, CommonConstants.INSTANCE.Actions()));
        this.existingFiltersGrid.addColumns(columnMetas);
    }

    private Column initDescriptionColumn() {
        Column<DataGridFilterSummary, String> descriptionColumn = new Column<DataGridFilterSummary, String>((Cell)new TextCell()){

            public String getValue(DataGridFilterSummary object) {
                return object.getFilterName();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName("log.filterName");
        return descriptionColumn;
    }

    private Column initActionsColumn() {
        LinkedList<RemoveActionHasCell> cells = new LinkedList<RemoveActionHasCell>();
        cells.add(new RemoveActionHasCell("Remove", new ActionCell.Delegate<DataGridFilterSummary>(){

            public void execute(DataGridFilterSummary filter) {
                NewFilterPopup.this.gridPreferenceStore.removeCustomFilter(filter.getFilterName());
                NewFilterPopup.this.refreshGrid();
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<DataGridFilterSummary, DataGridFilterSummary> actionsColumn = new Column<DataGridFilterSummary, DataGridFilterSummary>((Cell)cell){

            public DataGridFilterSummary getValue(DataGridFilterSummary object) {
                return object;
            }
        };
        return actionsColumn;
    }

    public void refreshGrid() {
        HasData next = (HasData)this.dataProvider.getDataDisplays().iterator().next();
        next.setVisibleRangeAndClearData(next.getVisibleRange(), true);
    }

    private void addCreateFilterButton(final Command addfilterCommand) {
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setWidth("100%");
        buttonPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        Button createFilterButton = new Button();
        createFilterButton.setText(CommonConstants.INSTANCE.Add_New_Filter());
        createFilterButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewFilterPopup.this.getFormValues(NewFilterPopup.this.filterControlGroups);
                if (NewFilterPopup.this.validateForm()) {
                    addfilterCommand.execute();
                    NewFilterPopup.this.refreshGrid();
                    NewFilterPopup.this.cleanFormValues(NewFilterPopup.this.filterControlGroups);
                    NewFilterPopup.this.tabPanel.selectTab(1);
                }
            }
        });
        buttonPanel.add((Widget)createFilterButton);
        this.horizontalForm.add((Widget)buttonPanel);
    }

    private class RemoveActionHasCell
    implements HasCell<DataGridFilterSummary, DataGridFilterSummary> {
        private ActionCell<DataGridFilterSummary> cell;

        public RemoveActionHasCell(String text, ActionCell.Delegate<DataGridFilterSummary> delegate) {
            this.cell = new ActionCell<DataGridFilterSummary>(text, delegate){

                public void render(Cell.Context context, DataGridFilterSummary value, SafeHtmlBuilder sb) {
                    AbstractImagePrototype imageProto = AbstractImagePrototype.create((ImageResource)NewFilterPopup.this.images.close());
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<span title='" + CommonConstants.INSTANCE.RemoveFilter() + " " + value.getFilterName() + "' style='margin-right:5px;'>");
                    mysb.append(imageProto.getSafeHtml());
                    mysb.appendHtmlConstant("</span>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<DataGridFilterSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<DataGridFilterSummary, DataGridFilterSummary> getFieldUpdater() {
            return null;
        }

        public DataGridFilterSummary getValue(DataGridFilterSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, NewFilterPopup> {
    }
}

