/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.colorpicker;

import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorChangedEvent;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorChangedHandler;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorUtils;
import org.uberfire.ext.widgets.common.client.colorpicker.canvas.Canvas;
import org.uberfire.ext.widgets.common.client.colorpicker.canvas.Gradient;
import org.uberfire.ext.widgets.common.client.colorpicker.canvas.ImageData;
import org.uberfire.ext.widgets.common.client.colorpicker.canvas.RenderingContext;

public class SaturationLightnessPicker
extends Composite {
    private Canvas canvas = new Canvas();
    private int hue = 180;
    private int handleX = 90;
    private int handleY = 90;
    private boolean mouseDown;

    public SaturationLightnessPicker() {
        this.canvas.setCanvasSize(180, 180);
        this.initWidget((Widget)this.canvas);
        this.canvas.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                SaturationLightnessPicker.this.handleX = event.getRelativeX((Element)SaturationLightnessPicker.this.canvas.getElement());
                SaturationLightnessPicker.this.handleY = event.getRelativeY((Element)SaturationLightnessPicker.this.canvas.getElement());
                SaturationLightnessPicker.this.drawGradient(false);
                String color = SaturationLightnessPicker.this.getColorAtPixel(SaturationLightnessPicker.this.handleX, SaturationLightnessPicker.this.handleY);
                SaturationLightnessPicker.this.drawGradient(true);
                SaturationLightnessPicker.this.fireColorChanged(color);
                SaturationLightnessPicker.this.mouseDown = true;
            }
        });
        this.canvas.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (SaturationLightnessPicker.this.mouseDown) {
                    SaturationLightnessPicker.this.handleX = event.getRelativeX((Element)SaturationLightnessPicker.this.canvas.getElement());
                    SaturationLightnessPicker.this.handleY = event.getRelativeY((Element)SaturationLightnessPicker.this.canvas.getElement());
                    SaturationLightnessPicker.this.drawGradient(false);
                    String color = SaturationLightnessPicker.this.getColorAtPixel(SaturationLightnessPicker.this.handleX, SaturationLightnessPicker.this.handleY);
                    SaturationLightnessPicker.this.drawGradient(true);
                    SaturationLightnessPicker.this.fireColorChanged(color);
                }
            }
        });
        this.canvas.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                SaturationLightnessPicker.this.mouseDown = false;
            }
        });
        this.canvas.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                SaturationLightnessPicker.this.mouseDown = false;
            }
        });
    }

    protected void onAttach() {
        super.onAttach();
        this.drawGradient(true);
    }

    private void drawGradient(boolean drawHandle) {
        RenderingContext ctx = this.canvas.getContext();
        for (int x = 0; x <= 179; ++x) {
            Gradient grad = ctx.createLinearGradient(x, 0, x, 179);
            int s = Math.round(x * 100 / 179);
            String hex = ColorUtils.hsl2hex(this.hue, s, 0);
            grad.addColorStop(0, "#" + hex);
            hex = ColorUtils.hsl2hex(this.hue, s, 100);
            grad.addColorStop(1, "#" + hex);
            ctx.setFillStyle(grad);
            ctx.fillRect(x, 0, 1, 180);
        }
        if (drawHandle) {
            ctx.beginPath();
            ctx.arc(this.handleX, this.handleY, 3.0, 0.0, Math.PI * 2, false);
            ctx.closePath();
            ctx.setFillStyle("#ffffff");
            ctx.fill();
            ctx.beginPath();
            ctx.arc(this.handleX, this.handleY, 2.0, 0.0, Math.PI * 2, false);
            ctx.closePath();
            ctx.setFillStyle("#000000");
            ctx.fill();
        }
    }

    public HandlerRegistration addColorChangedHandler(ColorChangedHandler handler) {
        return this.addHandler(handler, ColorChangedEvent.getType());
    }

    private void fireColorChanged(String color) {
        this.fireEvent(new ColorChangedEvent(color));
    }

    private String getColorAtPixel(int x, int y) {
        x = Math.max(Math.min(x, 179), 0);
        y = Math.max(Math.min(y, 179), 0);
        RenderingContext ctx = this.canvas.getContext();
        ImageData imageData = ctx.getImageData(x, y, 1, 1);
        JsArrayInteger data = imageData.getData();
        return ColorUtils.rgb2hex(data.get(0), data.get(1), data.get(2));
    }

    public void setHue(int hue) {
        this.hue = hue;
        this.drawGradient(false);
        String color = this.getColorAtPixel(this.handleX, this.handleY);
        this.drawGradient(true);
        this.fireColorChanged(color);
    }

    public String getColor() {
        this.drawGradient(false);
        String color = this.getColorAtPixel(this.handleX, this.handleY);
        this.drawGradient(true);
        return color;
    }

    public void setColor(String color) {
        int[] rgb = ColorUtils.getRGB(color);
        int[] hsl = ColorUtils.rgb2hsl(rgb);
        this.hue = hsl[0];
        this.handleX = (int)Math.min(Math.max(Math.round((double)hsl[1] * 180.0 / 100.0), 0L), 179L);
        this.handleY = (int)Math.min(Math.max(Math.round((double)hsl[2] * 180.0 / 100.0), 0L), 179L);
        this.drawGradient(true);
        this.fireColorChanged(color);
    }
}

