/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.timeline.simple;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import org.ext.uberfire.social.activities.client.resources.i18n.Constants;
import org.ext.uberfire.social.activities.client.widgets.item.SimpleItemWidget;
import org.ext.uberfire.social.activities.client.widgets.item.bundle.SocialBundleHelper;
import org.ext.uberfire.social.activities.client.widgets.item.model.SimpleItemWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.pagination.Pager;
import org.ext.uberfire.social.activities.client.widgets.timeline.simple.model.SimpleSocialTimelineWidgetModel;
import org.ext.uberfire.social.activities.model.PagedSocialQuery;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.service.SocialTypeTimelinePagedRepositoryAPI;
import org.ext.uberfire.social.activities.service.SocialUserTimelinePagedRepositoryAPI;
import org.gwtbootstrap3.client.ui.MediaList;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;

public class SimpleSocialTimelineWidget
extends Composite {
    static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    MediaList itemsPanel;
    @UiField
    FlowPanel pagination;
    private SimpleSocialTimelineWidgetModel model;

    public SimpleSocialTimelineWidget(SimpleSocialTimelineWidgetModel model) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.model = model;
        this.setupPaginationLinks();
        this.refreshTimelineWidget();
    }

    private void refreshTimelineWidget() {
        this.itemsPanel.clear();
        this.createWidgets();
    }

    private void createWidgets() {
        this.pagination.clear();
        if (this.model.isSocialTypeWidget()) {
            this.createSociaTypelItemsWidget();
        } else {
            this.createUserTimelineItemsWidget();
        }
    }

    private void createUserTimelineItemsWidget() {
        ((SocialUserTimelinePagedRepositoryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<PagedSocialQuery>(){

            public void callback(PagedSocialQuery paged) {
                SimpleSocialTimelineWidget.this.createTimeline(paged);
            }
        }, SocialUserTimelinePagedRepositoryAPI.class)).getUserTimeline(this.model.getSocialUser(), this.model.getSocialPaged(), this.model.getPredicate());
    }

    private void createSociaTypelItemsWidget() {
        ((SocialTypeTimelinePagedRepositoryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<PagedSocialQuery>(){

            public void callback(PagedSocialQuery paged) {
                SimpleSocialTimelineWidget.this.createTimeline(paged);
            }
        }, SocialTypeTimelinePagedRepositoryAPI.class)).getEventTimeline(this.model.getSocialEventType().name(), this.model.getSocialPaged(), this.model.getPredicate());
    }

    private void createTimeline(PagedSocialQuery paged) {
        if (this.thereIsNoEvents(paged)) {
            this.displayNoEvents();
        } else {
            this.displayEvents(paged);
        }
    }

    private void displayNoEvents() {
        this.pagination.add((Widget)new Paragraph(Constants.INSTANCE.NoSocialEvents()));
    }

    private boolean thereIsNoEvents(PagedSocialQuery paged) {
        return paged.socialEvents().isEmpty() && !paged.socialPaged().canIGoBackward();
    }

    private void displayEvents(PagedSocialQuery paged) {
        this.model.updateSocialPaged(paged.socialPaged());
        for (SocialActivitiesEvent event : paged.socialEvents()) {
            if (event.hasLink()) {
                this.createSimpleWidgetWithLink(event);
                continue;
            }
            this.createSimpleWidget(event);
        }
        this.setupPaginationButtonsSocial();
    }

    private void createSimpleWidgetWithLink(SocialActivitiesEvent event) {
        final SimpleItemWidgetModel itemModel = new SimpleItemWidgetModel(this.model, event.getType(), event.getTimestamp(), event.getLinkLabel(), event.getLinkTarget(), event.getLinkType(), SocialBundleHelper.getItemDescription(event.getAdicionalInfos()), event.getSocialUser()).withLinkCommand(this.model.getLinkCommand()).withLinkParams(event.getLinkParams());
        if (event.isVFSLink()) {
            ((VFSService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<Path>(){

                public void callback(Path path) {
                    itemModel.withLinkPath(path);
                    SimpleSocialTimelineWidget.this.addItemWidget(itemModel);
                }
            }, VFSService.class)).get(event.getLinkTarget());
        } else {
            this.addItemWidget(itemModel);
        }
    }

    private void addItemWidget(SimpleItemWidgetModel model) {
        SimpleItemWidget item = (SimpleItemWidget)((Object)GWT.create(SimpleItemWidget.class));
        item.init(model);
        this.itemsPanel.add((Widget)item);
    }

    private void createSimpleWidget(SocialActivitiesEvent event) {
        SimpleItemWidgetModel rowModel = new SimpleItemWidgetModel(event.getType(), event.getTimestamp(), event.getDescription(), SocialBundleHelper.getItemDescription(event.getAdicionalInfos()), event.getSocialUser()).withLinkParams(event.getLinkParams());
        this.addItemWidget(rowModel);
    }

    private void setupPaginationButtonsSocial() {
        Pager pager = new Pager();
        if (this.canICreateLessLink()) {
            pager.add((Widget)this.model.getLess());
        }
        if (this.canICreateMoreLink()) {
            pager.add((Widget)this.model.getMore());
        }
        if (this.canICreateLessLink() || this.canICreateMoreLink()) {
            this.pagination.add((Widget)pager);
        }
    }

    private boolean canICreateMoreLink() {
        return this.model.getSocialPaged().canIGoForward() && this.model.getMore() != null;
    }

    private boolean canICreateLessLink() {
        return this.model.getSocialPaged().canIGoBackward() && this.model.getLess() != null;
    }

    private void setupPaginationLinks() {
        if (this.model.getLess() != null) {
            this.createLessLink();
        }
        if (this.model.getMore() != null) {
            this.createMoreLink();
        }
    }

    private void createMoreLink() {
        this.model.getMore().addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleSocialTimelineWidget.this.model.getSocialPaged().forward();
                SimpleSocialTimelineWidget.this.refreshTimelineWidget();
            }
        }, ClickEvent.getType());
    }

    private void createLessLink() {
        this.model.getLess().addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleSocialTimelineWidget.this.model.getSocialPaged().backward();
                SimpleSocialTimelineWidget.this.refreshTimelineWidget();
            }
        }, ClickEvent.getType());
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SimpleSocialTimelineWidget> {
    }
}

