/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.item;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.ext.uberfire.social.activities.client.widgets.item.CommentRowWidget;
import org.ext.uberfire.social.activities.client.widgets.item.model.LinkCommandParams;
import org.ext.uberfire.social.activities.client.widgets.item.model.SocialItemExpandedWidgetModel;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.UpdateItem;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserRepositoryAPI;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.ImageAnchor;
import org.gwtbootstrap3.client.ui.MediaList;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.resources.UberfireResources;
import org.uberfire.client.workbench.type.ClientResourceType;

public class SocialItemExpandedWidget
extends Composite {
    private static final Image GENERIC_FILE_IMAGE = new Image(UberfireResources.INSTANCE.images().typeGenericFile());
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    FlowPanel left;
    @UiField
    Paragraph desc;
    @UiField
    MediaList items;

    public void init(SocialItemExpandedWidgetModel model) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.createItem(model);
    }

    public void createItem(SocialItemExpandedWidgetModel model) {
        this.createFirstRow(model);
        for (UpdateItem updateItem : model.getUpdateItems()) {
            this.createSecondRow(model, updateItem);
        }
    }

    public void createFirstRow(SocialItemExpandedWidgetModel model) {
        this.createIcon(model);
        this.createLink(model);
    }

    private void createIcon(final SocialItemExpandedWidgetModel model) {
        UpdateItem updateItem = model.getUpdateItems().get(0);
        if (updateItem.getEvent().isVFSLink()) {
            ((VFSService)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<Path>(){

                public void callback(Path path) {
                    for (ClientResourceType type : model.getModel().getResourceTypes()) {
                        if (!type.accept(path)) continue;
                        SocialItemExpandedWidget.this.addIconImage((Image)type.getIcon());
                        break;
                    }
                }
            }, VFSService.class)).get(updateItem.getEvent().getLinkTarget());
        } else {
            this.addIconImage(GENERIC_FILE_IMAGE);
        }
    }

    private void addIconImage(Image image) {
        ImageAnchor newImage = new ImageAnchor();
        newImage.setUrl(image.getUrl());
        newImage.setAsMediaObject(true);
        this.left.add((Widget)newImage);
    }

    private void createLink(final SocialItemExpandedWidgetModel model) {
        final UpdateItem updateItem = model.getUpdateItems().get(0);
        Anchor link = new Anchor();
        link.setText(updateItem.getEvent().getLinkLabel());
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.getModel().getLinkCommand().execute((Object)new LinkCommandParams(updateItem.getEvent().getType(), updateItem.getEvent().getLinkTarget(), updateItem.getEvent().getLinkType()).withLinkParams(updateItem.getEvent().getLinkParams()));
            }
        });
        this.desc.add((Widget)link);
    }

    public void createSecondRow(final SocialItemExpandedWidgetModel model, final UpdateItem updateItem) {
        ((SocialUserRepositoryAPI)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<SocialUser>(){

            public void callback(SocialUser socialUser) {
                CommentRowWidget row = (CommentRowWidget)((Object)GWT.create(CommentRowWidget.class));
                updateItem.setSocialUser(socialUser);
                updateItem.setUserClickCommand(model.getModel().getUserClickCommand());
                updateItem.setFollowUnfollowCommand(model.getModel().getFollowUnfollowCommand());
                updateItem.setLoggedUser(model.getModel().getSocialUser());
                row.init(updateItem);
                SocialItemExpandedWidget.this.items.add((Widget)row);
            }
        }, SocialUserRepositoryAPI.class)).findSocialUser(updateItem.getEvent().getSocialUser().getUserName());
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SocialItemExpandedWidget> {
    }
}

