/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.client.widgets.timeline.regular.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ext.uberfire.social.activities.client.widgets.timeline.regular.model.UpdateItem;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;

public class RecentUpdatesModel {
    private Map<String, List<UpdateItem>> updateItems = new LinkedHashMap<String, List<UpdateItem>>();

    private RecentUpdatesModel() {
    }

    public static RecentUpdatesModel generate(List<SocialActivitiesEvent> events) {
        RecentUpdatesModel.sort(events);
        RecentUpdatesModel recentUpdatesModel = new RecentUpdatesModel();
        for (SocialActivitiesEvent event : events) {
            recentUpdatesModel.add(event.getLinkLabel(), new UpdateItem(event));
        }
        return recentUpdatesModel;
    }

    private static void sort(List<SocialActivitiesEvent> events) {
        Collections.sort(events, RecentUpdatesModel.reverseDateComparator());
    }

    private static Comparator<SocialActivitiesEvent> reverseDateComparator() {
        return new Comparator<SocialActivitiesEvent>(){

            @Override
            public int compare(SocialActivitiesEvent o1, SocialActivitiesEvent o2) {
                Date date2;
                Date date1 = o1.getTimestamp();
                if (date1.compareTo(date2 = o2.getTimestamp()) == -1) {
                    return 1;
                }
                if (date1.compareTo(date2) == 1) {
                    return -1;
                }
                return 0;
            }
        };
    }

    private static Comparator<UpdateItem> dateComparator() {
        return new Comparator<UpdateItem>(){

            @Override
            public int compare(UpdateItem o1, UpdateItem o2) {
                Date date1 = o1.getEvent().getTimestamp();
                Date date2 = o2.getEvent().getTimestamp();
                return date1.compareTo(date2);
            }
        };
    }

    private void add(String linkTarget, UpdateItem updateItem) {
        List<UpdateItem> items = this.updateItems.get(linkTarget);
        if (items == null) {
            items = new ArrayList<UpdateItem>();
        }
        items.add(updateItem);
        this.updateItems.put(linkTarget, items);
    }

    public Map<String, List<UpdateItem>> getUpdateItems() {
        return this.updateItems;
    }

    public List<UpdateItem> getUpdateItems(String key) {
        List<UpdateItem> items = this.updateItems.get(key);
        if (items == null) {
            items = new ArrayList<UpdateItem>();
        }
        Collections.sort(items, RecentUpdatesModel.dateComparator());
        return items;
    }
}

