/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.BaseUploadServlet;
import org.uberfire.server.UploadUriProvider;

public class FileUploadServlet
extends BaseUploadServlet {
    private static final String RESPONSE_OK = "OK";
    private static final String RESPONSE_FAIL = "FAIL";
    private static final String RESPONSE_CONFLICT = "CONFLICT";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            URI targetLocation = UploadUriProvider.getTargetLocation(request);
            boolean isUpdate = UploadUriProvider.isUpdate(request);
            this.finalizeResponse(response, this.getFileItem(request), targetLocation, isUpdate);
        }
        catch (FileUploadException e) {
            this.logError(e);
            this.writeResponse(response, RESPONSE_FAIL);
        }
        catch (URISyntaxException e) {
            this.logError(e);
            this.writeResponse(response, RESPONSE_FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeResponse(HttpServletResponse response, FileItem fileItem, URI uri, boolean isUpdate) throws IOException {
        if (!this.validateAccess(uri, response)) {
            return;
        }
        Path path = this.ioService.get(uri);
        try {
            this.ioService.startBatch(path.getFileSystem());
            if (this.ioService.exists(path) && !isUpdate) {
                this.writeResponse(response, RESPONSE_CONFLICT);
                response.sendError(409);
                return;
            }
            this.writeFile(this.ioService, path, fileItem);
        }
        finally {
            this.ioService.endBatch();
        }
        this.writeResponse(response, RESPONSE_OK);
    }
}

