/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server.cdi;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;

public class UberFireGeneralFactory {
    @Inject
    private Instance<User> user;

    @Produces
    @RequestScoped
    @Default
    public SessionInfo getSessionInfo(AuthenticationService authenticationService) {
        User user;
        String sessionId = this.getSessionId();
        if (sessionId == null) {
            user = this.getDefaultUser();
            sessionId = user.getIdentifier();
        } else {
            user = authenticationService.getUser();
        }
        return new SessionInfoImpl(sessionId, user);
    }

    private User getDefaultUser() {
        if (this.user.isAmbiguous() || this.user.isUnsatisfied()) {
            throw new IllegalStateException("Cannot get session info outside of servlet thread when no default user is provided.");
        }
        return (User)this.user.get();
    }

    private String getSessionId() {
        return RpcContext.getMessage() != null && RpcContext.getQueueSession() != null ? RpcContext.getQueueSession().getSessionId() : null;
    }
}

